/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.log.impl;

import com.sap.aii.util.log.api.Level;
import com.sap.aii.util.log.api.LogFactory;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.log.event.LogAdminEvent;
import com.sap.aii.util.log.event.LogAdminEventListener;
import com.sap.aii.util.log.impl.LogContext;
import com.sap.aii.util.log.impl.LoggerImpl;
import com.sap.aii.util.log.impl.PropertiesConfigurator;
import java.util.Iterator;
import java.util.Vector;

public class AIILogFactoryImpl
implements LogFactory {
    public static final String implName = "AII Logging";
    public static final String implVersion = "2.1";
    public static final String UNKNOWN_CLASS = "UnknownClass";
    public static final String UNKNOWN_METHOD = "UnknownClass.method";
    static LogContext logContext = new DefaultContext();
    private static Vector adminListeners = new Vector();

    public static AIILogFactoryImpl getInstance() {
        return new AIILogFactoryImpl();
    }

    public String getImplementationName() {
        return implName;
    }

    public String getImplementationVersion() {
        return implVersion;
    }

    public void setActive(boolean active) {
        LoggerImpl.active = active;
    }

    public Logger getRootLogger() {
        return LoggerImpl.ROOT;
    }

    public Logger getLogger(String name) {
        return LoggerImpl.getInstance(name);
    }

    public Logger[] getAllLoggers() {
        return LoggerImpl.categoryMap.values().toArray(new Logger[0]);
    }

    public Level getLevel(String name) {
        return Level.getLevel(name);
    }

    public Level[] getAllLevels() {
        return Level.getAllLevels();
    }

    public void initConfiguration() {
        PropertiesConfigurator.init();
    }

    public void clearConfiguration() {
        Iterator i = LoggerImpl.categoryMap.keySet().iterator();
        while (i.hasNext()) {
            LoggerImpl l = (LoggerImpl)LoggerImpl.categoryMap.get((String)i.next());
            l.removeAllHandlers();
            l.setLevel(null);
            l.setUseParentHandlers(true);
        }
    }

    public static void setLogContext(LogContext context) {
        logContext = context;
    }

    static boolean hasAdminListeners() {
        return !adminListeners.isEmpty();
    }

    public static void addLogAdminEventListener(LogAdminEventListener listener) {
        adminListeners.add(listener);
    }

    public static void removeLogAdminEventListener(LogAdminEventListener listener) {
        adminListeners.remove(listener);
    }

    static void fireLogAdminEvent(LogAdminEvent event) {
        int i = 0;
        while (i < adminListeners.size()) {
            LogAdminEventListener l = (LogAdminEventListener)adminListeners.get(i);
            l.adminEvent(event);
            ++i;
        }
    }

    private static class DefaultContext
    implements LogContext {
        private DefaultContext() {
        }

        public String getCurrentUser() {
            return "?";
        }
    }
}

