/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.log.api;

import com.sap.aii.util.log.api.Level;
import com.sap.aii.util.log.api.LogManager;
import com.sap.aii.util.misc.api.BabelMessage;
import com.sap.aii.util.misc.api.IBaseException;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Locale;

public abstract class Logger {
    static final Locale DEFAULT_LOCALE = Locale.ENGLISH;

    public static Logger getLogger(String name) {
        return LogManager.getLogFactory().getLogger(name);
    }

    public abstract void log(Level var1, String var2, Throwable var3);

    public void log(Level level, String message) {
        this.log(level, message, null);
    }

    public void log(String message) {
        this.log(Level.DEFAULT, message);
    }

    public void log(Level level, BabelMessage message) {
        this.log(level, message.toString(DEFAULT_LOCALE), null);
    }

    public void log(Throwable throwable) {
        if (throwable instanceof IBaseException) {
            IBaseException exception = (IBaseException)((Object)throwable);
            this.log(exception.getSeverity(), exception.getMessage(DEFAULT_LOCALE), throwable);
        } else {
            this.log(Level.ERROR, throwable.getLocalizedMessage(), throwable);
        }
    }

    public void fatal(String message, Throwable t) {
        this.log(Level.FATAL, message, t);
    }

    public void error(String message, Throwable t) {
        this.log(Level.ERROR, message, t);
    }

    public void warning(String message, Throwable t) {
        this.log(Level.WARNING, message, t);
    }

    public void fatal(String message) {
        this.log(Level.FATAL, message, null);
    }

    public void error(String message) {
        this.log(Level.ERROR, message, null);
    }

    public void warning(String message) {
        this.log(Level.WARNING, message, null);
    }

    public void info(String message) {
        this.log(Level.INFO, message, null);
    }

    public void path(String message) {
        this.log(Level.PATH, message, null);
    }

    public void entering(String method) {
        this.log(Level.PATH, "entering: " + method, null);
    }

    public void exiting(String method) {
        this.log(Level.PATH, "exiting: " + method, null);
    }

    public void debug(String message) {
        this.log(Level.DEBUG, message, null);
    }

    public void fine(String message) {
        this.log(Level.FINE, message, null);
    }

    public void finer(String message) {
        this.log(Level.FINER, message, null);
    }

    public void finest(String message) {
        this.log(Level.FINEST, message, null);
    }

    public abstract void setLevel(Level var1);

    public abstract Level getLevel();

    public abstract Level getActiveLevel();

    public boolean isLoggable(Level level) {
        return this.getActiveLevel().compareTo(level) <= 0;
    }

    public abstract String getName();

    public String getShortName() {
        String name = this.getName();
        int pos = name.lastIndexOf(46);
        if (pos < 0) {
            return name;
        }
        return name.substring(pos + 1);
    }

    public abstract void setUseParentHandlers(boolean var1);

    public abstract Enumeration listHandlers();

    public boolean contains(Logger logger) {
        String name = logger.getName();
        String parentName = this.getName();
        if (parentName.equals("") || parentName.equals("ROOT")) {
            return true;
        }
        return name.startsWith(parentName) && name.charAt(parentName.length()) == '.';
    }

    public static class NameComparator
    implements Comparator {
        public int compare(Object o1, Object o2) throws ClassCastException {
            Logger log1 = (Logger)o1;
            Logger log2 = (Logger)o2;
            return log1.getName().compareTo(log2.getName());
        }

        public boolean equals(Object o1, Object o2) throws ClassCastException {
            return ((Logger)o1).getName().equals(((Logger)o2).getName());
        }
    }
}

