/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.hmi.api;

import com.sap.aii.util.hmi.api.HmiCoreException;
import com.sap.aii.util.hmi.core.bs.ByteStreamInString;
import com.sap.aii.util.hmi.core.gdi2.GenericAttributeMultivalue;
import com.sap.aii.util.hmi.core.gdi2.GenericAttributes;
import com.sap.aii.util.hmi.core.gdi2.GenericDataInstance;
import com.sap.aii.util.hmi.core.gdi2.GenericallyRepresentable;
import java.io.IOException;
import java.io.InputStream;

public class HmiMethodOutput
implements GenericallyRepresentable {
    String iReturnString;
    InputStream iReturnStream;
    String iContentType;
    private static String[] sAttributeNames = new String[]{"Return", "ContentType"};

    public HmiMethodOutput(String aReturnString) {
        this.iReturnString = aReturnString;
        this.iReturnStream = null;
        this.iContentType = "text/xml";
    }

    public HmiMethodOutput(String aReturnString, String aContentType) {
        this.iReturnString = aReturnString;
        this.iReturnStream = null;
        this.iContentType = aContentType;
    }

    public HmiMethodOutput(InputStream aReturnStream) {
        this.iReturnStream = aReturnStream;
        this.iReturnString = null;
        this.iContentType = "text/xml";
    }

    public HmiMethodOutput(InputStream aReturnStream, String aContentType) {
        this.iReturnStream = aReturnStream;
        this.iReturnString = null;
        this.iContentType = aContentType;
    }

    public boolean isReturnString() {
        return this.iReturnString != null;
    }

    public boolean isReturnStream() {
        return this.iReturnString == null;
    }

    public String getContentType() {
        return this.iContentType;
    }

    public String getReturn() {
        return this.getReturnString();
    }

    public String getReturnString() {
        if (!this.isReturnString()) {
            throw new RuntimeException("HmiMethodOutput is not return string!");
        }
        return this.iReturnString;
    }

    public InputStream getReturnStream() {
        if (!this.isReturnStream()) {
            throw new RuntimeException("HmiMethodOutput is not return stream!");
        }
        return this.iReturnStream;
    }

    private HmiMethodOutput() {
    }

    public static GenericDataInstance renderGdi(HmiMethodOutput aMethodOutput) throws HmiCoreException {
        if (aMethodOutput == null) {
            return null;
        }
        GenericDataInstance lMethodOutput = aMethodOutput.getState();
        return lMethodOutput;
    }

    public static HmiMethodOutput parseGdi(GenericDataInstance aMethodOutput) throws HmiCoreException {
        if (aMethodOutput == null) {
            return null;
        }
        HmiMethodOutput lMethodOutput = new HmiMethodOutput();
        lMethodOutput.setState(aMethodOutput);
        return lMethodOutput;
    }

    public void setState(GenericDataInstance aState) {
        String lReturnPacked = aState.getAttributes().getValue("Return").getString(0);
        Object lReturn = ByteStreamInString.unpackObject(lReturnPacked);
        if (lReturn instanceof String) {
            this.iReturnString = (String)lReturn;
            this.iReturnStream = null;
        } else if (lReturn instanceof InputStream) {
            this.iReturnString = null;
            this.iReturnStream = (InputStream)lReturn;
        } else {
            throw new RuntimeException("Unexpected type " + lReturn.getClass().getName());
        }
        this.iContentType = aState.getAttributes().getValue("ContentType").getString(0);
    }

    public GenericDataInstance getState() {
        String lReturnPacked;
        try {
            lReturnPacked = ByteStreamInString.packObject(this.isReturnString() ? this.iReturnString : this.iReturnStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        GenericAttributeMultivalue lReturn = new GenericAttributeMultivalue(lReturnPacked);
        GenericAttributeMultivalue lContentType = new GenericAttributeMultivalue(this.iContentType);
        GenericAttributes lAttributes = new GenericAttributes(sAttributeNames, new GenericAttributeMultivalue[]{lReturn, lContentType});
        return new GenericDataInstance(this.getClass().getName(), lAttributes);
    }
}

