/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.hmi.api;

import com.sap.aii.util.hmi.api.HmiCoreException;
import com.sap.aii.util.hmi.api.UriElement;
import com.sap.aii.util.hmi.core.bs.ByteStreamInString;
import com.sap.aii.util.hmi.core.gdi2.GdiForPrimitives;
import com.sap.aii.util.hmi.core.gdi2.GenericAttributeMultivalue;
import com.sap.aii.util.hmi.core.gdi2.GenericAttributes;
import com.sap.aii.util.hmi.core.gdi2.GenericDataInstance;
import com.sap.aii.util.hmi.core.gdi2.GenericallyRepresentable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class HmiMethodInput
implements GenericallyRepresentable {
    private Map iParameters;
    private static String[] sAttributeNames = new String[]{"Parameters"};

    public HmiMethodInput(Map aParameters) throws HmiCoreException {
        Iterator lParameterIterator = aParameters.entrySet().iterator();
        this.iParameters = new HashMap();
        while (lParameterIterator.hasNext()) {
            Map.Entry lParameter = lParameterIterator.next();
            if (!(lParameter.getKey() instanceof String)) {
                throw HmiCoreException.newParameterNameNotOfTypeString(lParameter.getKey(), lParameter.getValue(), lParameter.getKey().getClass().getName());
            }
            if (lParameter.getValue() instanceof String || lParameter.getValue() instanceof InputStream) continue;
            throw HmiCoreException.newParameterValueNotOfTypeString(lParameter.getKey(), lParameter.getValue(), lParameter.getValue().getClass().getName());
        }
        this.iParameters = new HashMap(aParameters);
        if (this.iParameters.size() == 0) {
            this.iParameters.put("com.sap.aii.util.hmi.api.HmiMethodInput", "NoParameters");
        }
    }

    public Map getParameters() {
        return this.iParameters;
    }

    private HmiMethodInput() {
    }

    public static GenericDataInstance renderGdi(HmiMethodInput aMethodInput) throws HmiCoreException {
        if (aMethodInput == null) {
            return null;
        }
        GenericDataInstance lMethodInput = aMethodInput.getState();
        return lMethodInput;
    }

    public static HmiMethodInput parseGdi(GenericDataInstance aMethodInput) throws HmiCoreException {
        if (aMethodInput == null) {
            return null;
        }
        HmiMethodInput lMethodInput = new HmiMethodInput();
        lMethodInput.setState(aMethodInput);
        return lMethodInput;
    }

    public void setState(GenericDataInstance aState) {
        GenericAttributeMultivalue lParameters = aState.getAttributes().getValue("Parameters");
        Map lPackedParameters = GdiForPrimitives.GdiMapStringString.parse(lParameters);
        this.iParameters = new HashMap();
        Iterator lPackedParameterIterator = lPackedParameters.entrySet().iterator();
        while (lPackedParameterIterator.hasNext()) {
            Map.Entry lPackedParameter = lPackedParameterIterator.next();
            String lParameterPackedValue = (String)lPackedParameter.getValue();
            Object lParameterValue = ByteStreamInString.unpackObject(lParameterPackedValue);
            this.iParameters.put(lPackedParameter.getKey(), lParameterValue);
        }
    }

    public GenericDataInstance getState() {
        HashMap lPackedParameters = new HashMap();
        Iterator lParameterIterator = this.iParameters.entrySet().iterator();
        while (lParameterIterator.hasNext()) {
            String lPackedParameterValue;
            Map.Entry lParameter = lParameterIterator.next();
            try {
                lPackedParameterValue = ByteStreamInString.packObject(lParameter.getValue());
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
            lPackedParameters.put(lParameter.getKey(), lPackedParameterValue);
        }
        GenericAttributeMultivalue lParameters = GdiForPrimitives.GdiMapStringString.render(lPackedParameters);
        GenericAttributes lAttributes = new GenericAttributes(sAttributeNames, new GenericAttributeMultivalue[]{lParameters});
        return new GenericDataInstance(this.getClass().getName(), lAttributes);
    }

    public static interface ReservedParameterKeys {
        public static final UriElement ServiceId = null;
        public static final UriElement MethodId = null;
    }
}

