/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.hmi.api;

import com.sap.aii.util.hmi.api.HmiCoreException;
import com.sap.aii.util.hmi.api.HmiExceptionAdapter;
import com.sap.aii.util.hmi.core.gdi2.GenericAttributeMultivalue;
import com.sap.aii.util.hmi.core.gdi2.GenericAttributes;
import com.sap.aii.util.hmi.core.gdi2.GenericDataInstance;
import com.sap.aii.util.hmi.core.gdi2.GenericallyRepresentable;
import com.sap.aii.util.log.api.Level;
import com.sap.aii.util.misc.api.BabelMessage;
import com.sap.aii.util.misc.api.ClientServerException;
import com.sap.aii.util.misc.api.HelperFunctions;
import com.sap.aii.util.misc.api.IBaseException;
import com.sap.aii.util.misc.api.ServerExceptionInfo;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;

public class HmiMethodFault
extends HmiExceptionAdapter
implements GenericallyRepresentable {
    private String iRootCauseAsString;
    private String iDetails;
    private static String[] sAttributeNames = new String[]{"LocalizedMessage", "OriginalStackTrace", "RootCauseAsString", "Details", "Severity"};

    public String getRootCauseAsString() {
        return this.iRootCauseAsString;
    }

    public String getDetails() {
        return this.iDetails;
    }

    public HmiMethodFault(Throwable aThrowable) {
        super(HmiMethodFault.getThrowableAsString(aThrowable));
        this.iRootCauseAsString = null;
        this.iDetails = null;
    }

    public HmiMethodFault(BabelMessage aBabelMessage, Throwable aRootCause) {
        super(aBabelMessage);
        this.iRootCauseAsString = HmiMethodFault.getThrowableAsString(aRootCause);
        this.iDetails = null;
    }

    public HmiMethodFault(BabelMessage aBabelMessage) {
        super(aBabelMessage);
        this.iRootCauseAsString = null;
        this.iDetails = null;
    }

    public HmiMethodFault(BabelMessage aBabelMessage, String aDetails) {
        super(aBabelMessage);
        this.iRootCauseAsString = null;
        this.iDetails = aDetails;
    }

    public HmiMethodFault(String aLocalizedMessage) {
        super(aLocalizedMessage);
        this.iRootCauseAsString = null;
        this.iDetails = null;
    }

    private HmiMethodFault() {
        this.iRootCauseAsString = null;
        this.iDetails = null;
    }

    public static GenericDataInstance renderGdi(HmiMethodFault aMethodFault) throws HmiCoreException {
        if (aMethodFault == null) {
            return null;
        }
        GenericDataInstance lMethodFault = aMethodFault.getState();
        return lMethodFault;
    }

    public static HmiMethodFault parseGdi(GenericDataInstance aMethodFault) throws HmiCoreException {
        if (aMethodFault == null) {
            return null;
        }
        HmiMethodFault lMethodFault = new HmiMethodFault();
        lMethodFault.setState(aMethodFault);
        return lMethodFault;
    }

    public void setState(GenericDataInstance aState) {
        this.setMessage(aState.getAttributes().getValue("LocalizedMessage").getString(0));
        this.iOriginalStackTrace = aState.getAttributes().getValue("OriginalStackTrace").getString(0);
        this.iRootCauseAsString = aState.getAttributes().getValue("RootCauseAsString").getString(0);
        GenericAttributeMultivalue lDetails = aState.getAttributes().getValue("Details");
        this.iDetails = lDetails == null ? "" : lDetails.getString(0);
        String lSeverity = aState.getAttributes().getValue("Severity").getString(0);
        Level lSeverityAsLevel = Level.getLevel(lSeverity);
        if (lSeverityAsLevel == null) {
            lSeverityAsLevel = Level.FATAL;
        }
        this.setSeverity(lSeverityAsLevel);
    }

    public GenericDataInstance getState() {
        GenericAttributeMultivalue lLocalizedMessage = new GenericAttributeMultivalue(this.getMessage());
        GenericAttributeMultivalue lOriginalStackTrace = new GenericAttributeMultivalue(this.getOriginalStackTrace());
        GenericAttributeMultivalue lRootCauseAsString = new GenericAttributeMultivalue(this.getRootCauseAsString());
        GenericAttributeMultivalue lDetails = new GenericAttributeMultivalue(this.getDetails());
        Level lSeverityAsLevel = this.getSeverity();
        String lSeverityAsString = lSeverityAsLevel != null ? lSeverityAsLevel.getName() : null;
        GenericAttributeMultivalue lSeverity = new GenericAttributeMultivalue(lSeverityAsString);
        GenericAttributes lAttributes = new GenericAttributes(sAttributeNames, new GenericAttributeMultivalue[]{lLocalizedMessage, lOriginalStackTrace, lRootCauseAsString, lDetails, lSeverity});
        return new GenericDataInstance(this.getClass().getName(), lAttributes);
    }

    private static String getThrowableAsString(Throwable aThrowable) {
        String lOutput = "";
        if (aThrowable instanceof ClientServerException) {
            lOutput = lOutput + "\nClientServerException exception:" + aThrowable.getMessage() + "\n" + HelperFunctions.getStackTraceAsString(aThrowable);
            List serializedExceptions = ((ClientServerException)aThrowable).getNestedInformation();
            Iterator lIterator = serializedExceptions.iterator();
            while (lIterator.hasNext()) {
                ServerExceptionInfo exceptionIfo = (ServerExceptionInfo)lIterator.next();
                lOutput = lOutput + "\nSerialized exception:" + exceptionIfo.getMessage() + "\n" + exceptionIfo.getStackTrace();
            }
        } else if (aThrowable instanceof IBaseException) {
            lOutput = lOutput + "\nIBaseException:" + aThrowable.getMessage() + "\n" + HelperFunctions.getStackTraceAsString(aThrowable);
            if (((IBaseException)((Object)aThrowable)).getRootCause() != null) {
                lOutput = lOutput + HmiMethodFault.getThrowableAsString(((IBaseException)((Object)aThrowable)).getRootCause());
            }
        } else if (aThrowable instanceof RemoteException) {
            lOutput = lOutput + "\nRemoteException:" + aThrowable.getMessage() + "\n" + HelperFunctions.getStackTraceAsString(aThrowable);
            Throwable lDetail = ((RemoteException)aThrowable).detail;
            if (lDetail != null) {
                lOutput = lOutput + "\nDetail of RemoteException:\n" + HmiMethodFault.getThrowableAsString(lDetail);
            }
        } else {
            lOutput = lOutput + "Plain exception:" + aThrowable.getMessage() + "\n" + HelperFunctions.getStackTraceAsString(aThrowable);
        }
        return lOutput;
    }
}

