/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.hmi.api;

import com.sap.aii.util.applcomp.ApplCompLevel;
import com.sap.aii.util.hmi.api.HmiClient;
import com.sap.aii.util.hmi.api.HmiClientAdapter;
import com.sap.aii.util.hmi.api.HmiCoreException;
import com.sap.aii.util.hmi.api.HmiHttpClientImpl;
import com.sap.aii.util.hmi.api.HmiInProcessClientFactory;
import com.sap.aii.util.hmi.api.IHmiConfiguration;
import com.sap.aii.util.hmi.api.IHmiHttpURLConnectionFactory;
import com.sap.aii.util.hmi.api.JdkHttpURLConnectionFactory;
import com.sap.aii.util.hmi.api.UriElement;
import com.sap.aii.util.log.api.Level;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.misc.api.Language;
import java.net.MalformedURLException;
import java.net.URL;

public class HmiClientFactory {
    private static final Logger sLogger = Logger.getLogger((class$com$sap$aii$util$hmi$api$HmiClientFactory == null ? (class$com$sap$aii$util$hmi$api$HmiClientFactory = HmiClientFactory.class$("com.sap.aii.util.hmi.api.HmiClientFactory")) : class$com$sap$aii$util$hmi$api$HmiClientFactory).getName());
    private static final String sHmiInProcessClientFactoryImplClassName = "com.sap.aii.ib.server.hmi.HmiInProcessClientFactoryImpl";
    private static HmiInProcessClientFactory sHmiInProcessClientFactory;
    private IHmiConfiguration iHmiConfiguration;
    private IHmiHttpURLConnectionFactory iHttpURLConnectionFactory;
    private SingleTargetConfiguration iSingleTargetConfiguration;
    static /* synthetic */ Class class$com$sap$aii$util$hmi$api$HmiClientFactory;

    private HmiInProcessClientFactory getHmiInProcessClientFactory() {
        if (sHmiInProcessClientFactory == null) {
            try {
                Class<?> lClass = Class.forName(sHmiInProcessClientFactoryImplClassName);
                Object lObject = lClass.newInstance();
                sHmiInProcessClientFactory = (HmiInProcessClientFactory)lObject;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not find class or create instance or downcast in-process client factory!, e");
            }
        }
        return sHmiInProcessClientFactory;
    }

    private IHmiConfiguration getHmiConfiguration() {
        return this.iHmiConfiguration;
    }

    private IHmiHttpURLConnectionFactory getHttpURLConnectionFactory() {
        return this.iHttpURLConnectionFactory;
    }

    private SingleTargetConfiguration getSingleTargetConfiguration() {
        return this.iSingleTargetConfiguration;
    }

    private boolean isSingleTarget() {
        return this.iSingleTargetConfiguration != null;
    }

    private HmiClientFactory(IHmiHttpURLConnectionFactory aHttpURLConnectionFactory, IHmiConfiguration aHmiConfiguration) {
        this.iHttpURLConnectionFactory = aHttpURLConnectionFactory;
        this.iHmiConfiguration = aHmiConfiguration;
        this.iSingleTargetConfiguration = null;
    }

    private HmiClientFactory(IHmiHttpURLConnectionFactory aHttpURLConnectionFactory, String aServerLogicalSystemName, String aServerApplicationId, String aServerApplicationContextRoot) {
        this.iHttpURLConnectionFactory = aHttpURLConnectionFactory;
        this.iHmiConfiguration = null;
        this.iSingleTargetConfiguration = new SingleTargetConfiguration(aServerLogicalSystemName, aServerApplicationId, aServerApplicationContextRoot);
    }

    public static HmiClientFactory createInstance(IHmiHttpURLConnectionFactory aHttpURLConnectionFactory, String aServerLogicalSystemName, String aServerApplicationId, String aServerApplicationContextRoot) {
        return new HmiClientFactory(aHttpURLConnectionFactory, aServerLogicalSystemName, aServerApplicationId, aServerApplicationContextRoot);
    }

    public static HmiClientFactory createInstance(String aServerLogicalSystemName, String aServerApplicationId, String aServerApplicationContextRoot) {
        return new HmiClientFactory(JdkHttpURLConnectionFactory.getInstance(), aServerLogicalSystemName, aServerApplicationId, aServerApplicationContextRoot);
    }

    public static HmiClientFactory createInstance(IHmiConfiguration aHmiConfiguration) {
        return new HmiClientFactory(JdkHttpURLConnectionFactory.getInstance(), aHmiConfiguration);
    }

    public static HmiClientFactory createInstance(IHmiHttpURLConnectionFactory aHttpURLConnectionFactory, IHmiConfiguration aHmiConfiguration) {
        return new HmiClientFactory(aHttpURLConnectionFactory, aHmiConfiguration);
    }

    public void destroyClient(HmiClient aClient) throws HmiCoreException {
        HmiClientAdapter lClient = (HmiClientAdapter)aClient;
        if (lClient.getRequiresSession()) {
            lClient.informServerOfClientDestruction();
        }
        lClient.freeResources();
    }

    public HmiClient createInProcessClient(boolean aRequiresHttpSession, UriElement aServiceId, String aServerLogicalSystemName, String aServerApplicationId, String aUser, String aPassword, Language aLanguage, ApplCompLevel aClientLevel) throws HmiCoreException {
        HmiClientAdapter lClient = this.getHmiInProcessClientFactory().createClient(aRequiresHttpSession, aServiceId, aUser, aPassword, aLanguage, aClientLevel);
        lClient.setServerLogicalSystemName(aServerLogicalSystemName);
        lClient.setServerApplicationId(aServerApplicationId);
        lClient.allocateResources();
        return lClient;
    }

    public HmiClient createClient(String aHttpRequestMethod, URL aServletUrl, boolean aRequiresHttpSession, UriElement aServiceId, String aUser, String aPassword, Language aLanguage, ApplCompLevel aLevel) throws HmiCoreException {
        HmiHttpClientImpl lClient = new HmiHttpClientImpl(this.getHttpURLConnectionFactory(), aHttpRequestMethod, aServletUrl, aRequiresHttpSession, aServiceId, aUser, aPassword, aLanguage, aLevel);
        ((HmiClientAdapter)lClient).allocateResources();
        return lClient;
    }

    private void checkContainer(String aTargetContainer) throws HmiCoreException {
        if (!("ejb".equals(aTargetContainer) || "web".equals(aTargetContainer) || "any".equals(aTargetContainer))) {
            String lMsg = "Invalid target container \"" + aTargetContainer + "\" (valid values are \"ejb\", \"web\", \"any\"). " + "Sorry, cannot derive URL => cannot create HMI client!";
            sLogger.log(Level.ERROR, lMsg);
            throw HmiCoreException.newProgrammingModelViolation(this.getClass().getName(), "createClient", lMsg);
        }
    }

    private URL deriveServletInternalClientUrl(String aTargetContainer, String aServiceId) throws HmiCoreException {
        this.checkContainer(aTargetContainer);
        try {
            String lUrlContextRoot = this.iSingleTargetConfiguration.iServerApplicationContextRoot;
            String lUrlPath = "/" + aServiceId.toLowerCase() + "/int" + "?" + "container" + "=" + aTargetContainer;
            String lUrlAsString = lUrlContextRoot + lUrlPath;
            URL lUrl = new URL(lUrlAsString);
            return lUrl;
        }
        catch (MalformedURLException e) {
            throw HmiCoreException.newConfigurationError("ServletUrl", "Malformed URL exception, message: " + e.getMessage());
        }
    }

    private URL deriveServletInternalClientUrl(String aTargetContainer, String aServerLogicalSystemName, String aServerApplicationId, String aServiceId) throws HmiCoreException {
        this.checkContainer(aTargetContainer);
        try {
            String lSai = aServerApplicationId;
            String lSlsn = aServerLogicalSystemName;
            String lUrlProtocol = this.getHmiConfiguration().getServletUrlProtocol(lSai, lSlsn);
            String lUrlHost = this.getHmiConfiguration().getServletUrlHost(lSai, lSlsn);
            int lUrlPort = this.getHmiConfiguration().getServletUrlPort(lSai, lSlsn);
            String lUrlContextRoot = this.getHmiConfiguration().getServletUrlContextRoot(lSai, lSlsn);
            String lQueryString = this.getHmiConfiguration().getServletUrlInternalClientQueryString(lSai, lSlsn);
            String lUrlPath = this.getHmiConfiguration().getServletPath(aServiceId) + this.getHmiConfiguration().getServletUrlInternalClientPath(lSai, lSlsn) + "?" + "container" + "=" + aTargetContainer + (lQueryString == null ? "" : "&" + lQueryString);
            URL lUrl = new URL(lUrlProtocol, lUrlHost, lUrlPort, lUrlContextRoot + lUrlPath);
            return lUrl;
        }
        catch (MalformedURLException e) {
            throw HmiCoreException.newConfigurationError("ServletUrl", "Malformed URL exception, message: " + e.getMessage());
        }
    }

    public HmiClient createClient(String aTargetContainerId, boolean aRequiresHttpSession, UriElement aServiceId, String aUser, String aPassword, Language aLanguage, ApplCompLevel aLevel) throws HmiCoreException {
        if (!this.isSingleTarget()) {
            String lMsg = "Factory is not \"single-target\". Sorry, cannot derive URL => cannot create HMI client!";
            sLogger.log(Level.ERROR, lMsg);
            throw HmiCoreException.newProgrammingModelViolation(this.getClass().getName(), "createClient", lMsg);
        }
        String lHttpRequestMethod = "POST";
        URL lServletUrl = this.deriveServletInternalClientUrl(aTargetContainerId, aServiceId.toString());
        String lSai = this.iSingleTargetConfiguration.iServerApplicationId;
        String lSlsn = this.iSingleTargetConfiguration.iServerLogicalSystemName;
        HmiHttpClientImpl lClient = new HmiHttpClientImpl(this.getHttpURLConnectionFactory(), lHttpRequestMethod, lServletUrl, aRequiresHttpSession, aServiceId, aUser, aPassword, aLanguage, aLevel);
        lClient.setServerLogicalSystemName(lSlsn);
        lClient.setServerApplicationId(lSai);
        ((HmiClientAdapter)lClient).allocateResources();
        return lClient;
    }

    public HmiClient createClient(String aTargetContainerId, String aServerLogicalSystemName, String aServerApplicationId, boolean aRequiresHttpSession, UriElement aServiceId, String aUser, String aPassword, Language aLanguage, ApplCompLevel aLevel) throws HmiCoreException {
        if (this.isSingleTarget()) {
            String lMsg = "Factory is not \"multi-target\". Sorry, cannot derive URL => cannot create HMI client!";
            sLogger.log(Level.ERROR, lMsg);
            throw HmiCoreException.newProgrammingModelViolation(this.getClass().getName(), "createClient", lMsg);
        }
        String lHttpRequestMethod = this.getHmiConfiguration().getHttpRequestMethod(aServerApplicationId, aServerLogicalSystemName);
        URL lServletUrl = this.deriveServletInternalClientUrl(aTargetContainerId, aServerLogicalSystemName, aServerApplicationId, aServiceId.toString());
        HmiHttpClientImpl lClient = new HmiHttpClientImpl(this.getHttpURLConnectionFactory(), lHttpRequestMethod, lServletUrl, aRequiresHttpSession, aServiceId, aUser, aPassword, aLanguage, aLevel);
        lClient.setServerLogicalSystemName(aServerLogicalSystemName);
        lClient.setServerApplicationId(aServerApplicationId);
        ((HmiClientAdapter)lClient).allocateResources();
        return lClient;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class SingleTargetConfiguration {
        String iServerLogicalSystemName;
        String iServerApplicationId;
        String iServerApplicationContextRoot;

        public SingleTargetConfiguration(String aServerLogicalSystemName, String aServerApplicationId, String aServerApplicationContextRoot) {
            this.iServerLogicalSystemName = aServerLogicalSystemName;
            this.iServerApplicationId = aServerApplicationId;
            this.iServerApplicationContextRoot = aServerApplicationContextRoot;
        }
    }

    public static interface TargetContainerIds {
        public static final String Any = "any";
        public static final String Ejb = "ejb";
        public static final String Web = "web";
    }
}

