/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.hmi.api;

import com.sap.aii.util.applcomp.ApplCompLevel;
import com.sap.aii.util.hmi.api.HmiClient;
import com.sap.aii.util.hmi.api.HmiCoreException;
import com.sap.aii.util.hmi.api.HmiMethodFault;
import com.sap.aii.util.hmi.api.HmiMethodInput;
import com.sap.aii.util.hmi.api.HmiMethodOutput;
import com.sap.aii.util.hmi.api.UriElement;
import com.sap.aii.util.hmi.core.msg.HmiRequest;
import com.sap.aii.util.hmi.core.msg.HmiResponse;
import com.sap.aii.util.misc.api.GUIDFactory;
import com.sap.aii.util.misc.api.Language;
import com.sap.guid.IGUID;

public abstract class HmiClientAdapter
implements HmiClient {
    private IGUID iClientId = GUIDFactory.getInstance().createGUID();
    protected boolean iRequiresSession;
    private UriElement iServiceId;
    private String iUser;
    private String iPassword;
    private Language iLanguage;
    private ApplCompLevel iLevel;
    private String iServerLogicalSystemName;
    private String iServerApplicationId;
    protected boolean iAreResourcesAllocated;

    protected HmiClientAdapter(boolean aRequiresSession, UriElement aServiceId, String aUser, String aPassword, Language aLanguage, ApplCompLevel aLevel) {
        this.iLevel = aLevel;
        this.iRequiresSession = aRequiresSession;
        this.iServiceId = aServiceId;
        this.iUser = aUser;
        this.iPassword = aPassword;
        this.iLanguage = aLanguage;
        this.iServerLogicalSystemName = null;
        this.iServerApplicationId = null;
        this.iAreResourcesAllocated = false;
    }

    public void setServerLogicalSystemName(String aServerLogicalSystemName) {
        this.iServerLogicalSystemName = aServerLogicalSystemName;
    }

    public void setServerApplicationId(String aServerApplicationId) {
        this.iServerApplicationId = aServerApplicationId;
    }

    public final HmiMethodOutput invokeMethod(UriElement aMethodId, HmiMethodInput aMethodInput) throws HmiMethodFault, HmiCoreException {
        HmiRequest lRequest = HmiRequest.createRequest(this.getRequiresSession(), this.getServiceId(), aMethodId, aMethodInput, this.getServerLogicalSystemName(), this.getServerApplicationId(), this.getClientId(), this.getLevel(), this.getUser(), this.getPassword(), this.getLanguage(), 0);
        HmiResponse lResponse = this.sendRequestAndReceiveResponse(lRequest);
        if (lResponse.getCoreException() != null) {
            throw lResponse.getCoreException();
        }
        if (lResponse.getMethodFault() != null) {
            throw lResponse.getMethodFault();
        }
        if (lResponse.getMethodOutput() != null) {
            return lResponse.getMethodOutput();
        }
        throw new RuntimeException("Unexpected control flow - neither method output nor method fault nor core exception in response!");
    }

    protected final void informServerOfClientDestruction() throws HmiCoreException {
        UriElement lMethodId = UriElement.getInstanceFromUriString("");
        HmiMethodInput lMethodInput = null;
        HmiRequest lRequest = HmiRequest.createRequest(this.getRequiresSession(), this.getServiceId(), lMethodId, lMethodInput, this.getServerLogicalSystemName(), this.getServerApplicationId(), this.getClientId(), this.getLevel(), this.getUser(), this.getPassword(), this.getLanguage(), 1);
        HmiResponse lResponse = this.sendRequestAndReceiveResponse(lRequest);
        if (lResponse.getCoreException() != null) {
            throw lResponse.getCoreException();
        }
        if (lResponse.getControlFlag() == 1) {
            return;
        }
        if (lResponse.getMethodFault() != null) {
            throw new RuntimeException("Unexpected control flow - method fault in response!");
        }
        if (lResponse.getMethodOutput() != null) {
            throw new RuntimeException("Unexpected control flow - method output in response!");
        }
        throw new RuntimeException("Unexpected control flow - neither method output nor method fault nor core exception in response!");
    }

    public abstract void allocateResources() throws HmiCoreException;

    public abstract void freeResources() throws HmiCoreException;

    public abstract HmiResponse sendRequestAndReceiveResponse(HmiRequest var1) throws HmiCoreException;

    protected IGUID getClientId() {
        return this.iClientId;
    }

    protected boolean getRequiresSession() {
        return this.iRequiresSession;
    }

    protected UriElement getServiceId() {
        return this.iServiceId;
    }

    protected String getUser() {
        return this.iUser;
    }

    protected String getPassword() {
        return this.iPassword;
    }

    protected Language getLanguage() {
        return this.iLanguage;
    }

    protected ApplCompLevel getLevel() {
        return this.iLevel;
    }

    protected String getServerLogicalSystemName() {
        return this.iServerLogicalSystemName;
    }

    protected String getServerApplicationId() {
        return this.iServerApplicationId;
    }
}

