/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.blob.api;

import com.sap.aii.util.blob.api.AIIBlob;
import com.sap.aii.util.blob.api.AIIBlobImpl;
import com.sap.aii.util.blob.api.AIIBlobMemory;
import com.sap.aii.util.blob.api.ByteArrayBlob;
import com.sap.aii.util.misc.api.Digest;
import com.sap.aii.util.misc.api.ResourceException;
import java.io.InputStream;
import java.io.OutputStream;

public class BlobServices {
    public static OutputStream debug = null;
    public static final AIIBlobMemory EMPTY_BLOB = new ByteArrayBlob(new byte[0], "any");

    private BlobServices() {
    }

    public static AIIBlob getBlob(InputStream is, int length, String mimeType) {
        return new AIIBlobImpl(is, length, mimeType);
    }

    public static AIIBlobMemory getBlobFromArray(byte[] a, String mimeType) {
        return new ByteArrayBlob(a, mimeType);
    }

    public static AIIBlobMemory getBlobIntoMemory(AIIBlob b) throws ResourceException {
        if (b instanceof AIIBlobMemory) {
            return (AIIBlobMemory)b;
        }
        return new ByteArrayBlob(BlobServices.getByteArray(b), b.getMimeType());
    }

    public static byte[] getByteArray(AIIBlob b) throws ResourceException {
        return b.getByteArray();
    }

    public static Digest getDigest(AIIBlob b) throws ResourceException {
        return new Digest(b.getByteArray());
    }
}

