/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.blob.api;

import com.sap.aii.util.blob.api.AIIBlob;
import com.sap.aii.util.blob.api.BlobResourceException;
import com.sap.aii.util.blob.api.InputStreamLoc;
import com.sap.aii.util.misc.api.IOUtil;
import com.sap.aii.util.misc.api.ResourceException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

class AIIBlobImpl
extends AIIBlob {
    private InputStreamLoc is;
    private int length;
    private String mimeType;
    private boolean mayReturn = true;
    private byte[] b = null;

    public AIIBlobImpl(InputStream is, int length, String mimeType) {
        this.is = is instanceof InputStreamLoc ? (InputStreamLoc)is : new InputStreamLoc(is);
        this.length = length;
        this.mimeType = mimeType;
    }

    public InputStream getBinaryStream() throws ResourceException {
        InputStreamLoc inputStreamLoc = this.is;
        synchronized (inputStreamLoc) {
            if (this.mayReturn) {
                if (this.b == null) {
                    this.mayReturn = false;
                    InputStreamLoc inputStreamLoc2 = this.is;
                    return inputStreamLoc2;
                }
                InputStreamLoc inputStreamLoc3 = new InputStreamLoc(new ByteArrayInputStream(this.b));
                return inputStreamLoc3;
            }
            throw new BlobResourceException("CONCURRENT");
        }
    }

    public int length() throws ResourceException {
        InputStreamLoc inputStreamLoc = this.is;
        synchronized (inputStreamLoc) {
            if (this.length < 0) {
                this.mayReturn = this.is.read_yet == 0;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    IOUtil.copyStream(this.is, baos);
                }
                catch (IOException e) {
                    throw new ResourceException(e);
                }
                this.length = this.is.read_yet;
                this.b = baos.toByteArray();
                this.is.setStream(this.b);
            }
        }
        return this.length;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void close() {
        try {
            this.is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    byte[] getByteArray() throws ResourceException {
        this.length();
        if (this.b == null || !this.mayReturn) {
            return super.getByteArray();
        }
        return this.b;
    }
}

