/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.interaction.util;

import com.togethersoft.togetherxj.uml.interaction.util.ReferenceCache;
import com.togethersoft.togetherxj.uml.interaction.util.ReferenceCacheAccess;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.ModelAware;
import com.tssap.selena.model.view.View;
import com.tssap.selena.model.view.ViewAccess;
import com.tssap.selena.model.view.ViewFactory;
import java.util.HashMap;
import java.util.Map;

public class ReferenceCacheFactory
implements ViewFactory,
ModelAware {
    protected static final String REFERENCE_CACHE_VIEW_TYPE = "$sreferenceCache";
    private HashMap myCaches;
    private UniqueName myModelUin;

    public void registered(Model model) {
        this.myModelUin = model.getUniqueName();
        ReferenceCacheAccess.registerFactory(model, this);
    }

    public void unregistered(Model model) {
        ReferenceCacheAccess.unregisterFactory(model);
        this.myModelUin = null;
    }

    public boolean canCreateView(ReferenceCollection referenceCollection, String string) {
        return REFERENCE_CACHE_VIEW_TYPE.equals(string) && !this.getCachesMap().containsKey(referenceCollection.getUniqueName());
    }

    public ReferenceCache getCache(ReferenceCollection referenceCollection) {
        ReferenceCache referenceCache = (ReferenceCache)this.getCachesMap().get(referenceCollection.getUniqueName());
        if (referenceCache == null) {
            referenceCache = (ReferenceCache)ViewAccess.getViewManager((UniqueName)this.myModelUin).createView(referenceCollection, REFERENCE_CACHE_VIEW_TYPE);
            this.getCachesMap().put(referenceCollection.getUniqueName(), referenceCache);
        }
        return referenceCache;
    }

    public View createView(ReferenceCollection referenceCollection, String string) {
        return new ReferenceCache(referenceCollection, this);
    }

    public void clearAllCaches() {
        if (this.myCaches != null) {
            ReferenceCache[] referenceCacheArray = this.myCaches.values().toArray(new ReferenceCache[this.myCaches.size()]);
            int n2 = 0;
            while (n2 < referenceCacheArray.length) {
                referenceCacheArray[n2].reload();
                ++n2;
            }
        }
    }

    void removeCache(ReferenceCache referenceCache) {
        if (this.myCaches != null) {
            this.myCaches.remove(referenceCache.getReferenceCollection().getUniqueName());
        }
    }

    private Map getCachesMap() {
        if (this.myCaches == null) {
            this.myCaches = new HashMap();
        }
        return this.myCaches;
    }
}

