/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.interaction.util;

import com.togethersoft.togetherxj.uml.interaction.util.ReferenceCacheFactory;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.ReferenceContainer;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.ReferenceEnumeration;
import com.tssap.selena.model.view.View;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ReferenceCache
implements View {
    private ReferenceCacheFactory myFactory;
    private int myLastSize;
    private HashMap myEntityUin2Reference;
    private Set myCurrentLeafs;
    private ReferenceCollection myCollection;

    public ReferenceCache(ReferenceCollection referenceCollection, ReferenceCacheFactory referenceCacheFactory) {
        this.myCollection = referenceCollection;
        this.myFactory = referenceCacheFactory;
    }

    public ReferenceCollection getReferenceCollection() {
        return this.myCollection;
    }

    public void dispose() {
        ReferenceCache referenceCache = this;
        synchronized (referenceCache) {
            if (this.myEntityUin2Reference != null) {
                this.myEntityUin2Reference.clear();
                this.myLastSize = 0;
            }
            this.myEntityUin2Reference = null;
            this.myFactory.removeCache(this);
            this.myCollection = null;
        }
    }

    public void update(ModelDeltaNode modelDeltaNode) {
        this.reload();
    }

    void reload() {
        ReferenceCache referenceCache = this;
        synchronized (referenceCache) {
            if (this.myEntityUin2Reference != null) {
                this.myLastSize = this.myEntityUin2Reference.size();
                this.myEntityUin2Reference.clear();
                this.myEntityUin2Reference = null;
            }
        }
    }

    public Reference findCachedReference(UniqueName uniqueName) {
        if (uniqueName == null) {
            return null;
        }
        ReferenceCache referenceCache = this;
        synchronized (referenceCache) {
            this.initMap();
            Reference reference = (Reference)this.myEntityUin2Reference.get(uniqueName);
            return reference;
        }
    }

    public Object getService(Class clazz) {
        return null;
    }

    private void initMap() {
        if (this.myEntityUin2Reference == null) {
            this.myEntityUin2Reference = new HashMap(this.getOptimalMapSize());
            ReferenceCache.cacheSubReferences((ReferenceContainer)this.myCollection, this.myEntityUin2Reference);
        }
    }

    private static void cacheSubReferences(ReferenceContainer referenceContainer, Map map) {
        ReferenceEnumeration referenceEnumeration = referenceContainer.references();
        while (referenceEnumeration.hasMoreElements()) {
            Reference reference = referenceEnumeration.next();
            map.put(reference.getEntity().getUniqueName(), reference);
            ReferenceCache.cacheSubReferences((ReferenceContainer)reference, map);
        }
    }

    private int getOptimalMapSize() {
        return this.myLastSize == 0 ? 11 : this.myLastSize * 2 + 1;
    }
}

