/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.interaction.util;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.enum.ElementEnumeration;
import com.tssap.selena.model.enum.EntityEnumeration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class InteractionOccurrenceHelper {
    private static final String DEPENDENCY = "Dependency Link";
    private static final String USES_TYPE = "uses";
    private static final String SOURCE_ROLE = "Client";
    private static final String TARGET_ROLE = "Supplier";

    public static boolean isUseObjectLink(Entity entity) {
        String string = entity.getPropertyValue("$metaclass");
        return DEPENDENCY.equals(string) && entity.hasPropertyValue("@stereotype", USES_TYPE);
    }

    public static List getUseObjectLinks(Entity entity) {
        ArrayList<Entity> arrayList = new ArrayList<Entity>();
        EntityEnumeration entityEnumeration = entity.childEntities();
        while (entityEnumeration.hasMoreElements()) {
            Entity entity2 = entityEnumeration.next();
            if (!InteractionOccurrenceHelper.isUseObjectLink(entity2)) continue;
            arrayList.add(entity2);
        }
        return arrayList;
    }

    public static List getUsedObjects(Entity entity) {
        ArrayList<Entity> arrayList = new ArrayList<Entity>();
        Iterator iterator = InteractionOccurrenceHelper.getUseObjectLinks(entity).iterator();
        while (iterator.hasNext()) {
            Entity entity2 = InteractionOccurrenceHelper.getLinkTarget((Entity)iterator.next());
            if (entity2 == null || !"Object".equals(entity2.getPropertyValue("$metaclass"))) continue;
            arrayList.add(entity2);
        }
        return arrayList;
    }

    public static List getUsedObjectUids(Entity entity) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = InteractionOccurrenceHelper.getUsedObjects(entity).iterator();
        while (iterator.hasNext()) {
            String string = ((Entity)iterator.next()).getUniqueName().toString();
            arrayList.add(string);
        }
        return arrayList;
    }

    public static void removeObjectFromUsed(Entity entity, Entity entity2) {
        Entity entity3 = InteractionOccurrenceHelper.findUsesLink(entity, entity2);
        while (entity3 != null) {
            entity3.delete();
            entity3 = InteractionOccurrenceHelper.findUsesLink(entity, entity2);
        }
    }

    public static Entity addUsedObject(Entity entity, Entity entity2) {
        InteractionOccurrenceHelper.removeObjectFromUsed(entity, entity2);
        Model model = entity.getModel();
        Entity entity3 = model.createEntityTemplate();
        entity3.setParticipant(SOURCE_ROLE, null, (Element)entity);
        entity3.setParticipant(TARGET_ROLE, null, (Element)entity2);
        entity3.setPropertyValue("@stereotype", USES_TYPE);
        Entity entity4 = entity.createChildEntity(DEPENDENCY, entity3);
        return entity4;
    }

    public static Entity findUsesLink(Entity entity, Entity entity2) {
        Iterator iterator = InteractionOccurrenceHelper.getUseObjectLinks(entity).iterator();
        while (iterator.hasNext()) {
            Entity entity3 = (Entity)iterator.next();
            if (!InteractionOccurrenceHelper.getLinkTarget(entity3).equals(entity2)) continue;
            return entity3;
        }
        return null;
    }

    public static Entity getLinkTarget(Entity entity) {
        ElementEnumeration elementEnumeration = entity.participants(TARGET_ROLE);
        if (elementEnumeration.hasMoreElements()) {
            Entity entity2 = (Entity)elementEnumeration.next();
            return entity2;
        }
        return null;
    }
}

