/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.interaction.util;

import com.togethersoft.togetherxj.uml.interaction.util.Assert;
import com.togethersoft.togetherxj.uml.interaction.util.EntityCache$EntityProxy;
import com.togethersoft.togetherxj.uml.interaction.util.EntityCache$ModelWatcher;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ModelAccessListener;
import com.tssap.selena.model.elements.ModelChangeEvent;
import com.tssap.selena.model.elements.ModelChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class EntityCache
implements ModelChangeListener {
    private static HashMap ourModelUIN2CacheMap = new HashMap();
    private static boolean ourDisabled;
    private HashMap myMap;
    private Model myModel;

    private EntityCache(Model model) {
        ModelAccess.addModelAccessListener((ModelAccessListener)new EntityCache$ModelWatcher(null));
        this.myMap = new HashMap();
        this.myModel = model;
        this.myModel.addModelDeltaListener((ModelChangeListener)this);
    }

    protected Model getModel() {
        return this.myModel;
    }

    public void modelChanged(ModelChangeEvent modelChangeEvent) {
        this.clear();
    }

    public static EntityCache getCache(Model model) {
        String string = model.getUniqueName().toString();
        EntityCache entityCache = (EntityCache)ourModelUIN2CacheMap.get(string);
        if (entityCache == null) {
            entityCache = new EntityCache(model);
            ourModelUIN2CacheMap.put(string, entityCache);
        }
        return entityCache;
    }

    public static void clearAll() {
        Iterator iterator = ourModelUIN2CacheMap.values().iterator();
        while (iterator.hasNext()) {
            EntityCache entityCache = (EntityCache)iterator.next();
            entityCache.clear();
        }
    }

    public static void disable() {
        ourDisabled = true;
    }

    public static void enable() {
        ourDisabled = false;
    }

    public static boolean isEnabled() {
        return !ourDisabled;
    }

    private void dispose() {
        if (this.myModel == null) {
            return;
        }
        this.clear();
        this.myModel.removeModelDeltaListener((ModelChangeListener)this);
        this.myModel = null;
    }

    public void clear() {
        Iterator iterator = this.myMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            EntityCache$EntityProxy entityCache$EntityProxy = (EntityCache$EntityProxy)entry.getValue();
            entityCache$EntityProxy.dispose();
        }
        this.myMap.clear();
    }

    public EntityCache$EntityProxy resolve(Entity entity) {
        Assert.assertTrue("Attempt to use disabled entity registry", !ourDisabled);
        Object v2 = this.myMap.get(entity.getUniqueName().toString());
        return (EntityCache$EntityProxy)v2;
    }

    public Entity get(String string) {
        if (ourDisabled) {
            return null;
        }
        Object v2 = this.myMap.get(string);
        return (Entity)v2;
    }

    public EntityCache$EntityProxy put(Entity entity) {
        Assert.assertTrue("Attempt to use disabled entity registry", !ourDisabled);
        if (entity instanceof EntityCache$EntityProxy) {
            return (EntityCache$EntityProxy)entity;
        }
        String string = entity.getUniqueName().toString();
        EntityCache$EntityProxy entityCache$EntityProxy = (EntityCache$EntityProxy)this.myMap.get(string);
        if (entityCache$EntityProxy != null) {
            return entityCache$EntityProxy;
        }
        entityCache$EntityProxy = new EntityCache$EntityProxy(entity, this);
        this.myMap.put(string, entityCache$EntityProxy);
        entityCache$EntityProxy.cacheAll();
        return entityCache$EntityProxy;
    }

    public boolean contains(Entity entity) {
        if (ourDisabled) {
            return false;
        }
        return this.myMap.containsKey(entity.getUniqueName().toString());
    }

    static HashMap access$200() {
        return ourModelUIN2CacheMap;
    }

    static void access$300(EntityCache entityCache) {
        entityCache.dispose();
    }
}

