/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.interaction.util;

import com.togethersoft.togetherxj.uml.interaction.util.Assert;
import com.togethersoft.togetherxj.uml.interaction.util.ElementUtil;
import com.togethersoft.togetherxj.uml.interaction.util.EntityCache;
import com.togethersoft.togetherxj.uml.interaction.util.EntityCache$EmptyElementEnumeration;
import com.togethersoft.togetherxj.uml.interaction.util.EntityCache$ListEntityEnumeration;
import com.togethersoft.togetherxj.uml.interaction.util.EntityCache$SingleElementEnumeration;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.ElementEnumeration;
import com.tssap.selena.model.enum.EntityEnumeration;
import com.tssap.selena.model.enum.ParticipantEnumeration;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.enum.ReferenceCollectionEnumeration;
import com.tssap.selena.model.enum.StringEnumeration;
import com.tssap.selena.model.util.EmptyEnumeration;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;

public class EntityCache$EntityProxy
implements Entity {
    private boolean myDeleted = false;
    private Entity myEntity;
    private Entity myParentEntity;
    private HashMap myPropertiesCache = new HashMap();
    private HashMap myParticipantsCache = new HashMap();
    private ArrayList myChildEntities;
    private UniqueName myUniqueName;
    private EntityCache myCache;

    protected EntityCache$EntityProxy(Entity entity, EntityCache entityCache) {
        this.myEntity = entity;
        this.myUniqueName = entity.getUniqueName();
        this.myCache = entityCache;
    }

    public Entity getOriginal() {
        return this.myEntity;
    }

    protected void setDeleted() {
        this.myDeleted = true;
    }

    protected void cacheAll() {
        this.cacheProperties();
        this.cacheParticipants();
        this.cacheChildren();
    }

    protected void dispose() {
        this.myEntity = null;
        this.myUniqueName = null;
        this.myCache = null;
        if (this.myPropertiesCache != null) {
            this.myPropertiesCache.clear();
            this.myPropertiesCache = null;
        }
        if (this.myParticipantsCache != null) {
            this.myParticipantsCache.clear();
            this.myParticipantsCache = null;
        }
        if (this.myChildEntities != null) {
            this.myChildEntities.clear();
            this.myChildEntities = null;
        }
    }

    protected void cacheProperties() {
        PropertyEnumeration propertyEnumeration = this.myEntity.properties();
        while (propertyEnumeration.hasMoreElements()) {
            Property property = propertyEnumeration.next();
            this.myPropertiesCache.put(property.getName(), property.getValue());
        }
    }

    protected void cacheParticipants() {
        StringEnumeration stringEnumeration = this.myEntity.participantRoles();
        if (stringEnumeration.hasMoreElements()) {
            this.cacheParticipant("Client", ElementUtil.getLinkSource(this.myEntity));
            this.cacheParticipant("Supplier", ElementUtil.getLinkTarget(this.myEntity));
        }
        this.myParentEntity = this.myEntity.getParent();
    }

    protected void cacheParticipant(String string, Entity entity) {
        if (entity != null) {
            this.myParticipantsCache.put(string, entity);
        } else {
            this.myParticipantsCache.remove(string);
        }
    }

    protected void cacheProperty(String string, String string2) {
        if (string2 != null && string2.length() > 0) {
            this.myPropertiesCache.put(string, string2);
        } else {
            this.myPropertiesCache.remove(string);
        }
    }

    protected void cacheChildren() {
        EntityEnumeration entityEnumeration = this.myEntity.childEntities();
        if (!entityEnumeration.hasMoreElements()) {
            return;
        }
        this.myChildEntities = new ArrayList();
        while (entityEnumeration.hasMoreElements()) {
            Entity entity = entityEnumeration.next();
            EntityCache$EntityProxy entityCache$EntityProxy = this.myCache.put(entity);
            this.myChildEntities.add(entityCache$EntityProxy);
        }
    }

    public Model getModel() {
        if (this.myCache != null) {
            return this.myCache.getModel();
        }
        return null;
    }

    public UniqueName getUniqueName() {
        return this.myUniqueName;
    }

    public boolean isDeleted() {
        return this.myDeleted;
    }

    public boolean canDelete() {
        return !this.isDeleted();
    }

    public void delete() {
        if (!this.isDeleted()) {
            this.setDeleted();
            this.myEntity.delete();
        }
    }

    public String getPropertyValue(String string) {
        return (String)this.myPropertiesCache.get(string);
    }

    public boolean hasProperty(String string) {
        return this.myPropertiesCache.containsKey(string);
    }

    public boolean hasPropertyValue(String string, String string2) {
        return string2.equals(this.myPropertiesCache.get(string));
    }

    public boolean canSetPropertyValue(String string, String string2) {
        if (this.myEntity != null) {
            return this.myEntity.canSetPropertyValue(string, string2);
        }
        return false;
    }

    public Property setPropertyValue(String string, String string2) {
        this.cacheProperty(string, string2);
        if (this.myEntity != null) {
            return this.myEntity.setPropertyValue(string, string2);
        }
        return null;
    }

    public StringEnumeration participantRoles() {
        Assert.notImplementedFail();
        return null;
    }

    public ElementEnumeration participants(String string) {
        Object v2 = this.myParticipantsCache.get(string);
        if (v2 instanceof Entity) {
            return new EntityCache$SingleElementEnumeration((Element)((Entity)v2), this.myCache);
        }
        return new EntityCache$EmptyElementEnumeration(null);
    }

    public EntityEnumeration childEntities() {
        return new EntityCache$ListEntityEnumeration(this.myChildEntities, this.myCache);
    }

    public EntityEnumeration children() {
        return new EntityCache$ListEntityEnumeration(this.myChildEntities, this.myCache);
    }

    public Entity getParent() {
        EntityCache$EntityProxy entityCache$EntityProxy;
        if (this.myParentEntity != null && (entityCache$EntityProxy = this.myCache.resolve(this.myParentEntity)) != null) {
            return entityCache$EntityProxy;
        }
        return this.myParentEntity;
    }

    public Property addProperty(String string, String string2) {
        Assert.notImplementedFail();
        return null;
    }

    public boolean canAddProperty(String string, String string2) {
        Assert.notImplementedFail();
        return false;
    }

    public boolean canCopy() {
        Assert.notImplementedFail();
        return false;
    }

    public boolean canCreateChildEntity(String string, Entity entity) {
        Assert.notImplementedFail();
        return false;
    }

    public Entity createChildEntity(String string, Entity entity) {
        Assert.notImplementedFail();
        return null;
    }

    public boolean canCreateChildReferenceCollection(String string, ReferenceCollection referenceCollection) {
        Assert.notImplementedFail();
        return false;
    }

    public boolean canCut() {
        Assert.notImplementedFail();
        return false;
    }

    public boolean canPaste(Element element) {
        Assert.notImplementedFail();
        return false;
    }

    public boolean canPaste(Element element, Element element2, boolean bl2) {
        Assert.notImplementedFail();
        return false;
    }

    public boolean canSetParticipant(Element element, String string, String string2) {
        Assert.notImplementedFail();
        return false;
    }

    public boolean canSetParticipant(String string, Element element, Element element2) {
        Assert.notImplementedFail();
        return false;
    }

    public ReferenceCollectionEnumeration childReferenceCollections() {
        Assert.notImplementedFail();
        return null;
    }

    public Entity copy() {
        Assert.notImplementedFail();
        return null;
    }

    public ReferenceCollection createChildReferenceCollection(String string, ReferenceCollection referenceCollection) {
        Assert.notImplementedFail();
        return null;
    }

    public Entity cut() {
        Assert.notImplementedFail();
        return null;
    }

    public Property getProperty(String string) {
        Assert.notImplementedFail();
        return null;
    }

    public Element paste(Element element) {
        Assert.notImplementedFail();
        return null;
    }

    public Element paste(Element element, Element element2, boolean bl2) {
        Assert.notImplementedFail();
        return null;
    }

    public PropertyEnumeration properties() {
        Assert.notImplementedFail();
        return null;
    }

    public PropertyEnumeration properties(String string) {
        Assert.notImplementedFail();
        return null;
    }

    public void setParticipant(Element element, String string, String string2) {
        Assert.notImplementedFail();
    }

    public void setParticipant(String string, Element element, Element element2) {
        Assert.notImplementedFail();
    }

    public boolean canSetObjectPropertyValue(String string, Object object) {
        Assert.notImplementedFail();
        return false;
    }

    public Object getObjectPropertyValue(String string) {
        Assert.notImplementedFail();
        return null;
    }

    public void setObjectPropertyValue(String string, Object object) {
        Assert.notImplementedFail();
    }

    public Enumeration objectPropertyValues(String string) {
        return EmptyEnumeration.getEnumeration();
    }

    public ParticipantEnumeration allParticipants() {
        return EmptyEnumeration.getParticipantEnumeration();
    }
}

