/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.interaction.util;

import com.togethersoft.togetherxj.uml.interaction.SequenceMetaclass;
import com.togethersoft.togetherxj.uml.interaction.providers.copypaste.CopyExtendersState;
import com.togethersoft.togetherxj.uml.interaction.util.Assert;
import com.togethersoft.togetherxj.uml.interaction.util.EntityCache;
import com.togethersoft.togetherxj.uml.interaction.util.ReferenceCacheAccess;
import com.togethersoft.togetherxj.uml.interaction.util.ReferenceCacheFactory;
import com.tssap.selena.model.elements.Container;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Link;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.ReferenceContainer;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.ElementEnumeration;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.enum.ReferenceEnumeration;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;

public class ElementUtil {
    public static final String SOURCE_ROLE = "Client";
    public static final String TARGET_ROLE = "Supplier";
    public static Collection ourReferenceAttributes;
    public static Collection ourEntityAttributes;
    static /* synthetic */ Class class$com$togethersoft$togetherxj$uml$interaction$ReferenceAttributes;
    static /* synthetic */ Class class$com$togethersoft$togetherxj$uml$interaction$EntityAttributes;
    static /* synthetic */ Class class$com$togethersoft$togetherxj$uml$cdl$core$EntityAttributes;

    public static boolean isOurReferenceAttribute(String string) {
        if (ourReferenceAttributes == null) {
            ourReferenceAttributes = new HashSet();
            Field[] fieldArray = (class$com$togethersoft$togetherxj$uml$interaction$ReferenceAttributes == null ? (class$com$togethersoft$togetherxj$uml$interaction$ReferenceAttributes = ElementUtil.class$("com.togethersoft.togetherxj.uml.interaction.ReferenceAttributes")) : class$com$togethersoft$togetherxj$uml$interaction$ReferenceAttributes).getDeclaredFields();
            int n2 = 0;
            while (n2 < fieldArray.length) {
                try {
                    ourReferenceAttributes.add(fieldArray[n2].get(null));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    illegalArgumentException.printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                ++n2;
            }
        }
        return ourReferenceAttributes.contains(string);
    }

    public static boolean isOurEntityAttribute(String string) {
        if (ourEntityAttributes == null) {
            ourEntityAttributes = new HashSet();
            Field[] fieldArray = (class$com$togethersoft$togetherxj$uml$interaction$EntityAttributes == null ? (class$com$togethersoft$togetherxj$uml$interaction$EntityAttributes = ElementUtil.class$("com.togethersoft.togetherxj.uml.interaction.EntityAttributes")) : class$com$togethersoft$togetherxj$uml$interaction$EntityAttributes).getDeclaredFields();
            int n2 = 0;
            while (n2 < fieldArray.length) {
                try {
                    ourEntityAttributes.add(fieldArray[n2].get(null));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    illegalArgumentException.printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                ++n2;
            }
            fieldArray = (class$com$togethersoft$togetherxj$uml$cdl$core$EntityAttributes == null ? (class$com$togethersoft$togetherxj$uml$cdl$core$EntityAttributes = ElementUtil.class$("com.togethersoft.togetherxj.uml.cdl.core.EntityAttributes")) : class$com$togethersoft$togetherxj$uml$cdl$core$EntityAttributes).getDeclaredFields();
            int n3 = 0;
            while (n3 < fieldArray.length) {
                try {
                    ourEntityAttributes.add(fieldArray[n3].get(null));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    illegalArgumentException.printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                ++n3;
            }
        }
        return ourEntityAttributes.contains(string);
    }

    public static Element findElement(Model model, String string) {
        Enumeration enumeration;
        UniqueName uniqueName = ModelAccess.createUniqueName((String)string);
        Assert.assertNotNull("Can't create proper unique name from string: " + string, uniqueName);
        if (model != null && (enumeration = model.findElement(uniqueName)) != null) {
            return enumeration;
        }
        enumeration = ModelAccess.models();
        while (enumeration.hasMoreElements()) {
            Element element = ((Model)enumeration.nextElement()).findElement(uniqueName);
            if (element == null) continue;
            return element;
        }
        return null;
    }

    private static Element lookupParentMetaclass(Element element, String string) {
        if (element == null) {
            return null;
        }
        String string2 = element.getPropertyValue("$metaclass");
        if (string.equals(string2)) {
            return element;
        }
        return ElementUtil.lookupParentMetaclass(ElementUtil.getParent(element), string);
    }

    private static Element getParent(Element element) {
        if (element instanceof Reference) {
            return (Element)((Reference)element).getReferenceContainer();
        }
        return element.getParent();
    }

    public static void dumpHierarchyUp(Element element) {
        ElementUtil.dumpHierarchyUp(element, 0);
    }

    private static void dumpHierarchyUp(Element element, int n2) {
        char[] cArray = new char[n2];
        Arrays.fill(cArray, ' ');
        System.out.println("[" + n2 + "] " + new String(cArray) + element + " " + element.getClass().getName() + " metaclass=" + element.getPropertyValue("$metaclass") + " name=" + element.getPropertyValue("$name"));
        Element element2 = ElementUtil.getParent(element);
        if (element2 != null) {
            ElementUtil.dumpHierarchyUp(element2, ++n2);
        }
    }

    public static ReferenceCollection getParentCollection(Reference reference) {
        Entity entity = reference.getParent();
        if (entity != null) {
            Assert.assertTrue("Reference parent should implement interface ReferenceCollection\nreference: " + reference + "\nparent: " + entity, entity instanceof ReferenceCollection);
            return (ReferenceCollection)entity;
        }
        return null;
    }

    public static Element getSequenceObject(Element element) {
        return ElementUtil.lookupParentMetaclass(element, "Object");
    }

    public static boolean isObjectNode(PropertyMap propertyMap) {
        String string = propertyMap.getPropertyValue("$metaclass");
        return "Object".equals(string);
    }

    public static boolean isConventionalMessage(PropertyMap propertyMap) {
        Element element;
        if ("Message Link".equals(propertyMap.getPropertyValue("$metaclass")) && (element = ElementUtil.getLinkTarget((Element)propertyMap)) != null) {
            return ElementUtil.isObjectNode((PropertyMap)element);
        }
        return false;
    }

    public static boolean isMessageLink(PropertyMap propertyMap) {
        String string = propertyMap.getPropertyValue("$metaclass");
        return "Message Link".equals(string);
    }

    public static boolean isInteractionConnector(PropertyMap propertyMap) {
        Element element;
        if ("Message Link".equals(propertyMap.getPropertyValue("$metaclass")) && (element = ElementUtil.getLinkTarget((Element)propertyMap)) != null) {
            return ElementUtil.isInteractionOccurrence((PropertyMap)element);
        }
        return false;
    }

    public static boolean isInteractionOccurrence(PropertyMap propertyMap) {
        return propertyMap != null && "InteractionOccurrence".equals(propertyMap.getPropertyValue("$metaclass"));
    }

    public static boolean isActivationNode(PropertyMap propertyMap) {
        String string = propertyMap.getPropertyValue("$metaclass");
        return "Activation".equals(string);
    }

    public static boolean isStatementBlock(PropertyMap propertyMap) {
        String string = propertyMap.getPropertyValue("$metaclass");
        return ElementUtil.isStatementBlockMetaclass(string);
    }

    public static boolean isStatementBlockMetaclass(String string) {
        int n2 = 0;
        while (n2 < SequenceMetaclass.ALL_STATEMENT_BLOCKS.length) {
            if (SequenceMetaclass.ALL_STATEMENT_BLOCKS[n2].equals(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isReturnLink(PropertyMap propertyMap) {
        String string = propertyMap.getPropertyValue("$metaclass");
        return "Return Link".equals(string);
    }

    public static boolean isSequenceElement(Element element) {
        return ElementUtil.isActivationNode((PropertyMap)element) || ElementUtil.isMessageLink((PropertyMap)element) || ElementUtil.isStatementBlock((PropertyMap)element);
    }

    public static boolean isInterlifelineConnector(PropertyMap propertyMap) {
        String string = propertyMap.getPropertyValue("$metaclass");
        return "Messages Link".equals(string);
    }

    public static boolean isVirtualMessageParticipant(PropertyMap propertyMap) {
        String string = propertyMap.getPropertyValue("$metaclass");
        return ElementUtil.isVirtualMessageParticipantMetaclass(string);
    }

    public static boolean isVirtualMessageParticipantMetaclass(String string) {
        return "Object".equals(string) || "Activation".equals(string) || ElementUtil.isStatementBlockMetaclass(string);
    }

    public static Entity createLink(Entity entity, Entity entity2, String string) {
        Assert.assertNotNull("source is NULL!", entity);
        Assert.assertNotNull("target is NULL!", entity2);
        Assert.assertCanCreateChildEntity((Container)entity, string);
        Entity entity3 = entity.createChildEntity(string, null);
        ReferenceCacheAccess.clearAllCaches((Element)entity);
        Assert.assertNotNull("child link wasn't created", entity3);
        Assert.assertCanSetParticipant((Link)entity3, SOURCE_ROLE, null, (Element)entity);
        entity3.setParticipant(SOURCE_ROLE, null, (Element)entity);
        Assert.assertCanSetParticipant((Link)entity3, TARGET_ROLE, null, (Element)entity2);
        entity3.setParticipant(TARGET_ROLE, null, (Element)entity2);
        return entity3;
    }

    public static Entity getLinkSource(Entity entity) {
        ElementEnumeration elementEnumeration = entity.participants(SOURCE_ROLE);
        if (elementEnumeration.hasMoreElements()) {
            return (Entity)elementEnumeration.next();
        }
        return null;
    }

    public static Entity getLinkTarget(Entity entity) {
        ElementEnumeration elementEnumeration = entity.participants(TARGET_ROLE);
        if (elementEnumeration.hasMoreElements()) {
            Entity entity2 = (Entity)elementEnumeration.next();
            return entity2;
        }
        System.err.println("ElementUtil # getLinkTarget " + entity.getPropertyValue("$metaclass") + " : NO PARTICIPANTS with role: " + TARGET_ROLE);
        return null;
    }

    public static Entity replaceLinkSource(Entity entity, Entity entity2) {
        Object object;
        Object object2;
        Property property;
        Assert.assertNotNull("link is NULL", entity);
        Assert.assertNotNull("New source is NULL", entity2);
        Entity entity3 = ElementUtil.getLinkSource(entity);
        Entity entity4 = ElementUtil.getLinkTarget(entity);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        PropertyEnumeration propertyEnumeration = entity.properties();
        while (propertyEnumeration.hasMoreElements()) {
            property = propertyEnumeration.next();
            object2 = property.getName();
            if (((String)object2).equals("link_property") || !ElementUtil.isOurEntityAttribute((String)object2)) continue;
            hashMap.put((String)object2, property.getValue());
        }
        Assert.assertCanCut(entity);
        property = ElementUtil.cutDefault(entity);
        Assert.assertNotNull("Link after 'cut' is NULL", property);
        Assert.assertCanPaste((Container)entity2, (Element)property);
        entity = (Entity)ElementUtil.pasteDefault((Container)entity2, (Element)property);
        Assert.assertNotNull("Link after 'paste' is NULL", entity);
        Assert.assertCanSetParticipant((Link)entity, SOURCE_ROLE, null, (Element)entity2);
        entity.setParticipant(SOURCE_ROLE, null, (Element)entity2);
        Assert.assertCanSetParticipant((Link)entity, TARGET_ROLE, null, (Element)entity4);
        entity.setParticipant(TARGET_ROLE, null, (Element)entity4);
        object2 = new HashMap();
        propertyEnumeration = entity.properties();
        while (propertyEnumeration.hasMoreElements()) {
            object = propertyEnumeration.next();
            ((HashMap)object2).put(object.getName(), object.getValue());
        }
        object = hashMap.keySet().iterator();
        while (object.hasNext()) {
            String string;
            String string2 = (String)object.next();
            String string3 = (String)hashMap.get(string2);
            if (string3.equals(string = (String)((HashMap)object2).get(string2))) continue;
            System.err.println("ElementUtil.replaceLinkSource: after cut/paste " + entity.getPropertyValue("$metaclass") + " property " + string2 + " is corrupted, was: " + string3 + " but now: " + string);
            entity.setPropertyValue(string2, string3);
        }
        return entity;
    }

    public static Entity replaceLinkTarget(Entity entity, Entity entity2) {
        Entity entity3 = ElementUtil.getLinkTarget(entity);
        Assert.assertCanSetParticipant((Link)entity, TARGET_ROLE, (Element)entity3, (Element)entity2);
        entity.setParticipant(TARGET_ROLE, (Element)entity3, (Element)entity2);
        return entity;
    }

    public static Entity replaceEntityParent(Entity entity, Container container) {
        Assert.assertNotNull("Child is NULL", entity);
        Assert.assertNotNull("New container is NULL", container);
        Assert.assertCanCut(entity);
        Entity entity2 = ElementUtil.cutDefault(entity);
        Assert.assertNotNull("Child after 'cut' is NULL", entity2);
        Assert.assertCanPaste(container, (Element)entity2);
        Entity entity3 = (Entity)ElementUtil.pasteDefault(container, (Element)entity2);
        Assert.assertNotNull("Child after 'paste' is NULL", entity3);
        return entity3;
    }

    public static Reference getLinkSource(Reference reference) {
        ReferenceCollection referenceCollection = ElementUtil.getParentCollection(reference);
        Assert.assertNotNull("Can't fing reference diagram for link reference: " + reference, referenceCollection);
        Entity entity = ElementUtil.getLinkSource(reference.getEntity());
        return ElementUtil.findReference(referenceCollection, entity);
    }

    public static Reference getLinkTarget(Reference reference) {
        ReferenceCollection referenceCollection = ElementUtil.getParentCollection(reference);
        Assert.assertNotNull("Can't fing reference diagram for link reference: " + reference, referenceCollection);
        Entity entity = ElementUtil.getLinkTarget(reference.getEntity());
        return ElementUtil.findReference(referenceCollection, entity);
    }

    public static Element getLinkTarget(Element element) {
        if (element instanceof Reference) {
            return ElementUtil.getLinkTarget((Reference)element);
        }
        return ElementUtil.getLinkTarget((Entity)element);
    }

    public static Reference findReference(ReferenceCollection referenceCollection, Entity entity) {
        if (entity == null) {
            return null;
        }
        Assert.assertNotNull("ElementUtil.findReference: reference collection is NULL", referenceCollection);
        ReferenceCacheFactory referenceCacheFactory = ReferenceCacheAccess.getFactory(referenceCollection);
        Assert.assertNotNull("No ReferenceCacheFactory registered for model : " + referenceCollection.getModel().getUniqueName(), referenceCacheFactory);
        return referenceCacheFactory.getCache(referenceCollection).findCachedReference(entity.getUniqueName());
    }

    public static void dumpReferenceContainer(ReferenceContainer referenceContainer, PrintStream printStream) {
        printStream.println("------ dump ReferenceContainer ------");
        if (referenceContainer == null) {
            printStream.println("ReferenceContainer == NULL");
            return;
        }
        printStream.print("container: \"" + ((Element)referenceContainer).getPropertyValue("$name") + "\" " + ((Element)referenceContainer).getPropertyValue("$metaclass") + " :" + referenceContainer.getClass().getName());
        ElementUtil.dumpReferenceContainer(referenceContainer, 0, printStream);
        printStream.println("------ END dump ReferenceContainer --");
    }

    public static void dumpReferenceContainer(ReferenceContainer referenceContainer, int n2, PrintStream printStream) {
        char[] cArray = new char[n2 * 2];
        Arrays.fill(cArray, ' ');
        Entity entity = null;
        if (referenceContainer instanceof Entity) {
            entity = (Entity)referenceContainer;
        } else if (referenceContainer instanceof Reference) {
            entity = ((Reference)referenceContainer).getEntity();
        }
        String string = entity == null ? "Not found!" : entity.getPropertyValue("$name");
        String string2 = entity == null ? "N/A" : entity.getUniqueName().toString();
        printStream.println("[" + n2 + "]" + String.valueOf(cArray) + " entity:\"" + string + "\" uid:" + string2 + " element uid:" + ((Element)referenceContainer).getUniqueName());
        ReferenceEnumeration referenceEnumeration = referenceContainer.references();
        while (referenceEnumeration.hasMoreElements()) {
            ElementUtil.dumpReferenceContainer((ReferenceContainer)referenceEnumeration.next(), n2 + 1, printStream);
        }
    }

    public static void dumpElement(PropertyMap propertyMap) {
        System.out.println("------ dump element ------");
        System.out.println("element      : " + propertyMap);
        if (propertyMap != null) {
            System.out.println("element class: " + propertyMap.getClass().getName());
            System.out.println("metaclass    : " + propertyMap.getPropertyValue("$metaclass"));
            System.out.println("name         : " + propertyMap.getPropertyValue("$name"));
            String string = "undefined";
            String string2 = "unknown";
            if (propertyMap instanceof Reference) {
                string = ((Reference)propertyMap).getUniqueName().toString();
                string2 = "refernce";
            } else if (propertyMap instanceof Element) {
                string = ((Element)propertyMap).getUniqueName().toString();
                string2 = "element";
            }
            System.out.println("<" + string2 + "> - unique name : " + string);
            if (string.indexOf("link") >= 0) {
                System.out.println(" link source: ");
                System.out.println("--------------------------");
                ElementUtil.dumpElement((PropertyMap)ElementUtil.getLinkSource((Entity)propertyMap));
                System.out.println(" link target: ");
                System.out.println("--------------------------");
                ElementUtil.dumpElement((PropertyMap)ElementUtil.getLinkTarget((Entity)propertyMap));
            }
        }
        System.out.println("--------------------------");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void deleteDefault(Element element) {
        EntityCache.clearAll();
        EntityCache.disable();
        try {
            try {
                element.delete();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                Object var3_2 = null;
                EntityCache.enable();
                return;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            EntityCache.enable();
            throw throwable;
        }
        EntityCache.enable();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Entity cutDefault(Entity entity) {
        Entity entity2;
        CopyExtendersState.setEnabled(false);
        try {
            try {
                entity2 = entity.cut();
                Object var3_3 = null;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                Object var3_4 = null;
                CopyExtendersState.setEnabled(true);
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            CopyExtendersState.setEnabled(true);
            throw throwable;
        }
        CopyExtendersState.setEnabled(true);
        return entity2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Element pasteDefault(Container container, Element element) {
        Element element2;
        CopyExtendersState.setEnabled(false);
        try {
            try {
                element2 = container.paste(element);
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                Object var4_5 = null;
                CopyExtendersState.setEnabled(true);
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            CopyExtendersState.setEnabled(true);
            throw throwable;
        }
        CopyExtendersState.setEnabled(true);
        return element2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

