/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.interaction.util;

import com.togethersoft.togetherxj.uml.interaction.util.AssertionFailedException;
import com.tssap.selena.model.elements.Container;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Link;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceContainer;

public class Assert {
    protected Assert() {
    }

    public static void assertCanCreateChildEntity(Container container, String string) {
        PropertyMap propertyMap = (PropertyMap)container;
        Assert.assertTrue("Can't create child [" + string + "] in container: " + propertyMap.getPropertyValue("$name") + " : " + propertyMap.getPropertyValue("$metaclass"), container.canCreateChildEntity(string, null));
    }

    public static void assertCanCut(Entity entity) {
        Entity entity2 = entity.getParent();
        String string = entity2 != null ? entity2.getPropertyValue("$name") : "NULL";
        Assert.assertTrue("Can't cut [" + entity.getPropertyValue("$metaclass") + "] from: " + string, entity.canCut());
    }

    public static void assertCanPaste(Container container, Element element) {
        PropertyMap propertyMap = (PropertyMap)container;
        Assert.assertTrue("Can't paste [" + element.getPropertyValue("$metaclass") + "] to: " + propertyMap.getPropertyValue("$name"), container.canPaste(element));
    }

    public static void assertCanSetParticipant(Link link, String string, Element element, Element element2) {
        PropertyMap propertyMap = (PropertyMap)link;
        String string2 = element != null ? element.getPropertyValue("$name") : "NULL";
        String string3 = element2 != null ? element2.getPropertyValue("$name") : "NULL";
        Assert.assertTrue("Can't change <" + string + "> : [" + string2 + "]-->[" + string3 + "] of link: " + propertyMap.getPropertyValue("$metaclass"), link.canSetParticipant(string, element, element2));
    }

    public static void assertCanDelete(Reference reference) {
        Assert.assertTrue("Can't delete reference [" + reference.getPropertyValue("$metaclass") + "] " + reference, reference.canDelete());
    }

    public static void assertCanDelete(Entity entity) {
        Assert.assertTrue("Can't delete [" + entity.getPropertyValue("$metaclass") + "]", entity.canDelete());
    }

    public static void assertCanAddReference(ReferenceContainer referenceContainer, Entity entity, Reference reference) {
        PropertyMap propertyMap = (PropertyMap)referenceContainer;
        Assert.assertTrue("Can't add reference on [" + entity.getPropertyValue("$metaclass") + "] in container \"" + propertyMap.getPropertyValue("$name") + "\" [" + propertyMap.getPropertyValue("$metaclass") + "]", referenceContainer.canAddReference(entity, reference));
    }

    public static void notImplementedFail() {
        Assert.fail("NOT IMPLEMENTED");
    }

    public static void assertTrue(String string, boolean bl2) {
        if (!bl2) {
            Assert.fail(string);
        }
    }

    public static void assertTrue(boolean bl2) {
        Assert.assertTrue(null, bl2);
    }

    public static void fail(String string) {
        AssertionFailedException assertionFailedException = new AssertionFailedException(string);
        System.err.println("AssertionFailedException will be thrown:\n");
        assertionFailedException.printStackTrace(System.err);
        throw assertionFailedException;
    }

    public static void fail() {
        Assert.fail(null);
    }

    public static void assertEquals(String string, Object object, Object object2) {
        if (object == null && object2 == null) {
            return;
        }
        if (object != null && object.equals(object2)) {
            return;
        }
        Assert.failNotEquals(string, object, object2);
    }

    public static void assertEquals(Object object, Object object2) {
        Assert.assertEquals(null, object, object2);
    }

    public static void assertNotNull(Object object) {
        Assert.assertNotNull(null, object);
    }

    public static void assertNotNull(String string, Object object) {
        Assert.assertTrue(string, object != null);
    }

    private static void failNotEquals(String string, Object object, Object object2) {
        String string2 = "";
        if (string != null) {
            string2 = string + " ";
        }
        Assert.fail(string2 + "expected:<" + object + "> but was:<" + object2 + ">");
    }

    private static void failNotSame(String string, Object object, Object object2) {
        String string2 = "";
        if (string != null) {
            string2 = string + " ";
        }
        Assert.fail(string2 + "expected same");
    }
}

