/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.interaction.solver.ui;

import com.togethersoft.togetherxj.uml.interaction.solver.IAssociatedProblem;
import com.togethersoft.togetherxj.uml.interaction.solver.ICompletableProblemSolution;
import com.togethersoft.togetherxj.uml.interaction.solver.IProblem;
import com.togethersoft.togetherxj.uml.interaction.solver.IProblemComposite;
import com.togethersoft.togetherxj.uml.interaction.solver.IProblemSolution;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class ProblemsTreeLabelProvider
extends LabelProvider {
    private static final String NO_SOLUTION_AVAILABLE = "No Solution Available";
    private static final String NO_SOLUTION_SELECTED = "No Solution Selected";
    private static final String INCOMPLETE_SUFFIX = " - incomplete";

    public Image getImage(Object object) {
        if (object instanceof IProblem) {
            return ((IProblem)object).getImage();
        }
        return super.getImage(object);
    }

    public String getText(Object object) {
        if (object instanceof IProblem) {
            boolean bl2;
            IProblem[] iProblemArray;
            IProblem iProblem = (IProblem)object;
            String string = iProblem.getLabelText();
            if (!iProblem.hasSolution()) {
                string = string + " : " + NO_SOLUTION_AVAILABLE;
                return string;
            }
            if (iProblem instanceof IProblemComposite) {
                iProblemArray = ((IProblemComposite)iProblem).getChildren();
                if (!this.allChildrenCompleted((IProblemComposite)iProblem)) {
                    string = string + INCOMPLETE_SUFFIX;
                }
            } else {
                iProblemArray = iProblem.getCurrentSolution();
                if (iProblemArray == null) {
                    string = string + " : " + NO_SOLUTION_SELECTED;
                } else {
                    boolean bl3;
                    string = string + " -> [" + iProblemArray.getLabelText() + "]";
                    if (iProblemArray instanceof ICompletableProblemSolution && !(bl3 = ((ICompletableProblemSolution)iProblemArray).isComplete())) {
                        string = string + INCOMPLETE_SUFFIX;
                    }
                }
            }
            if (iProblem instanceof IAssociatedProblem && (bl2 = ((IAssociatedProblem)iProblem).isEliminated())) {
                string = string + " !ELIMINATED!";
            }
            return string;
        }
        return super.getText(object);
    }

    protected boolean allChildrenCompleted(IProblemComposite iProblemComposite) {
        IProblem[] iProblemArray = iProblemComposite.getChildren();
        int n2 = 0;
        while (n2 < iProblemArray.length) {
            IProblemSolution iProblemSolution = iProblemArray[n2].getCurrentSolution();
            if (iProblemSolution == null) {
                return false;
            }
            if (iProblemSolution instanceof ICompletableProblemSolution && !((ICompletableProblemSolution)((Object)iProblemSolution)).isComplete()) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

