/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.interaction.solver.ui;

import com.togethersoft.togetherxj.uml.interaction.solver.IProblem;
import com.togethersoft.togetherxj.uml.interaction.solver.IProblemSolution;
import com.togethersoft.togetherxj.uml.interaction.solver.ui.Messages;
import com.togethersoft.togetherxj.uml.interaction.solver.ui.ProblemSolverPageController;
import com.togethersoft.togetherxj.uml.interaction.solver.ui.ProblemSolverWizard;
import com.togethersoft.togetherxj.uml.interaction.solver.ui.ProblemSolverWizardPage$1;
import com.togethersoft.togetherxj.uml.interaction.solver.ui.ProblemsTreeContentProvider;
import com.togethersoft.togetherxj.uml.interaction.solver.ui.ProblemsTreeLabelProvider;
import com.tssap.selena.model.elements.ModelAccess;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;

public class ProblemSolverWizardPage
extends WizardPage {
    public static final String APPLY_SOLUTION_BUTTON_TEXT = Messages.getString("ProblemSolverWizardPage.Accept_1");
    public static final String APPLY_SOLUTION_TO_CHILDREN_BUTTON_TEXT = Messages.getString("ProblemSolverWizardPage.Accept_for_Children_2");
    public static final String DEFAULT_COMPLETE_BUTTON_TEXT = Messages.getString("ProblemSolverWizardPage.Complete_Solution_3");
    private Object myTreeInput;
    private IProblem[] myProblems;
    private ProblemSolverPageController myController;

    public ProblemSolverWizardPage(String string) {
        super(string);
        this.setTreeInput(new Object());
        this.myProblems = new IProblem[0];
        this.myController = new ProblemSolverPageController();
        this.myController.setProblems(this.myProblems);
        this.myController.setWizardPage(this);
    }

    protected void init(ProblemSolverWizard problemSolverWizard) {
        this.myController.updatePageErrorStatus();
    }

    public WizardDialog getWizardDialog() {
        IWizardContainer iWizardContainer = this.getContainer();
        return (WizardDialog)iWizardContainer;
    }

    public void setTreeInput(Object object) {
        this.myTreeInput = object;
    }

    public void setProblems(IProblem[] iProblemArray) {
        this.myProblems = iProblemArray;
        this.myController.setProblems(this.myProblems);
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        Text text = this.creatProblemDescriptionText(composite2, 4, 0);
        this.myController.setProblemDescriptionText(text);
        Composite composite3 = this.createProblemsPanel(composite2);
        this.setControl((Control)composite2);
    }

    public IRunnableWithProgress getRunnable() {
        return new ProblemSolverWizardPage$1(this);
    }

    protected void solveProblems(IProgressMonitor iProgressMonitor) throws CoreException, InterruptedException {
        Collection collection = this.myController.createProblemsToSolveCollection();
        Iterator iterator = collection.iterator();
        iProgressMonitor.beginTask("", collection.size());
        while (iterator.hasNext()) {
            IProblem iProblem = (IProblem)iterator.next();
            IProblemSolution iProblemSolution = iProblem.getCurrentSolution();
            try {
                iProgressMonitor.setTaskName(iProblemSolution.getLabelText());
                ModelAccess.runCommand((Runnable)iProblemSolution.getSolveCommand(), (String)iProblemSolution.getLabelText());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            iProgressMonitor.worked(1);
        }
        iProgressMonitor.done();
    }

    protected Text creatProblemDescriptionText(Composite composite, int n2, int n3) {
        GridData gridData = new GridData(1808);
        return this.createTextWidget(composite, n2, n3, 74, gridData);
    }

    protected Text creatSolutionDescriptionText(Composite composite, int n2, int n3) {
        Group group = new Group(composite, 0);
        GridLayout gridLayout = new GridLayout();
        group.setLayout((Layout)gridLayout);
        group.setText(Messages.getString("ProblemSolverWizardPage.Solution_Description_5"));
        group.setLayoutData((Object)new GridData(1808));
        GridData gridData = new GridData(1808);
        return this.createTextWidget((Composite)group, n2, n3, 74, gridData);
    }

    protected Text createTextWidget(Composite composite, int n2, int n3, int n4, GridData gridData) {
        Text text = new Text(composite, n4);
        if (n2 > 0) {
            gridData.heightHint = this.convertHeightInCharsToPixels(n2);
        }
        if (n3 > 0) {
            gridData.widthHint = this.convertWidthInCharsToPixels(n3);
        }
        text.setLayoutData((Object)gridData);
        return text;
    }

    protected Composite createProblemsPanel(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Tree tree = this.createProblemsTreeViewer(composite2);
        GridData gridData = new GridData(1808);
        gridData.widthHint = this.convertWidthInCharsToPixels(70);
        gridData.heightHint = this.convertHeightInCharsToPixels(24);
        tree.setLayoutData((Object)gridData);
        Composite composite3 = this.createPropblemSolutionPanel(composite2);
        gridData = new GridData(1808);
        gridData.widthHint = this.convertWidthInCharsToPixels(45);
        composite3.setLayoutData((Object)gridData);
        return composite2;
    }

    protected Tree createProblemsTreeViewer(Composite composite) {
        TreeViewer treeViewer = new TreeViewer(composite, 2048);
        ProblemsTreeContentProvider problemsTreeContentProvider = new ProblemsTreeContentProvider(this.myProblems);
        treeViewer.setContentProvider((IContentProvider)problemsTreeContentProvider);
        treeViewer.setLabelProvider((IBaseLabelProvider)new ProblemsTreeLabelProvider());
        treeViewer.setInput(this.myTreeInput);
        this.myController.setProblemsTreeViewer(treeViewer);
        return treeViewer.getTree();
    }

    protected Composite createPropblemSolutionPanel(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        Text text = this.creatSolutionDescriptionText(composite2, 10, 0);
        this.myController.setSolutionDescriptionText(text);
        List list = this.createPropblemSolutionsList(composite2);
        this.myController.setSolutionsList(list);
        Group group = this.createProblemSolutionButtons(composite2);
        return composite2;
    }

    protected List createPropblemSolutionsList(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(1808));
        group.setText(Messages.getString("ProblemSolverWizardPage.Available_Solutions_6"));
        List list = new List((Composite)group, 2820);
        list.setLayoutData((Object)new GridData(1808));
        list.setEnabled(false);
        return list;
    }

    protected Group createProblemSolutionButtons(Composite composite) {
        Group group = new Group(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        group.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        group.setLayoutData((Object)gridData);
        group.setText(Messages.getString("ProblemSolverWizardPage.Solution_Actions_7"));
        Button button = new Button((Composite)group, 8);
        gridData = new GridData();
        gridData.horizontalAlignment = 2;
        gridData.widthHint = this.convertWidthInCharsToPixels(20);
        button.setLayoutData((Object)gridData);
        button.setText(APPLY_SOLUTION_BUTTON_TEXT);
        this.myController.setApplySolutionButton(button);
        Button button2 = new Button((Composite)group, 8);
        gridData = new GridData();
        gridData.horizontalAlignment = 2;
        gridData.widthHint = this.convertWidthInCharsToPixels(20);
        button2.setLayoutData((Object)gridData);
        button2.setText(DEFAULT_COMPLETE_BUTTON_TEXT);
        this.myController.setCompleteSolutionButton(button2);
        return group;
    }
}

