/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.interaction.solver.ui;

import com.togethersoft.togetherxj.uml.interaction.solver.IAssociatedProblem;
import com.togethersoft.togetherxj.uml.interaction.solver.ICompletableProblemSolution;
import com.togethersoft.togetherxj.uml.interaction.solver.INamedRunnable;
import com.togethersoft.togetherxj.uml.interaction.solver.IProblem;
import com.togethersoft.togetherxj.uml.interaction.solver.IProblemComposite;
import com.togethersoft.togetherxj.uml.interaction.solver.IProblemSolution;
import com.togethersoft.togetherxj.uml.interaction.solver.ui.Messages;
import com.togethersoft.togetherxj.uml.interaction.solver.ui.ProblemSolverPageController$1;
import com.togethersoft.togetherxj.uml.interaction.solver.ui.ProblemSolverPageController$2;
import com.togethersoft.togetherxj.uml.interaction.solver.ui.ProblemSolverPageController$3;
import com.togethersoft.togetherxj.uml.interaction.solver.ui.ProblemSolverPageController$4;
import com.togethersoft.togetherxj.uml.interaction.solver.ui.ProblemSolverWizardPage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

public class ProblemSolverPageController {
    private static final String APPLY_TO_CHILDREN_TEXT = "\n\nThis solution won't be used unless it applied to all child problems.\nTo apply this solution to all children press \"Apply to Children\" button.";
    private ProblemSolverWizardPage myWizardPage;
    private Text myProblemDescription;
    private Text mySolutionDescription;
    private TreeViewer myProblemsTree;
    private List mySolutionsList;
    private Button myCompleteButton;
    private Button myApplyButton;
    private IProblem[] myProblems;
    private IProblem myCurrentProblem;
    private int myCurrentSolutionIndex = -1;
    private IProblemSolution[] myCurrentSolutions;

    public void setProblems(IProblem[] iProblemArray) {
        this.myProblems = iProblemArray;
    }

    public void setWizardPage(ProblemSolverWizardPage problemSolverWizardPage) {
        this.myWizardPage = problemSolverWizardPage;
    }

    public void setProblemDescriptionText(Text text) {
        this.myProblemDescription = text;
        this.myProblemDescription.setText(Messages.getString("ProblemSolverPageController.No_problem_selected_2"));
    }

    public void setSolutionDescriptionText(Text text) {
        this.mySolutionDescription = text;
        this.mySolutionDescription.setText("");
    }

    public void setProblemsTreeViewer(TreeViewer treeViewer) {
        this.myProblemsTree = treeViewer;
        this.myProblemsTree.addSelectionChangedListener((ISelectionChangedListener)new ProblemSolverPageController$1(this));
    }

    public void setSolutionsList(List list) {
        this.mySolutionsList = list;
        this.mySolutionsList.addSelectionListener((SelectionListener)new ProblemSolverPageController$2(this));
    }

    protected void handleListSelection() {
        int n2 = this.mySolutionsList.getSelectionIndex();
        if (this.myCurrentSolutionIndex != n2) {
            this.myCurrentSolutionIndex = n2;
            this.updateSolutionControls();
        }
    }

    public void setCompleteSolutionButton(Button button) {
        this.myCompleteButton = button;
        this.myCompleteButton.setEnabled(false);
        this.myCompleteButton.addSelectionListener((SelectionListener)new ProblemSolverPageController$3(this));
    }

    public void setApplySolutionButton(Button button) {
        this.myApplyButton = button;
        this.myApplyButton.setEnabled(false);
        this.myApplyButton.addSelectionListener((SelectionListener)new ProblemSolverPageController$4(this));
    }

    protected void handleCompleteButtonSelection() {
        IProblemSolution iProblemSolution;
        if (this.myCurrentProblem != null && (iProblemSolution = this.myCurrentSolutions[this.myCurrentSolutionIndex]) instanceof ICompletableProblemSolution) {
            ICompletableProblemSolution iCompletableProblemSolution = (ICompletableProblemSolution)((Object)iProblemSolution);
            Object object = iCompletableProblemSolution.getCompletingObject();
            IRunnableWithProgress iRunnableWithProgress = iCompletableProblemSolution.getCompleteCommand();
            if (iRunnableWithProgress != null) {
                boolean bl2;
                try {
                    WizardDialog wizardDialog = this.myWizardPage.getWizardDialog();
                    wizardDialog.run(false, false, iRunnableWithProgress);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                boolean bl3 = bl2 = object != iCompletableProblemSolution.getCompletingObject();
                if (bl2 && !this.isComposite(this.myCurrentProblem)) {
                    this.myCurrentProblem.setCurrentSolution(this.myCurrentSolutions[this.myCurrentSolutionIndex]);
                    this.refreshSolutionsList();
                    this.updateSolutionControls();
                    this.refreshProblemsTree();
                    this.updatePageErrorStatus();
                } else {
                    this.refreshSolutionsList();
                    this.updateSolutionControls();
                }
            }
        }
    }

    protected void handleApplyButtonSelection() {
        this.myCurrentProblem.setCurrentSolution(this.myCurrentSolutions[this.myCurrentSolutionIndex]);
        if (this.isComposite(this.myCurrentProblem)) {
            ((IProblemComposite)this.myCurrentProblem).applyCurrentSolutionToChildren();
        }
        this.refreshSolutionsList();
        this.updateSolutionControls();
        this.refreshProblemsTree();
        this.updatePageErrorStatus();
    }

    protected void updateProblemControls() {
        if (this.myCurrentProblem == null) {
            this.myProblemDescription.setText(Messages.getString("ProblemSolverPageController.No_problem_selected_4"));
        } else {
            this.myProblemDescription.setText(this.createProblemDescriptionText(this.myCurrentProblem));
        }
        this.refreshSolutionsList();
        this.updateSolutionControls();
    }

    protected String createProblemDescriptionText(IProblem iProblem) {
        IAssociatedProblem iAssociatedProblem;
        IAssociatedProblem[] iAssociatedProblemArray;
        String string = iProblem.getDescriptionText();
        if (this.isAssociated(iProblem) && (iAssociatedProblemArray = (iAssociatedProblem = (IAssociatedProblem)iProblem).getAssociations()) != null && iAssociatedProblemArray.length > 0) {
            string = string + Messages.getString("ProblemSolverPageController._nThis_problem_is_associated_with__5");
            int n2 = 0;
            while (n2 < iAssociatedProblemArray.length) {
                IAssociatedProblem iAssociatedProblem2 = iAssociatedProblemArray[n2];
                string = string + "\n   " + iAssociatedProblem2.getLabelText() + Messages.getString("ProblemSolverPageController._problem._7");
                ++n2;
            }
        }
        return string;
    }

    protected void updateSolutionControls() {
        String string = ProblemSolverWizardPage.APPLY_SOLUTION_BUTTON_TEXT;
        if (this.isComposite(this.myCurrentProblem)) {
            string = ProblemSolverWizardPage.APPLY_SOLUTION_TO_CHILDREN_BUTTON_TEXT;
        }
        this.myApplyButton.setText(string);
        if (this.myCurrentSolutionIndex < 0 || this.myCurrentSolutions == null || this.myCurrentSolutionIndex >= this.myCurrentSolutions.length) {
            this.myApplyButton.setEnabled(false);
            this.myCurrentProblem.setCurrentSolution(null);
            this.mySolutionDescription.setText("");
            this.myCompleteButton.setEnabled(false);
            this.myCompleteButton.setText(ProblemSolverWizardPage.DEFAULT_COMPLETE_BUTTON_TEXT);
        } else {
            IProblemSolution iProblemSolution = this.myCurrentSolutions[this.myCurrentSolutionIndex];
            if (this.isComposite(this.myCurrentProblem) || iProblemSolution != this.myCurrentProblem.getCurrentSolution()) {
                this.myApplyButton.setEnabled(true);
            } else {
                this.myApplyButton.setEnabled(false);
            }
            this.mySolutionDescription.setText(this.createSolutionDescriptionText(this.myCurrentProblem, iProblemSolution));
            IRunnableWithProgress iRunnableWithProgress = null;
            String string2 = ProblemSolverWizardPage.DEFAULT_COMPLETE_BUTTON_TEXT;
            if (iProblemSolution instanceof ICompletableProblemSolution && (iRunnableWithProgress = ((ICompletableProblemSolution)((Object)iProblemSolution)).getCompleteCommand()) instanceof INamedRunnable) {
                string2 = ((INamedRunnable)iRunnableWithProgress).getName();
            }
            this.myCompleteButton.setText(string2);
            this.myCompleteButton.setEnabled(iRunnableWithProgress != null);
        }
    }

    protected String createSolutionDescriptionText(IProblem iProblem, IProblemSolution iProblemSolution) {
        String string = iProblemSolution.getLabelText() + Messages.getString("ProblemSolverPageController._solution._n_9") + iProblemSolution.getDescriptionText();
        if (this.isComposite(iProblem)) {
            string = string + APPLY_TO_CHILDREN_TEXT;
        }
        return string;
    }

    protected void refreshProblemsTree() {
        this.myProblemsTree.refresh(true);
    }

    protected void refreshSolutionsList() {
        this.mySolutionsList.removeAll();
        if (this.myCurrentSolutions == null) {
            this.mySolutionsList.setEnabled(false);
        } else {
            if (this.myCurrentSolutions != null) {
                int n2 = 0;
                while (n2 < this.myCurrentSolutions.length) {
                    IProblemSolution iProblemSolution = this.myCurrentSolutions[n2];
                    this.mySolutionsList.add(iProblemSolution.getLabelText());
                    ++n2;
                }
            }
            this.mySolutionsList.setEnabled(true);
            this.mySolutionsList.setSelection(this.myCurrentSolutionIndex);
        }
        if (this.myCurrentProblem.isImmutable()) {
            this.mySolutionsList.setEnabled(false);
        }
    }

    protected void updatePageErrorStatus() {
        int n2 = 0;
        Iterator iterator = this.createProblemsToSolveCollection().iterator();
        while (iterator.hasNext()) {
            IProblem iProblem = (IProblem)iterator.next();
            IProblemSolution iProblemSolution = iProblem.getCurrentSolution();
            if (!(iProblemSolution instanceof ICompletableProblemSolution) || ((ICompletableProblemSolution)((Object)iProblemSolution)).isComplete()) continue;
            ++n2;
        }
        if (n2 == 0) {
            this.myWizardPage.setErrorMessage(null);
            this.myWizardPage.setPageComplete(true);
        } else {
            this.myWizardPage.setErrorMessage("" + n2 + Messages.getString("ProblemSolverPageController._problem_11") + (n2 > 1 ? Messages.getString("ProblemSolverPageController.s_have_12") : Messages.getString("ProblemSolverPageController._has_13")) + Messages.getString("ProblemSolverPageController._incomplete_solution_14"));
            this.myWizardPage.setPageComplete(false);
        }
    }

    public Collection createProblemsToSolveCollection() {
        return this.createProblemsToSolveCollection(this.myProblems);
    }

    protected Collection createProblemsToSolveCollection(IProblem[] iProblemArray) {
        ArrayList<IProblem> arrayList = new ArrayList<IProblem>();
        int n2 = 0;
        while (n2 < iProblemArray.length) {
            IProblem iProblem = iProblemArray[n2];
            if (this.isComposite(iProblem)) {
                Collection collection = this.createProblemsToSolveCollection(((IProblemComposite)iProblem).getChildren());
                arrayList.addAll(collection);
            } else if (!(iProblem.isImmutable() || this.isAssociated(iProblem) && ((IAssociatedProblem)iProblem).isEliminated())) {
                arrayList.add(iProblem);
            }
            ++n2;
        }
        return arrayList;
    }

    protected boolean isAssociated(IProblem iProblem) {
        return iProblem instanceof IAssociatedProblem;
    }

    protected boolean isComposite(IProblem iProblem) {
        return iProblem instanceof IProblemComposite;
    }

    static TreeViewer access$000(ProblemSolverPageController problemSolverPageController) {
        return problemSolverPageController.myProblemsTree;
    }

    static IProblem access$100(ProblemSolverPageController problemSolverPageController) {
        return problemSolverPageController.myCurrentProblem;
    }

    static IProblem access$102(ProblemSolverPageController problemSolverPageController, IProblem iProblem) {
        problemSolverPageController.myCurrentProblem = iProblem;
        return problemSolverPageController.myCurrentProblem;
    }

    static IProblemSolution[] access$202(ProblemSolverPageController problemSolverPageController, IProblemSolution[] iProblemSolutionArray) {
        problemSolverPageController.myCurrentSolutions = iProblemSolutionArray;
        return iProblemSolutionArray;
    }

    static int access$302(ProblemSolverPageController problemSolverPageController, int n2) {
        problemSolverPageController.myCurrentSolutionIndex = n2;
        return problemSolverPageController.myCurrentSolutionIndex;
    }

    static IProblemSolution[] access$200(ProblemSolverPageController problemSolverPageController) {
        return problemSolverPageController.myCurrentSolutions;
    }
}

