/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.interaction.solver;

import com.togethersoft.togetherxj.uml.interaction.solver.AbstractGroupingAttribute;
import com.togethersoft.togetherxj.uml.interaction.solver.ICompletableProblemSolution;
import com.togethersoft.togetherxj.uml.interaction.solver.IProblem;
import com.togethersoft.togetherxj.uml.interaction.solver.IProblemComposite;
import com.togethersoft.togetherxj.uml.interaction.solver.IProblemSolution;
import com.togethersoft.togetherxj.uml.interaction.util.Assert;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.graphics.Image;

public class ProblemComposite
implements IProblemComposite {
    private AbstractGroupingAttribute myGroupingAttribute;
    private IProblemComposite myParent;
    private List myChildrenList;
    private IProblemSolution[] mySolutions;
    private IProblem[] myChildrenArray;
    private IProblemSolution myCurrentSolution;

    public ProblemComposite(AbstractGroupingAttribute abstractGroupingAttribute) {
        this.myGroupingAttribute = abstractGroupingAttribute;
        this.myChildrenList = new ArrayList();
    }

    public boolean isImmutable() {
        return false;
    }

    public Object getSource() {
        return null;
    }

    public Image getImage() {
        return this.myGroupingAttribute.getImage();
    }

    public void childrenChanged() {
        this.mySolutions = null;
        this.myCurrentSolution = null;
        if (this.getParent() != null) {
            this.getParent().childrenChanged();
        }
    }

    public boolean isSameGroupingAttribute(AbstractGroupingAttribute abstractGroupingAttribute) {
        return this.myGroupingAttribute.equals(abstractGroupingAttribute);
    }

    public String getUniqueID() {
        return Integer.toHexString(this.hashCode()) + "_" + this.getCategoryID();
    }

    public String getCategoryID() {
        return this.myGroupingAttribute.getLabelText();
    }

    public void add(IProblem iProblem) {
        this.myChildrenArray = null;
        this.myChildrenList.add(iProblem);
        iProblem.setParent(this);
        this.childrenChanged();
    }

    public IProblem[] getChildren() {
        if (this.myChildrenArray == null) {
            this.myChildrenArray = this.myChildrenList.toArray(new IProblem[this.myChildrenList.size()]);
        }
        return this.myChildrenArray;
    }

    public String getLabelText() {
        return this.myGroupingAttribute.getLabelText();
    }

    public String getDescriptionText() {
        return this.myGroupingAttribute.getDescriptionText();
    }

    public IProblemComposite getParent() {
        return this.myParent;
    }

    public void setParent(IProblemComposite iProblemComposite) {
        this.myParent = iProblemComposite;
    }

    public boolean hasSolution() {
        Iterator iterator = this.myChildrenList.iterator();
        while (iterator.hasNext()) {
            IProblem iProblem = (IProblem)iterator.next();
            if (iProblem.hasSolution()) continue;
            return false;
        }
        return true;
    }

    public IProblemSolution[] getSolutions() {
        if (this.mySolutions == null && this.myChildrenList.size() > 0) {
            this.initSolutions();
        }
        return this.mySolutions;
    }

    protected void initSolutions() {
        IProblemSolution[] iProblemSolutionArray;
        IProblem[] iProblemArray = this.getChildren();
        ArrayList<IProblemSolution> arrayList = new ArrayList<IProblemSolution>();
        int n2 = 0;
        while (n2 < iProblemArray.length) {
            iProblemSolutionArray = iProblemArray[n2];
            IProblemSolution[] iProblemSolutionArray2 = iProblemSolutionArray.getSolutions();
            int n3 = 0;
            while (n3 < iProblemSolutionArray2.length) {
                if (iProblemSolutionArray2[n3].isApplicable(iProblemArray) && !arrayList.contains(iProblemSolutionArray2[n3])) {
                    arrayList.add(iProblemSolutionArray2[n3]);
                }
                ++n3;
            }
            ++n2;
        }
        iProblemSolutionArray = arrayList.toArray(new IProblemSolution[arrayList.size()]);
        int n4 = 0;
        while (n4 < iProblemSolutionArray.length) {
            iProblemSolutionArray[n4] = iProblemSolutionArray[n4].createCompositeSolution(iProblemArray);
            ++n4;
        }
        this.mySolutions = iProblemSolutionArray;
    }

    public IProblemSolution getCurrentSolution() {
        return this.myCurrentSolution;
    }

    public void setCurrentSolution(IProblemSolution iProblemSolution) {
        this.myCurrentSolution = iProblemSolution;
    }

    public IProblemSolution getSolution(String string) {
        Assert.notImplementedFail();
        return null;
    }

    public void applyCurrentSolutionToChildren() {
        if (this.myCurrentSolution == null) {
            return;
        }
        Object object = null;
        if (this.myCurrentSolution instanceof ICompletableProblemSolution) {
            object = ((ICompletableProblemSolution)((Object)this.myCurrentSolution)).getCompletingObject();
        }
        String string = this.myCurrentSolution.getID();
        Iterator iterator = this.myChildrenList.iterator();
        while (iterator.hasNext()) {
            IProblem iProblem = (IProblem)iterator.next();
            IProblemSolution iProblemSolution = iProblem.getSolution(string);
            if (iProblemSolution instanceof ICompletableProblemSolution) {
                ((ICompletableProblemSolution)((Object)iProblemSolution)).setCompletingObject(object);
            }
            iProblem.setCurrentSolution(iProblemSolution);
        }
    }

    public String toString() {
        String string = this.getClass().getName();
        return "{" + this.getLabelText() + "} [" + this.getUniqueID() + "] " + string.substring(string.lastIndexOf(46) + 1);
    }
}

