/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.interaction.solver;

import com.togethersoft.togetherxj.uml.interaction.solver.AbstractProblem;
import com.togethersoft.togetherxj.uml.interaction.solver.AbstractProblemSolution$1;
import com.togethersoft.togetherxj.uml.interaction.solver.AbstractProblemSolution$SimpleCompositeSolution;
import com.togethersoft.togetherxj.uml.interaction.solver.IProblem;
import com.togethersoft.togetherxj.uml.interaction.solver.IProblemSolution;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractProblemSolution
implements IProblemSolution {
    public Runnable getSolveCommand() {
        return new AbstractProblemSolution$1(this);
    }

    protected abstract void solve();

    public boolean isApplicable(IProblem[] iProblemArray) {
        int n2 = 0;
        while (n2 < iProblemArray.length) {
            IProblem iProblem = iProblemArray[n2];
            if (!(iProblem instanceof AbstractProblem)) {
                return false;
            }
            if (((AbstractProblem)iProblem).getSimilarSolution(this) == null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public IProblemSolution createCompositeSolution(IProblem[] iProblemArray) {
        return new AbstractProblemSolution$SimpleCompositeSolution(this, this);
    }

    public boolean isCurrent(IProblem[] iProblemArray) {
        int n2 = 0;
        while (n2 < iProblemArray.length) {
            IProblemSolution iProblemSolution = iProblemArray[n2].getCurrentSolution();
            if (!this.equals(iProblemSolution)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected List createEqualSolutionsList(IProblem[] iProblemArray) {
        ArrayList<IProblemSolution> arrayList = new ArrayList<IProblemSolution>();
        int n2 = 0;
        while (n2 < iProblemArray.length) {
            IProblemSolution iProblemSolution;
            IProblem iProblem = iProblemArray[n2];
            if (iProblem instanceof AbstractProblem && (iProblemSolution = ((AbstractProblem)iProblem).getEqualSolution(this)) != null) {
                arrayList.add(iProblemSolution);
            }
            ++n2;
        }
        return arrayList;
    }

    public int hashCode() {
        return (this.getClass().getName() + this.getLabelText()).hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof AbstractProblemSolution)) {
            return false;
        }
        return this.hashCode() == object.hashCode();
    }

    public String toString() {
        String string = this.getClass().getName();
        return "{" + this.getLabelText() + "} [" + this.getID() + "] " + string.substring(string.lastIndexOf(46) + 1);
    }

    protected String createCompositeLabelText(String string) {
        return "For All: " + string;
    }

    protected String createCompositeDescriptionText(String string) {
        return string;
    }

    public abstract String getDescriptionText();

    public abstract String getLabelText();

    public abstract String getID();
}

