/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.interaction.solver;

import com.togethersoft.togetherxj.uml.interaction.solver.AbstractGroupingAttribute;
import com.togethersoft.togetherxj.uml.interaction.solver.IProblem;
import com.togethersoft.togetherxj.uml.interaction.solver.IProblemComposite;
import com.togethersoft.togetherxj.uml.interaction.solver.IProblemSolution;
import com.togethersoft.togetherxj.uml.interaction.solver.NullProblemSolution;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractProblem
implements IProblem {
    private String myIDUnuquePart;
    private AbstractGroupingAttribute myGroupingAttribute;
    private IProblemComposite myParent;
    private IProblemSolution myCurrentSolution;
    private IProblemSolution[] mySolutions;
    private Object mySource;
    private boolean myImmutable;
    public static final IProblemSolution NULL_SOLUTION = new NullProblemSolution();

    public AbstractProblem(Object object) {
        this.mySource = object;
    }

    public boolean isImmutable() {
        return this.myImmutable;
    }

    public void setImmutable(boolean bl2) {
        this.myImmutable = bl2;
    }

    public Object getSource() {
        return this.mySource;
    }

    protected void setIDUnuquePart(String string) {
        this.myIDUnuquePart = string;
    }

    protected void setGroupingAttribute(AbstractGroupingAttribute abstractGroupingAttribute) {
        this.myGroupingAttribute = abstractGroupingAttribute;
    }

    public AbstractGroupingAttribute getGroupingAttribute() {
        return this.myGroupingAttribute;
    }

    public String getUniqueID() {
        return this.myIDUnuquePart + '_' + this.getCategoryID();
    }

    public String getCategoryID() {
        String string = this.getClass().getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    public IProblemComposite getParent() {
        return this.myParent;
    }

    public void setParent(IProblemComposite iProblemComposite) {
        this.myParent = iProblemComposite;
    }

    public IProblemSolution getCurrentSolution() {
        return this.myCurrentSolution;
    }

    public void setCurrentSolution(IProblemSolution iProblemSolution) {
        this.myCurrentSolution = iProblemSolution;
        IProblemComposite iProblemComposite = this.getParent();
        if (iProblemComposite != null) {
            iProblemComposite.childrenChanged();
        }
    }

    public IProblemSolution getDefaultSolution() {
        if (this.hasSolution()) {
            return this.getSolutions()[0];
        }
        return null;
    }

    public IProblemSolution[] getSolutions() {
        if (this.mySolutions == null) {
            this.initSolutions();
        }
        if (this.mySolutions == null) {
            this.mySolutions = new IProblemSolution[0];
        }
        return this.mySolutions;
    }

    protected abstract void initSolutions();

    public boolean hasSolution() {
        return this.getSolutions() != null && this.getSolutions().length > 0;
    }

    public void setSolutions(IProblemSolution[] iProblemSolutionArray) {
        this.mySolutions = iProblemSolutionArray;
    }

    public IProblemSolution getSolution(String string) {
        if (this.hasSolution()) {
            int n2 = 0;
            while (n2 < this.mySolutions.length) {
                IProblemSolution iProblemSolution = this.mySolutions[n2];
                if (this.mySolutions[n2].getID().equals(string)) {
                    return this.mySolutions[n2];
                }
                ++n2;
            }
        }
        return null;
    }

    public abstract boolean exists();

    public IProblemSolution getEqualSolution(IProblemSolution iProblemSolution) {
        if (this.hasSolution()) {
            int n2 = 0;
            while (n2 < this.mySolutions.length) {
                if (this.mySolutions[n2].equals(iProblemSolution)) {
                    return this.mySolutions[n2];
                }
                ++n2;
            }
        }
        return null;
    }

    public IProblemSolution getSimilarSolution(IProblemSolution iProblemSolution) {
        if (this.hasSolution()) {
            int n2 = 0;
            while (n2 < this.mySolutions.length) {
                if (this.mySolutions[n2].getID().equals(iProblemSolution.getID())) {
                    return this.mySolutions[n2];
                }
                ++n2;
            }
        }
        return null;
    }

    public int hashCode() {
        return (this.getClass().getName() + this.getLabelText()).hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof AbstractProblem)) {
            return false;
        }
        return this.hashCode() == object.hashCode();
    }

    public String toString() {
        String string = this.getClass().getName();
        return "{" + this.getLabelText() + "} [" + this.getCategoryID() + "] " + string.substring(string.lastIndexOf(46) + 1) + " [" + this.getUniqueID() + "] ";
    }

    public abstract Image getImage();

    public abstract String getDescriptionText();

    public abstract String getLabelText();
}

