/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.interaction.providers.copypaste;

import com.togethersoft.togetherxj.uml.interaction.providers.LinkPropertyHelper;
import com.togethersoft.togetherxj.uml.interaction.providers.copypaste.CopyExtendersState;
import com.tssap.selena.dom.DesignElement;
import com.tssap.selena.dom.DesignProperty;
import com.tssap.selena.dom.nodeset.NodeSetCache;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.providers.design.copy.IDesignCopyExtender;
import java.util.Map;

public class LinkPropertyCopyExtender
implements IDesignCopyExtender {
    private UniqueName mySourceUin;
    private UniqueName myTargetUin;

    public void createCopyExtension(NodeSetCache nodeSetCache, DesignElement designElement, boolean bl2) {
        if (!CopyExtendersState.isEnabled()) {
            return;
        }
        DesignProperty[] designPropertyArray = designElement.getProperties("link_property");
        if (designPropertyArray.length == 0) {
            return;
        }
        String string = designPropertyArray[0].getValue();
        if (!LinkPropertyHelper.isValidValue(string)) {
            return;
        }
        this.mySourceUin = ModelAccess.createUniqueName((String)LinkPropertyHelper.getSourceUinStr(string));
        this.myTargetUin = ModelAccess.createUniqueName((String)LinkPropertyHelper.getTargetUinStr(string));
    }

    public void applyCopyExtension(Entity entity, Map map) {
        if (!CopyExtendersState.isEnabled()) {
            return;
        }
        if (this.mySourceUin == null || this.myTargetUin == null) {
            return;
        }
        UniqueName uniqueName = this.getSubstituted(this.mySourceUin, map);
        UniqueName uniqueName2 = this.getSubstituted(this.myTargetUin, map);
        if (uniqueName == null && uniqueName2 == null) {
            return;
        }
        if (uniqueName == null) {
            uniqueName = this.mySourceUin;
        }
        if (uniqueName2 == null) {
            uniqueName2 = this.myTargetUin;
        }
        String string = LinkPropertyHelper.createValue(uniqueName.toString(), uniqueName2.toString());
        entity.setPropertyValue("link_property", string);
    }

    protected final UniqueName getSubstituted(UniqueName uniqueName, Map map) {
        Entity entity = (Entity)map.get(uniqueName);
        return entity == null ? null : entity.getUniqueName();
    }

    protected final UniqueName getOriginalSourceUin() {
        return this.mySourceUin;
    }

    protected final UniqueName getOriginalTargetUin() {
        return this.myTargetUin;
    }
}

