/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.interaction.providers;

import com.togethersoft.togetherxj.uml.interaction.model.ConventionalMessage;
import com.togethersoft.togetherxj.uml.interaction.model.SequenceElement;
import com.togethersoft.togetherxj.uml.interaction.model.SequenceMessage;
import com.togethersoft.togetherxj.uml.interaction.model.SequenceModel;
import com.togethersoft.togetherxj.uml.interaction.model.SequenceModelAccess;
import com.togethersoft.togetherxj.uml.interaction.model.util.SequenceModelUtil;
import com.togethersoft.togetherxj.uml.interaction.util.ElementUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.viewmanagement.IViewManagementFilter;

public class HideByDependencyFilter
implements IViewManagementFilter {
    public boolean isConfiguredToHide(Element element) {
        if (element == null || !(element instanceof Reference)) {
            return false;
        }
        Reference reference = (Reference)element;
        if (!this.isOnSequenceDiagram(reference) || !ElementUtil.isSequenceElement((Element)reference)) {
            return false;
        }
        SequenceModel sequenceModel = null;
        try {
            sequenceModel = SequenceModelAccess.getModel(reference);
        }
        catch (Throwable throwable) {
            return false;
        }
        if (ElementUtil.isActivationNode((PropertyMap)reference)) {
            SequenceElement sequenceElement = SequenceModelUtil.findSequenceElement(sequenceModel, reference);
            if (sequenceElement == null) {
                return true;
            }
            return HideByDependencyFilter.hasHiddenProperty(sequenceElement.getReference()) || HideByDependencyFilter.isSequenceElementHiddenByDependency(sequenceElement);
        }
        SequenceElement sequenceElement = SequenceModelUtil.findSequenceElement(sequenceModel, reference);
        return HideByDependencyFilter.isSequenceElementHiddenByDependency(sequenceElement);
    }

    private boolean isOnSequenceDiagram(Reference reference) {
        ReferenceCollection referenceCollection = ElementUtil.getParentCollection(reference);
        if (referenceCollection != null) {
            return "Sequence Diagram".equals(referenceCollection.getPropertyValue("$metaclass"));
        }
        return false;
    }

    public static boolean hasHiddenProperty(Reference reference) {
        return reference.hasProperty("$hidden");
    }

    public static boolean isSequenceElementHiddenByDependency(SequenceElement sequenceElement) {
        Reference reference;
        Reference reference2;
        SequenceElement sequenceElement2;
        if (sequenceElement == null || sequenceElement.isRootElement()) {
            return false;
        }
        if (sequenceElement instanceof SequenceMessage) {
            sequenceElement2 = (SequenceMessage)sequenceElement;
            reference2 = ((SequenceMessage)sequenceElement2).getSourceReference();
            if (reference2 == null || reference2.hasProperty("$hiddenWithOptions")) {
                return true;
            }
            reference = ((SequenceMessage)sequenceElement2).getTargetReference();
            if (reference == null || reference.hasProperty("$hiddenWithOptions")) {
                return true;
            }
        }
        if (sequenceElement instanceof ConventionalMessage && (sequenceElement2 = ((ConventionalMessage)sequenceElement).getActivationEntity()) != null && (reference = ElementUtil.findReference((ReferenceCollection)(reference2 = ElementUtil.getParentCollection(sequenceElement.getReference())), (Entity)sequenceElement2)) != null && HideByDependencyFilter.hasHiddenProperty(reference)) {
            return true;
        }
        sequenceElement2 = sequenceElement.getPredecessorElement();
        if (sequenceElement2.isRootElement()) {
            return false;
        }
        return HideByDependencyFilter.hasHiddenProperty(sequenceElement2.getReference()) || HideByDependencyFilter.isSequenceElementHiddenByDependency(sequenceElement2);
    }
}

