/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.interaction.model.util;

import java.util.StringTokenizer;

public class SequenceNumber {
    private String myValue;

    public SequenceNumber(String string) {
        this.myValue = string;
    }

    public boolean equals(SequenceNumber sequenceNumber) {
        if (!(sequenceNumber instanceof SequenceNumber)) {
            return false;
        }
        return this.myValue.equals(sequenceNumber.myValue);
    }

    public int hashCode() {
        return this.myValue.hashCode();
    }

    public String toString() {
        return this.myValue;
    }

    public static boolean isValidValue(String string) {
        if (string == null) {
            return false;
        }
        if ((string = string.trim()).length() == 0) {
            return false;
        }
        if (string.endsWith(".")) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            try {
                int n2 = Integer.parseInt(string2);
                if (n2 > 0) continue;
                return false;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return true;
    }

    public boolean isInitialLevel() {
        return this.getStackLevel() == 1;
    }

    public int getStackLevel() {
        if (this.myValue.length() == 0) {
            return 0;
        }
        char[] cArray = this.myValue.toCharArray();
        int n2 = 1;
        int n3 = 0;
        while (n3 < cArray.length) {
            if (cArray[n3] == '.') {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    public SequenceNumber getPredecessorNumber() {
        int n2 = this.getStackLevel();
        if (n2 == 0) {
            return null;
        }
        int n3 = this.myValue.lastIndexOf(46);
        String string = "";
        if (n3 > 0) {
            string = this.myValue.substring(0, n3);
        }
        return new SequenceNumber(string);
    }

    public SequenceNumber getSubsequentNumber() {
        return this.getSubsequentNumber(0);
    }

    public SequenceNumber getSubsequentNumber(int n2) {
        String string = "" + (n2 + 1);
        int n3 = this.getStackLevel();
        if (n3 > 0) {
            string = "." + string;
        }
        return new SequenceNumber(this.myValue + string);
    }

    public SequenceNumber getNextSiblingNumber() {
        int n2 = this.getStackLevel();
        if (n2 == 0) {
            return null;
        }
        int n3 = this.getBranchNumber() + 1;
        SequenceNumber sequenceNumber = this.getPredecessorNumber();
        String string = sequenceNumber.toString();
        string = string.length() == 0 ? "" + n3 : string + "." + n3;
        return new SequenceNumber(string);
    }

    public SequenceNumber getPrevSiblingNumber() {
        int n2 = this.getStackLevel();
        if (n2 == 0) {
            return null;
        }
        int n3 = this.getBranchNumber();
        if (n3 <= 0) {
            return null;
        }
        SequenceNumber sequenceNumber = this.getPredecessorNumber();
        String string = sequenceNumber.toString();
        string = string.length() == 0 ? "" + n3 : string + "." + --n3;
        return new SequenceNumber(string);
    }

    public int getBranchNumber() {
        boolean bl2 = false;
        int n2 = this.getStackLevel();
        if (n2 == 0) {
            return 1;
        }
        int n3 = this.myValue.lastIndexOf(46);
        String string = this.myValue.substring(n3 + 1);
        return Integer.parseInt(string);
    }

    public void setBranchNumber(int n2) {
        int n3 = this.getStackLevel();
        if (n3 == 0) {
            return;
        }
        if (n3 == 1) {
            this.myValue = "" + n2;
            return;
        }
        int n4 = this.myValue.lastIndexOf(46);
        String string = this.myValue.substring(0, n4);
        this.myValue = string + "." + n2;
    }

    public int getInteractionNumber() {
        boolean bl2 = false;
        int n2 = this.getStackLevel();
        if (n2 == 0) {
            throw new RuntimeException("Can't define interaction number of root message.");
        }
        if (n2 == 1) {
            return this.getBranchNumber();
        }
        int n3 = this.myValue.indexOf(46);
        String string = this.myValue.substring(0, n3);
        return Integer.parseInt(string);
    }

    public void replaceInteractionNumber(int n2) {
        int n3 = this.getStackLevel();
        if (n3 == 0) {
            throw new RuntimeException("Can't replace interaction number of root message.");
        }
        if (n3 == 1) {
            this.myValue = "" + n2;
        } else {
            int n4 = this.myValue.indexOf(46);
            String string = this.myValue.substring(n4);
            this.myValue = "" + n2 + string;
        }
    }

    public SequenceNumber replacePredecessor(SequenceNumber sequenceNumber) {
        String string = "" + this.getBranchNumber();
        String string2 = sequenceNumber.toString();
        if (string2.length() > 0) {
            string = "." + string;
        }
        this.myValue = string2 + string;
        return this;
    }

    protected boolean isPredecessor(SequenceNumber sequenceNumber) {
        return sequenceNumber.toString().startsWith(this.myValue);
    }

    public int compare(SequenceNumber sequenceNumber) {
        if (sequenceNumber == null) {
            return 1;
        }
        String string = sequenceNumber.myValue;
        if (this.myValue.equals(string)) {
            return 0;
        }
        if (SequenceNumber.compareNumbers(this.myValue, string)) {
            return -1;
        }
        return 1;
    }

    protected static boolean compareNumbers(String string, String string2) {
        char[] cArray = string.toCharArray();
        char[] cArray2 = string2.toCharArray();
        int n2 = 0;
        int n3 = 0;
        int n4 = Math.max(cArray.length, cArray2.length);
        int n5 = 0;
        while (n5 < n4) {
            if (n5 >= cArray.length && n5 >= cArray2.length) break;
            if (n5 >= cArray.length) {
                if (cArray2[n5] == '.') {
                    if (n2 != n3) break;
                    return true;
                }
                return true;
            }
            if (n5 >= cArray2.length) {
                if (cArray[n5] == '.') {
                    if (n2 != n3) break;
                    return false;
                }
                return false;
            }
            if (cArray[n5] == '.' && cArray2[n5] == '.') {
                if (n2 < n3) {
                    return true;
                }
                if (n2 > n3) {
                    return false;
                }
                n2 = 0;
                n3 = 0;
            } else {
                if (cArray[n5] == '.') {
                    return true;
                }
                if (cArray2[n5] == '.') {
                    return false;
                }
                n2 = n2 * 10 + (cArray[n5] - 48);
                n3 = n3 * 10 + (cArray2[n5] - 48);
            }
            ++n5;
        }
        return n2 < n3;
    }
}

