/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.interaction.model.util;

import com.togethersoft.togetherxj.uml.interaction.model.ConventionalMessage;
import com.togethersoft.togetherxj.uml.interaction.model.ISequenceModelValidator;
import com.togethersoft.togetherxj.uml.interaction.model.ProcessDelay;
import com.togethersoft.togetherxj.uml.interaction.model.SequenceElement;
import com.togethersoft.togetherxj.uml.interaction.model.SequenceMessage;
import com.togethersoft.togetherxj.uml.interaction.model.SequenceModel;
import com.togethersoft.togetherxj.uml.interaction.model.SequenceObject;
import com.togethersoft.togetherxj.uml.interaction.model.TimeInterval;
import com.togethersoft.togetherxj.uml.interaction.model.util.SequenceModelUtil;
import com.togethersoft.togetherxj.uml.interaction.model.util.SequenceModelValidator$1;
import com.togethersoft.togetherxj.uml.interaction.model.util.SequenceModelValidator$_TimeInterval;
import com.togethersoft.togetherxj.uml.interaction.model.util.SequenceNumber;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SequenceModelValidator
implements ISequenceModelValidator {
    private SequenceModel myModel;
    private SequenceModel myVisibleModel;

    public SequenceModelValidator(SequenceModel sequenceModel) {
        this.myModel = sequenceModel;
    }

    public void invalidate() {
        if (this.myVisibleModel != null) {
            this.myVisibleModel.dispose();
            this.myVisibleModel = null;
        }
    }

    public SequenceModel getOriginalModel() {
        return this.myModel;
    }

    public SequenceModel getVisibleModel() {
        if (this.myVisibleModel == null && !this.myModel.isDisposed()) {
            this.myVisibleModel = this.myModel.getFiltered(new SequenceModelValidator$1(this));
        }
        return this.myVisibleModel;
    }

    public void revalidateMessageNumbers() {
        SequenceElement sequenceElement = this.myModel.getRootElement();
        this.renumberSubsequentMessages(sequenceElement);
    }

    protected void renumberSubsequentMessages(SequenceElement sequenceElement) {
        SequenceNumber sequenceNumber = sequenceElement.getSequenceNumber();
        SequenceNumber sequenceNumber2 = sequenceNumber.getSubsequentNumber(0);
        Iterator iterator = this.getSubsequentMessagesList(sequenceElement).iterator();
        while (iterator.hasNext()) {
            SequenceMessage sequenceMessage = (SequenceMessage)iterator.next();
            sequenceMessage.setSequenceNumber(sequenceNumber2);
            sequenceNumber2 = sequenceNumber2.getNextSiblingNumber();
            this.renumberSubsequentMessages(sequenceMessage);
        }
    }

    protected List getSubsequentMessagesList(SequenceElement sequenceElement) {
        if (sequenceElement.getChildCount() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<SequenceElement> arrayList = new ArrayList<SequenceElement>();
        int n2 = sequenceElement.getChildCount();
        int n3 = 0;
        while (n3 < n2) {
            SequenceElement sequenceElement2 = sequenceElement.getSubsequentElementAt(n3);
            if (sequenceElement2 instanceof SequenceMessage) {
                arrayList.add(sequenceElement2);
            } else {
                arrayList.addAll(this.getSubsequentMessagesList(sequenceElement2));
            }
            ++n3;
        }
        return arrayList;
    }

    public void revalidateSubsequentNormalizedIndices(SequenceElement sequenceElement) {
        int n2 = sequenceElement.getChildCount();
        float[] fArray = new float[n2];
        float f2 = -1.0f;
        int n3 = 0;
        while (n3 < n2) {
            SequenceElement sequenceElement2 = sequenceElement.getSubsequentElementAt(n3);
            fArray[n3] = -1.0f;
            float f3 = sequenceElement2.getNormalizedIndex();
            if (f3 >= 0.0f && f3 <= 1.0f && f3 > f2) {
                fArray[n3] = f3;
                f2 = f3;
            }
            ++n3;
        }
        float f4 = 0.0f;
        int n4 = 0;
        while (n4 < fArray.length) {
            float f5 = fArray[n4];
            if (f5 < 0.0f) {
                float f6 = 1.0f;
                if (n4 < fArray.length - 1) {
                    int n5 = n4 + 1;
                    while (n5 < fArray.length) {
                        if (fArray[n5] >= 0.0f) {
                            f6 = fArray[n5];
                            break;
                        }
                        ++n5;
                    }
                }
                float f7 = f6 - f4;
                f5 = (float)((double)f4 + (double)f7 / 2.0);
            }
            fArray[n4] = f5;
            f4 = f5;
            ++n4;
        }
        int n6 = 0;
        while (n6 < n2) {
            SequenceElement sequenceElement3 = sequenceElement.getSubsequentElementAt(n6);
            sequenceElement3.setNormalizedIndex(fArray[n6]);
            ++n6;
        }
    }

    public void validateObjectsPersistance(SequenceMessage sequenceMessage) {
        SequenceObject sequenceObject = new SequenceObject(sequenceMessage.getSourceReference());
        this.validateObjectPersistance(sequenceObject);
        if (!sequenceMessage.isToSelf()) {
            SequenceObject sequenceObject2 = new SequenceObject(sequenceMessage.getTargetReference());
            this.validateObjectPersistance(sequenceObject2);
        }
    }

    public void validateObjectPersistance(SequenceObject sequenceObject) {
        Object object;
        Object object2;
        if (this.getOriginalModel().isDisposed()) {
            return;
        }
        Object object3 = null;
        Object object4 = null;
        Object object5 = null;
        Object object6 = null;
        Iterator iterator = this.getVisibleModel().incomingMessages(sequenceObject.getReference());
        while (iterator.hasNext()) {
            object2 = (SequenceMessage)iterator.next();
            object = ((SequenceMessage)object2).getProcessingInterval();
            if (((SequenceMessage)object2).isCreation()) {
                if (object4 == null) {
                    object4 = object2;
                } else if (((SequenceMessage)object4).getProcessingInterval().compareInitialInstant((TimeInterval)object) < 0) {
                    ((SequenceMessage)object2).setCreation(false);
                } else if (!object4.equals(object2)) {
                    ((SequenceMessage)object4).setCreation(false);
                    object4 = object2;
                }
            }
            if (((SequenceMessage)object2).isDestruction()) {
                if (object6 == null) {
                    object6 = object2;
                } else if (((SequenceMessage)object6).getProcessingInterval().compareCompletionInstant((TimeInterval)object) > 0) {
                    ((SequenceMessage)object2).setDestruction(false);
                } else if (!object6.equals(object2)) {
                    ((SequenceMessage)object6).setDestruction(false);
                    object6 = object2;
                }
            }
            if (object3 == null || ((SequenceMessage)object3).getProcessingInterval().compareInitialInstant((TimeInterval)object) > 0) {
                object3 = object2;
            }
            if (object5 != null && ((SequenceMessage)object5).getProcessingInterval().compareCompletionInstant((TimeInterval)object) >= 0) continue;
            object5 = object2;
        }
        if (object4 != null && !object4.equals(object3)) {
            ((SequenceMessage)object4).setCreation(false);
            object4 = null;
        }
        if (object4 == null && object3 != null && (object2 = ((SequenceMessage)object3).getCodeOperation()) != null && object2.hasProperty("$constructor")) {
            ((SequenceMessage)object3).setCreation(true);
            object4 = object3;
        }
        if (object6 != null && !object6.equals(object5)) {
            ((SequenceMessage)object6).setDestruction(false);
            object6 = null;
        }
        if (object6 == null && object5 != null && (object2 = ((SequenceMessage)object5).getCodeOperation()) != null) {
            ((SequenceMessage)object5).setDestruction(true);
            object6 = object5;
        }
        if (object4 != null || object6 != null) {
            object2 = this.getOriginalModel().outgoingMessages(sequenceObject.getReference());
            while (object2.hasNext()) {
                TimeInterval timeInterval;
                object = (SequenceMessage)object2.next();
                TimeInterval timeInterval2 = ((SequenceMessage)object).getControlGainInterval();
                if (object4 != null && (timeInterval = ((SequenceMessage)object4).getProcessingInterval()).compareInitialInstant(timeInterval2) > 0) {
                    ((SequenceMessage)object4).setCreation(false);
                    object4 = null;
                }
                if (object6 == null || (timeInterval = ((SequenceMessage)object6).getProcessingInterval()).compareCompletionInstant(timeInterval2) >= 0) continue;
                ((SequenceMessage)object6).setDestruction(false);
                object6 = null;
            }
        }
    }

    public void recountProcessingDuration() {
        int n2;
        if (this.getOriginalModel().isDisposed()) {
            return;
        }
        int n3 = 0;
        SequenceModel sequenceModel = this.getVisibleModel();
        SequenceMessage[] sequenceMessageArray = sequenceModel.getInitialMessages();
        int n4 = 0;
        while (n4 < sequenceMessageArray.length) {
            n2 = sequenceMessageArray[n4].getSendingInstant();
            int n5 = 115 - n2;
            n3 = Math.max(n3, n5);
            ++n4;
        }
        if (n3 > 0) {
            sequenceModel.getRootElement().shiftSubsequentElements(n3, 0);
        }
        n2 = 0;
        while (n2 < sequenceMessageArray.length) {
            this.recountProcessingDuration(sequenceMessageArray[n2]);
            ++n2;
        }
        this.recountInitialMessages();
    }

    private void recountProcessingDuration(SequenceElement sequenceElement) {
        int n2;
        int n3;
        int n4;
        int n5;
        TimeInterval timeInterval;
        int n6 = sequenceElement.getChildCount();
        int n7 = -1;
        Object object = null;
        int n8 = 0;
        while (n8 < n6) {
            timeInterval = object;
            object = sequenceElement.getSubsequentElementAt(n8);
            TimeInterval timeInterval2 = ((SequenceElement)object).getControlGainInterval();
            n5 = timeInterval2.getCompletionInstant();
            if (n8 == 0) {
                n4 = timeInterval2.getInitialInstant();
                if (n4 < (n3 = (n2 = sequenceElement.getProcessingInterval().getInitialInstant()) + 5)) {
                    ((SequenceElement)object).shiftElement(n3 - n4);
                }
            } else {
                ((SequenceElement)object).validateInitialInstant((SequenceElement)((Object)timeInterval));
            }
            this.recountProcessingDuration((SequenceElement)object);
            n4 = timeInterval2.getCompletionInstant();
            if (n4 != n5) {
                sequenceElement.shiftSubsequentElements(n4 - n5, n8 + 1);
            }
            n7 = Math.max(n7, n4);
            ++n8;
        }
        timeInterval = sequenceElement.getProcessingInterval();
        int n9 = timeInterval.getCompletionInstant();
        n5 = n7 + 10;
        n4 = n5 - timeInterval.getInitialInstant();
        n2 = Math.max(n4, timeInterval.getMinimalDuration());
        if (n2 != (n3 = timeInterval.getDuration())) {
            timeInterval.setDuration(n2);
        }
    }

    private void recountInitialMessages() {
        Cloneable cloneable;
        if (this.getOriginalModel().isDisposed()) {
            return;
        }
        SequenceModel sequenceModel = this.getVisibleModel();
        SequenceMessage[] sequenceMessageArray = sequenceModel.getInitialMessages();
        int n2 = sequenceMessageArray.length;
        int n3 = n2 - 1;
        while (n3 >= 1) {
            cloneable = sequenceMessageArray[n3];
            if (!((SequenceMessage)cloneable).getControlGainInterval().hasReliableInitialInstant()) {
                System.err.println("SequenceModelValidator couldn't recount initial messages: \"" + ((SequenceElement)cloneable).getName() + "\" has unreliable sending instant.");
                return;
            }
            --n3;
        }
        cloneable = new HashSet();
        while (this.doRecountInitialMessages(sequenceMessageArray, (Set)((Object)cloneable))) {
        }
        ((HashSet)cloneable).clear();
    }

    private boolean doRecountInitialMessages(SequenceMessage[] sequenceMessageArray, Set set) {
        int n2 = sequenceMessageArray.length;
        int n3 = n2 - 1;
        while (n3 >= 1) {
            SequenceMessage sequenceMessage = sequenceMessageArray[n3];
            if (sequenceMessage.isNestedControlFlow()) {
                int n4 = n3 - 1;
                while (n4 >= 0) {
                    String string;
                    SequenceMessage sequenceMessage2 = sequenceMessageArray[n4];
                    if (sequenceMessage2.isNestedControlFlow() && !SequenceModelUtil.isBranchedMessages(sequenceMessage, sequenceMessage2) && !set.contains(string = "" + n3 + "<->" + n4)) {
                        set.add(string);
                        int n5 = this.calcOverlap(sequenceMessage2, sequenceMessage);
                        if (n5 >= 0) {
                            sequenceMessage.getPredecessorElement().shiftSubsequentElements(n5 + 5, n3);
                            return true;
                        }
                    }
                    --n4;
                }
            }
            --n3;
        }
        return false;
    }

    private int calcOverlap(SequenceMessage sequenceMessage, SequenceMessage sequenceMessage2) {
        HashMap hashMap = new HashMap();
        this.collectObjects(sequenceMessage, hashMap);
        HashMap hashMap2 = new HashMap();
        this.collectObjects(sequenceMessage2, hashMap2);
        int n2 = -1;
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            SequenceModelValidator$_TimeInterval sequenceModelValidator$_TimeInterval;
            Object k2 = iterator.next();
            SequenceModelValidator$_TimeInterval sequenceModelValidator$_TimeInterval2 = (SequenceModelValidator$_TimeInterval)hashMap2.get(k2);
            if (sequenceModelValidator$_TimeInterval2 == null || (sequenceModelValidator$_TimeInterval = (SequenceModelValidator$_TimeInterval)hashMap.get(k2)).compare(sequenceModelValidator$_TimeInterval2) != 0) continue;
            n2 = Math.max(n2, sequenceModelValidator$_TimeInterval.getOverlap(sequenceModelValidator$_TimeInterval2));
        }
        hashMap.clear();
        hashMap2.clear();
        return n2;
    }

    private void collectObjects(SequenceElement sequenceElement, HashMap hashMap) {
        if (sequenceElement instanceof ConventionalMessage && !(sequenceElement instanceof ProcessDelay)) {
            SequenceMessage sequenceMessage = (SequenceMessage)sequenceElement;
            this.addToTable(sequenceMessage.getSourceReference(), new SequenceModelValidator$_TimeInterval(this, sequenceMessage.getControlGainInterval()), hashMap);
            this.addToTable(sequenceMessage.getTargetReference(), new SequenceModelValidator$_TimeInterval(this, sequenceMessage.getProcessingInterval()), hashMap);
        }
        int n2 = 0;
        while (n2 < sequenceElement.getChildCount()) {
            this.collectObjects(sequenceElement.getSubsequentElementAt(n2), hashMap);
            ++n2;
        }
    }

    private void addToTable(Object object, SequenceModelValidator$_TimeInterval sequenceModelValidator$_TimeInterval, HashMap hashMap) {
        SequenceModelValidator$_TimeInterval sequenceModelValidator$_TimeInterval2 = (SequenceModelValidator$_TimeInterval)hashMap.get(object);
        if (sequenceModelValidator$_TimeInterval2 == null) {
            hashMap.put(object, sequenceModelValidator$_TimeInterval);
        } else {
            sequenceModelValidator$_TimeInterval2.add(sequenceModelValidator$_TimeInterval);
        }
    }

    public void validateSendingInstants() {
        if (this.getOriginalModel().isDisposed()) {
            return;
        }
        SequenceModel sequenceModel = this.getVisibleModel();
        SequenceElement sequenceElement = sequenceModel.getRootElement();
        this.validateSubsequentSendingInstantProperty(sequenceElement);
        this.synchronizeSubsequentSendingInstant2NormalizedIndex(sequenceElement);
    }

    private void validateSubsequentSendingInstantProperty(SequenceElement sequenceElement) {
        int n2 = sequenceElement.getChildCount();
        int n3 = 0;
        while (n3 < n2) {
            SequenceElement sequenceElement2 = sequenceElement.getSubsequentElementAt(n3);
            TimeInterval timeInterval = sequenceElement2.getControlGainInterval();
            if (!timeInterval.hasReliableInitialInstant()) {
                int n4 = SequenceModelUtil.childIndex2timeInstant(sequenceElement, n3, sequenceElement2);
                timeInterval.setInitialInstant(n4);
            }
            this.validateSubsequentSendingInstantProperty(sequenceElement2);
            ++n3;
        }
    }

    private void synchronizeSubsequentSendingInstant2NormalizedIndex(SequenceElement sequenceElement) {
        int n2 = sequenceElement.getChildCount();
        int n3 = 0;
        while (n3 < n2) {
            SequenceElement sequenceElement2 = sequenceElement.getSubsequentElementAt(n3);
            TimeInterval timeInterval = sequenceElement2.getControlGainInterval();
            int n4 = timeInterval.getInitialInstant();
            int n5 = SequenceModelUtil.timeInstant2childIndex(sequenceElement, n4, sequenceElement2);
            if (n5 != n3) {
                int n6 = SequenceModelUtil.childIndex2timeInstant(sequenceElement, n3, sequenceElement2);
                timeInterval.setInitialInstant(n6);
            }
            this.synchronizeSubsequentSendingInstant2NormalizedIndex(sequenceElement2);
            ++n3;
        }
    }
}

