/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.interaction.model.util;

import com.togethersoft.togetherxj.uml.interaction.model.SequenceElement;
import com.togethersoft.togetherxj.uml.interaction.model.SequenceMessage;
import com.togethersoft.togetherxj.uml.interaction.model.SequenceModel;
import com.togethersoft.togetherxj.uml.interaction.model.SequenceObject;
import com.togethersoft.togetherxj.uml.interaction.model.TimeInterval;
import com.togethersoft.togetherxj.uml.interaction.model.util.SequenceElementEntityUtil;
import com.togethersoft.togetherxj.uml.interaction.model.util.SequenceModelUtil$1;
import com.togethersoft.togetherxj.uml.interaction.sd.a.b.b;
import com.togethersoft.togetherxj.uml.interaction.sd.a.b.i;
import com.togethersoft.togetherxj.uml.interaction.util.Assert;
import com.togethersoft.togetherxj.uml.interaction.util.ElementUtil;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.elements.Reference;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class SequenceModelUtil {
    public static SequenceElement findSequenceElement(SequenceModel sequenceModel, Reference reference) {
        Assert.assertNotNull("Parameter shouldn't be NULL", sequenceModel);
        Assert.assertNotNull("Parameter shouldn't be NULL", reference);
        return SequenceModelUtil.findSequenceElement(sequenceModel, reference.getEntity());
    }

    public static SequenceElement findSequenceElement(SequenceModel sequenceModel, Entity entity) {
        Assert.assertNotNull("Parameter shouldn't be NULL", sequenceModel);
        Assert.assertNotNull("Parameter shouldn't be NULL", entity);
        if (ElementUtil.isObjectNode((PropertyMap)entity)) {
            return null;
        }
        if (ElementUtil.isActivationNode((PropertyMap)entity)) {
            String string = entity.getPropertyValue("messageUid");
            if (string == null) {
                return null;
            }
            return sequenceModel.findElement(string);
        }
        if (ElementUtil.isMessageLink((PropertyMap)entity)) {
            return sequenceModel.findElement(entity.getUniqueName());
        }
        if (ElementUtil.isStatementBlock((PropertyMap)entity)) {
            return sequenceModel.findElement(entity.getUniqueName());
        }
        Assert.fail("Couldn't find sequence element for unknown element : " + entity.getPropertyValue("$metaclass"));
        return null;
    }

    public static boolean isCreatedObject(SequenceModel sequenceModel, SequenceObject sequenceObject) {
        Iterator iterator = sequenceModel.incomingMessages(sequenceObject.getReference());
        while (iterator.hasNext()) {
            SequenceMessage sequenceMessage = (SequenceMessage)iterator.next();
            if (!sequenceMessage.isCreation()) continue;
            return true;
        }
        return false;
    }

    public static boolean isDestroyedObject(SequenceModel sequenceModel, SequenceObject sequenceObject) {
        Iterator iterator = sequenceModel.incomingMessages(sequenceObject.getReference());
        while (iterator.hasNext()) {
            SequenceMessage sequenceMessage = (SequenceMessage)iterator.next();
            if (!sequenceMessage.isDestruction()) continue;
            return true;
        }
        return false;
    }

    public static int countPredecessors(SequenceElement sequenceElement) {
        int n2 = 0;
        SequenceElement sequenceElement2 = sequenceElement.getPredecessorElement();
        while (sequenceElement2 != null) {
            ++n2;
            sequenceElement2 = sequenceElement2.getPredecessorElement();
        }
        return n2;
    }

    public static boolean isPredecessor(SequenceElement sequenceElement, SequenceElement sequenceElement2) {
        while (sequenceElement2.getPredecessorElement() != null) {
            if (sequenceElement != (sequenceElement2 = sequenceElement2.getPredecessorElement())) continue;
            return true;
        }
        return false;
    }

    public static void synchronizePredecessor(SequenceElement sequenceElement) {
        b b2 = i.a(sequenceElement);
        b2.o();
    }

    public static void shiftSibling(SequenceElement sequenceElement, int n2) {
        if (n2 == 0) {
            return;
        }
        SequenceElement sequenceElement2 = (SequenceElement)sequenceElement.getNextSibling();
        while (sequenceElement2 != null) {
            sequenceElement2.shiftElement(n2);
            sequenceElement2 = (SequenceElement)sequenceElement2.getNextSibling();
        }
    }

    public static boolean isBranchedMessages(SequenceElement sequenceElement, SequenceElement sequenceElement2) {
        if (sequenceElement instanceof SequenceMessage && sequenceElement2 instanceof SequenceMessage) {
            SequenceMessage sequenceMessage = (SequenceMessage)sequenceElement;
            SequenceMessage sequenceMessage2 = (SequenceMessage)sequenceElement2;
            return sequenceMessage == sequenceMessage2.getBranchingAnchor() || sequenceMessage2 == sequenceMessage.getBranchingAnchor();
        }
        return false;
    }

    public static List getBranchedMessages(SequenceElement sequenceElement, SequenceMessage sequenceMessage) {
        ArrayList<SequenceElement> arrayList = new ArrayList<SequenceElement>();
        if (sequenceMessage.getBranchingAnchor() != null) {
            return arrayList;
        }
        int n2 = sequenceElement.getChildCount();
        int n3 = 0;
        while (n3 < n2) {
            SequenceElement sequenceElement2 = sequenceElement.getSubsequentElementAt(n3);
            if (SequenceModelUtil.isBranchedMessages(sequenceMessage, sequenceElement2)) {
                arrayList.add(sequenceElement2);
            }
            ++n3;
        }
        return arrayList;
    }

    public static void renormalizeAllIndices(SequenceElement sequenceElement) {
        float f2;
        Cloneable cloneable;
        Collection<Object> collection = null;
        if (sequenceElement instanceof SequenceMessage) {
            cloneable = (SequenceMessage)sequenceElement;
            Entity entity = ((SequenceMessage)cloneable).getTargetEntity();
            if (entity == null) {
                return;
            }
            collection = SequenceElementEntityUtil.getSubsequentEntities(entity, ((SequenceElement)cloneable).getUID());
        } else {
            collection = new ArrayList<Entity>();
            int n2 = 0;
            while (n2 < sequenceElement.getChildCount()) {
                collection.add(sequenceElement.getSubsequentElementAt(n2).getEntity());
                ++n2;
            }
        }
        cloneable = new TreeSet(new SequenceModelUtil$1());
        ((TreeSet)cloneable).addAll(collection);
        float f3 = f2 = 1.0f / (float)(((TreeSet)cloneable).size() + 1);
        Iterator iterator = ((TreeSet)cloneable).iterator();
        while (iterator.hasNext()) {
            Entity entity = (Entity)iterator.next();
            entity.setPropertyValue("normalizedIndex", String.valueOf(f3));
            f3 += f2;
        }
    }

    public static int timeInstant2childIndex(SequenceElement sequenceElement, int n2, SequenceElement sequenceElement2) {
        int n3 = sequenceElement.getChildCount();
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            SequenceElement sequenceElement3 = sequenceElement.getSubsequentElementAt(n5);
            if (sequenceElement3 != sequenceElement2) {
                if (sequenceElement3.getControlGainInterval().compareInitialInstant(n2) > 0) break;
                ++n4;
            }
            ++n5;
        }
        return n4;
    }

    public static int normalizedIndex2childIndex(SequenceElement sequenceElement, float f2) {
        int n2 = sequenceElement.getChildCount();
        int n3 = 0;
        while (n3 < n2) {
            SequenceElement sequenceElement2 = sequenceElement.getSubsequentElementAt(n3);
            if (sequenceElement2.getNormalizedIndex() >= f2) {
                return n3;
            }
            ++n3;
        }
        return n2;
    }

    public static float timeInstant2childNormalizedIndex(SequenceElement sequenceElement, int n2) {
        SequenceElement sequenceElement2 = null;
        SequenceElement sequenceElement3 = null;
        int n3 = sequenceElement.getChildCount();
        int n4 = 0;
        while (n4 < n3) {
            SequenceElement sequenceElement4 = sequenceElement.getSubsequentElementAt(n4);
            if (sequenceElement4.getControlGainInterval().getInitialInstant() > n2) {
                sequenceElement3 = sequenceElement4;
                break;
            }
            sequenceElement2 = sequenceElement4;
            ++n4;
        }
        float f2 = 0.0f;
        if (sequenceElement2 != null) {
            f2 = sequenceElement2.getNormalizedIndex();
        }
        float f3 = 1.0f;
        if (sequenceElement3 != null) {
            f3 = sequenceElement3.getNormalizedIndex();
        }
        float f4 = f3 - f2;
        return (float)((double)f2 + (double)(f4 / 2.0f));
    }

    public static int childIndex2timeInstant(SequenceElement sequenceElement, int n2, SequenceElement sequenceElement2) {
        int n3;
        TimeInterval timeInterval;
        ArrayList arrayList = new ArrayList();
        Iterator iterator = sequenceElement.subsequentElements();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (e2 == sequenceElement2) continue;
            arrayList.add(e2);
        }
        int n4 = arrayList.size();
        SequenceElement sequenceElement3 = null;
        if (n2 > 0 && n4 > 0) {
            sequenceElement3 = n2 > n4 ? (SequenceElement)arrayList.get(n4 - 1) : (SequenceElement)arrayList.get(n2 - 1);
        }
        SequenceElement sequenceElement4 = null;
        if (n2 < n4) {
            sequenceElement4 = (SequenceElement)arrayList.get(n2);
        }
        int n5 = 0;
        int n6 = 0;
        if (sequenceElement3 == null) {
            n6 = sequenceElement.isRootElement() ? 115 : sequenceElement.getProcessingInterval().getInitialInstant() + 5;
        } else {
            TimeInterval timeInterval2 = sequenceElement3.getProcessingInterval();
            int n7 = timeInterval2.getInitialInstant();
            n5 = n7 + 1;
            n6 = timeInterval2.getCompletionInstant(n7) + 5;
        }
        int n8 = n6;
        if (sequenceElement4 != null && (timeInterval = sequenceElement4.getControlGainInterval()).hasReliableInitialInstant() && n6 >= (n3 = timeInterval.getInitialInstant())) {
            n8 = sequenceElement.isRootElement() ? n3 - 10 : n3 - 1;
            n8 = Math.max(n8, n5);
        }
        arrayList.clear();
        return n8;
    }

    public static void dumpModel(SequenceModel sequenceModel) {
        SequenceModelUtil.dumpModel(sequenceModel, System.out);
    }

    public static void dumpModel(SequenceModel sequenceModel, PrintStream printStream) {
        printStream.println("=== Sequence model dump ===");
        if (sequenceModel != null) {
            SequenceModelUtil.dumpModel(sequenceModel.getRootElement(), 0, printStream);
        } else {
            printStream.println("===model is NULL!!!=======");
        }
        printStream.println("===========================");
    }

    private static void dumpModel(SequenceElement sequenceElement, int n2, PrintStream printStream) {
        char[] cArray = new char[n2 * 2];
        Arrays.fill(cArray, ' ');
        int n3 = sequenceElement.getChildCount();
        printStream.println("[" + n2 + "](" + n3 + ") " + new String(cArray) + sequenceElement);
        ++n2;
        int n4 = 0;
        while (n4 < n3) {
            SequenceElement sequenceElement2 = sequenceElement.getSubsequentElementAt(n4);
            SequenceModelUtil.dumpModel(sequenceElement2, n2, printStream);
            ++n4;
        }
    }
}

