/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.interaction.model.util;

import com.togethersoft.togetherxj.uml.interaction.util.Assert;
import com.togethersoft.togetherxj.uml.interaction.util.ElementUtil;
import com.togethersoft.togetherxj.uml.interaction.util.EntityCache;
import com.tssap.selena.model.elements.Container;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.enum.EntityEnumeration;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class SequenceElementEntityUtil {
    public static Collection getSubsequentEntities(Entity entity, String string) {
        ArrayList<Entity> arrayList = new ArrayList<Entity>();
        EntityEnumeration entityEnumeration = entity.childEntities();
        while (entityEnumeration.hasMoreElements()) {
            Entity entity2 = entityEnumeration.next();
            String string2 = entity2.getPropertyValue("predecessorUid");
            if (string2 == null || !string2.equals(string)) continue;
            arrayList.add(entity2);
        }
        return arrayList;
    }

    public static Entity reconnectMessageStart(Entity entity, Entity entity2) {
        Object object;
        Entity entity3 = ElementUtil.getLinkTarget(entity);
        Entity entity4 = ElementUtil.getLinkSource(entity);
        String string = entity.getUniqueName().toString();
        Collection collection = SequenceElementEntityUtil.getSubsequentEntities(entity3, string);
        Entity entity5 = SequenceElementEntityUtil.findActivationEntity(entity);
        String string2 = entity.getPropertyValue("normalizedIndex");
        Entity entity6 = ElementUtil.replaceLinkSource(entity, entity2);
        Assert.assertEquals("Normalized index lost after link cut/copy/paste", string2, entity6.getPropertyValue("normalizedIndex"));
        String string3 = entity6.getUniqueName().toString();
        if (entity5 != null) {
            object = entity5.getPropertyValue("messageUid");
            entity5.setPropertyValue("messageUid", string3);
        }
        object = collection.iterator();
        while (object.hasNext()) {
            Object e2 = object.next();
            ((Entity)e2).setPropertyValue("predecessorUid", string3);
        }
        SequenceElementEntityUtil.removeInterlifelineConnector(entity4, entity3);
        return entity6;
    }

    public static Entity reconnectMessageEnd(Entity entity, Entity entity2) {
        Entity entity3 = ElementUtil.getLinkTarget(entity);
        Entity entity4 = ElementUtil.getLinkSource(entity);
        Entity entity5 = SequenceElementEntityUtil.findActivationEntity(entity);
        Entity entity6 = ElementUtil.replaceLinkTarget(entity, entity2);
        if (entity5 != null) {
            entity5 = ElementUtil.replaceEntityParent(entity5, (Container)entity2);
            entity5.setPropertyValue("messageUid", entity6.getUniqueName().toString());
            entity6.setPropertyValue("activationUid", entity5.getUniqueName().toString());
        }
        SequenceElementEntityUtil.removeInterlifelineConnector(entity4, entity3);
        return entity6;
    }

    public static void deleteSequenceEntity(Entity entity) {
        if (ElementUtil.isActivationNode((PropertyMap)entity)) {
            SequenceElementEntityUtil.deleteActivation(entity);
        } else if (ElementUtil.isMessageLink((PropertyMap)entity)) {
            SequenceElementEntityUtil.deleteMessage(entity);
        } else if (ElementUtil.isStatementBlock((PropertyMap)entity)) {
            SequenceElementEntityUtil.deleteStatementBlock(entity);
        }
    }

    public static void deleteActivation(Entity entity) {
        if (entity.isDeleted()) {
            return;
        }
        Entity entity2 = SequenceElementEntityUtil.findMessageEntity(entity, true);
        if (entity != null && !entity.isDeleted()) {
            entity.delete();
        }
        if (entity2 != null && !entity2.isDeleted()) {
            entity2.delete();
        }
    }

    public static void deleteMessage(Entity entity) {
        Entity entity2;
        String string = entity.getUniqueName().toString();
        Entity entity3 = ElementUtil.getLinkTarget(entity);
        if (entity3 != null) {
            SequenceElementEntityUtil.deleteSubsequentElements(entity3, string);
        }
        if ((entity2 = SequenceElementEntityUtil.findActivationEntity(entity, true)) != null && !entity2.isDeleted()) {
            entity2.delete();
        }
        if (entity != null && !entity.isDeleted()) {
            entity.delete();
        }
    }

    public static void deleteStatementBlock(Entity entity) {
        String string = entity.getUniqueName().toString();
        Entity entity2 = entity.getParent();
        if (entity2 != null) {
            SequenceElementEntityUtil.deleteSubsequentElements(entity2, string);
        }
        if (!entity.isDeleted()) {
            entity.delete();
        }
    }

    protected static void deleteSubsequentElements(Entity entity, String string) {
        Collection collection = SequenceElementEntityUtil.getSubsequentEntities(entity, string);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Entity entity2 = (Entity)iterator.next();
            if (entity2.isDeleted()) continue;
            entity2.delete();
        }
        collection.clear();
    }

    public static Entity findActivationEntity(Entity entity) {
        return SequenceElementEntityUtil.findActivationEntity(entity, false);
    }

    public static Entity findMessageEntity(Entity entity) {
        return SequenceElementEntityUtil.findMessageEntity(entity, false);
    }

    protected static Entity findActivationEntity(Entity entity, boolean bl2) {
        String string;
        if (ElementUtil.isConventionalMessage((PropertyMap)entity) && (string = entity.getPropertyValue("activationUid")) != null && string.trim().length() > 0) {
            Entity entity2;
            if (bl2 && (entity2 = EntityCache.getCache(entity.getModel()).get(string)) != null) {
                return entity2;
            }
            return (Entity)ElementUtil.findElement(entity.getModel(), string);
        }
        return null;
    }

    protected static Entity findMessageEntity(Entity entity, boolean bl2) {
        String string = entity.getPropertyValue("messageUid");
        if (string != null && string.trim().length() > 0) {
            Entity entity2;
            if (bl2 && (entity2 = EntityCache.getCache(entity.getModel()).get(string)) != null) {
                return entity2;
            }
            return (Entity)ElementUtil.findElement(entity.getModel(), string);
        }
        return null;
    }

    public static float getNormalizedIndex(Entity entity) {
        String string = entity.getPropertyValue("normalizedIndex");
        if (string == null) {
            return 0.5f;
        }
        try {
            return Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Failed to get normalized index from sequence element: [" + entity.getPropertyValue("$metaclass") + "] \"" + entity.getPropertyValue("$name") + "\" " + entity.getUniqueName());
            numberFormatException.printStackTrace();
            return 0.5f;
        }
    }

    public static Entity getDefaultReturnMessage(Entity entity) {
        Entity entity2 = SequenceElementEntityUtil.findActivationEntity(entity);
        if (entity2 == null) {
            return null;
        }
        EntityEnumeration entityEnumeration = entity2.children();
        while (entityEnumeration.hasMoreElements()) {
            float f2;
            Entity entity3 = entityEnumeration.next();
            if (!entity3.hasPropertyValue("$metaclass", "Return Link") || (f2 = SequenceElementEntityUtil.getNormalizedIndex(entity3)) != 1.0f) continue;
            return entity3;
        }
        return null;
    }

    public static Entity createDefaultReturnMessage(Entity entity) {
        Entity entity2 = ElementUtil.getLinkTarget(entity);
        Entity entity3 = SequenceElementEntityUtil.findActivationEntity(entity);
        if (entity2 == null || entity3 == null) {
            return null;
        }
        Entity entity4 = ElementUtil.createLink(entity3, entity2, "Return Link");
        entity4.setPropertyValue("normalizedIndex", "1.0");
        return entity4;
    }

    public static void removeInterlifelineConnector(Entity entity, Entity entity2) {
        Entity entity3;
        Entity entity4;
        Object object;
        ArrayList<Entity> arrayList = new ArrayList<Entity>();
        if (entity.getUniqueName().equals(entity2.getUniqueName())) {
            object = entity.children();
            while (object.hasMoreElements()) {
                entity4 = object.next();
                if (ElementUtil.isMessageLink((PropertyMap)entity4)) {
                    entity3 = ElementUtil.getLinkTarget(entity4);
                    if (entity3 == null || !entity3.equals(entity2)) continue;
                    return;
                }
                if (!ElementUtil.isInterlifelineConnector((PropertyMap)entity4) || (entity3 = ElementUtil.getLinkTarget(entity4)) != null && !entity3.equals(entity2)) continue;
                arrayList.add(entity4);
            }
        } else {
            object = entity.children();
            while (object.hasMoreElements()) {
                entity4 = object.next();
                if (ElementUtil.isMessageLink((PropertyMap)entity4)) {
                    entity3 = ElementUtil.getLinkTarget(entity4);
                    if (entity3 == null || !entity3.equals(entity2)) continue;
                    return;
                }
                if (!ElementUtil.isInterlifelineConnector((PropertyMap)entity4) || (entity3 = ElementUtil.getLinkTarget(entity4)) != null && !entity3.equals(entity2)) continue;
                arrayList.add(entity4);
            }
            object = entity2.children();
            while (object.hasMoreElements()) {
                entity4 = object.next();
                if (ElementUtil.isMessageLink((PropertyMap)entity4)) {
                    entity3 = ElementUtil.getLinkSource(entity4);
                    if (entity3 == null || !entity3.equals(entity)) continue;
                    return;
                }
                if (!ElementUtil.isInterlifelineConnector((PropertyMap)entity4) || (entity3 = ElementUtil.getLinkSource(entity4)) != null && !entity3.equals(entity)) continue;
                arrayList.add(entity4);
            }
        }
        object = ((AbstractList)arrayList).iterator();
        while (object.hasNext()) {
            entity4 = (Entity)object.next();
            ElementUtil.deleteDefault((Element)entity4);
        }
    }
}

