/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.interaction.model;

import com.togethersoft.togetherxj.uml.interaction.model.ConventionalMessage;
import com.togethersoft.togetherxj.uml.interaction.model.ISequenceModelValidator;
import com.togethersoft.togetherxj.uml.interaction.model.InteactionRefConnector;
import com.togethersoft.togetherxj.uml.interaction.model.RootElement;
import com.togethersoft.togetherxj.uml.interaction.model.SequenceElement;
import com.togethersoft.togetherxj.uml.interaction.model.SequenceElementsTree;
import com.togethersoft.togetherxj.uml.interaction.model.SequenceMessage;
import com.togethersoft.togetherxj.uml.interaction.model.SequenceModel;
import com.togethersoft.togetherxj.uml.interaction.model.SequenceObject;
import com.togethersoft.togetherxj.uml.interaction.model.StatementBlock;
import com.togethersoft.togetherxj.uml.interaction.model.util.SequenceModelUtil;
import com.togethersoft.togetherxj.uml.interaction.model.util.SequenceModelValidator;
import com.togethersoft.togetherxj.uml.interaction.model.util.SequenceNumber;
import com.togethersoft.togetherxj.uml.interaction.util.Assert;
import com.togethersoft.togetherxj.uml.interaction.util.ElementUtil;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.ReferenceContainer;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.ReferenceEnumeration;
import com.tssap.selena.model.util.function.UnaryCondition;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class SequenceModelImpl
implements SequenceModel {
    private SequenceElementsTree mySequenceElementsTree;
    private ReferenceCollection myDiagram;
    private List myObjectRefs;
    private ISequenceModelValidator myValidator;

    public SequenceModelImpl(ReferenceCollection referenceCollection) {
        this.myDiagram = referenceCollection;
        this.init(referenceCollection);
    }

    private SequenceModelImpl() {
    }

    protected ReferenceCollection getReferenceCollection() {
        return this.myDiagram;
    }

    public ISequenceModelValidator getValidator() {
        if (this.myValidator == null) {
            this.myValidator = new SequenceModelValidator(this);
        }
        return this.myValidator;
    }

    public void setValidator(ISequenceModelValidator iSequenceModelValidator) {
        this.myValidator = iSequenceModelValidator;
    }

    public SequenceModel getFiltered(UnaryCondition unaryCondition) {
        System.out.println("START INIT Filtered Sequence Model for diagram " + this.myDiagram.getPropertyValue("$name"));
        SequenceModelImpl sequenceModelImpl = new SequenceModelImpl();
        sequenceModelImpl.myDiagram = this.myDiagram;
        sequenceModelImpl.myObjectRefs = new ArrayList(this.myObjectRefs);
        sequenceModelImpl.mySequenceElementsTree = new SequenceElementsTree(new RootElement(sequenceModelImpl));
        this.createFilteredTree(this.mySequenceElementsTree.getRootElement(), sequenceModelImpl.mySequenceElementsTree.getRootElement(), unaryCondition);
        System.out.println("FINISH INIT Filtered Sequence Model for diagram " + this.myDiagram.getPropertyValue("$name"));
        return sequenceModelImpl;
    }

    private void createFilteredTree(SequenceElement sequenceElement, SequenceElement sequenceElement2, UnaryCondition unaryCondition) {
        int n2 = 0;
        int n3 = sequenceElement.getChildCount();
        int n4 = 0;
        while (n4 < n3) {
            SequenceElement sequenceElement3 = sequenceElement.getSubsequentElementAt(n4);
            if (unaryCondition.execute((Object)sequenceElement3)) {
                SequenceElement sequenceElement4 = sequenceElement3.getExportableCopy(sequenceElement2.getSequenceModel());
                sequenceElement2.addSubsequentElement(sequenceElement4, n2++);
                this.createFilteredTree(sequenceElement3, sequenceElement4, unaryCondition);
            }
            ++n4;
        }
    }

    public boolean isCreatedFor(ReferenceCollection referenceCollection) {
        return this.myDiagram == referenceCollection;
    }

    public void dispose() {
        if (this.mySequenceElementsTree != null) {
            this.mySequenceElementsTree.dispose();
            this.mySequenceElementsTree = null;
        }
        if (this.myObjectRefs != null) {
            this.myObjectRefs.clear();
            this.myObjectRefs = null;
        }
        this.myDiagram = null;
    }

    public boolean isDisposed() {
        return this.myDiagram == null;
    }

    protected void init(ReferenceCollection referenceCollection) {
        System.out.println("START INIT Sequence Model for diagram " + referenceCollection.getPropertyValue("$name"));
        this.mySequenceElementsTree = new SequenceElementsTree(new RootElement(this));
        this.collectElements(referenceCollection);
        System.out.println("FINISH INIT Sequence Model for diagram " + referenceCollection.getPropertyValue("$name"));
    }

    public SequenceElement getRootElement() {
        return this.mySequenceElementsTree.getRootElement();
    }

    public SequenceMessage[] getInitialMessages() {
        SequenceElement sequenceElement = this.getRootElement();
        int n2 = sequenceElement.getChildCount();
        ArrayList<SequenceMessage> arrayList = new ArrayList<SequenceMessage>(n2);
        int n3 = 0;
        while (n3 < n2) {
            SequenceElement sequenceElement2 = sequenceElement.getSubsequentElementAt(n3);
            if (sequenceElement2 instanceof SequenceMessage) {
                arrayList.add((SequenceMessage)sequenceElement2);
            }
            ++n3;
        }
        return arrayList.toArray(new SequenceMessage[arrayList.size()]);
    }

    public void addObjectReference(Reference reference) {
        this.myObjectRefs.add(reference);
    }

    public Iterator objectReferences() {
        return this.myObjectRefs.iterator();
    }

    protected void collectElements(ReferenceCollection referenceCollection) {
        this.myObjectRefs = this.createObjectRefsList(referenceCollection);
        HashMap hashMap = new HashMap();
        this.addMessagesToMap(this.myObjectRefs, hashMap);
        this.addStatementBlocksToMap(this.myObjectRefs, hashMap);
        this.buildElementsTree(this.getRootElement(), hashMap);
        hashMap.clear();
    }

    private List createObjectRefsList(ReferenceCollection referenceCollection) {
        ArrayList<Reference> arrayList = new ArrayList<Reference>();
        ReferenceEnumeration referenceEnumeration = referenceCollection.references();
        while (referenceEnumeration.hasMoreElements()) {
            Reference reference = referenceEnumeration.next();
            if (!ElementUtil.isObjectNode((PropertyMap)reference)) continue;
            arrayList.add(reference);
        }
        return arrayList;
    }

    protected void addMessagesToMap(List list, Map map) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Reference reference = (Reference)iterator.next();
            this.addMessagesToMap(reference, map);
        }
    }

    protected void addMessagesToMap(Reference reference, Map map) {
        ReferenceEnumeration referenceEnumeration = reference.references();
        while (referenceEnumeration.hasMoreElements()) {
            Reference reference2 = referenceEnumeration.next();
            Entity entity = reference2.getEntity();
            if (entity == null) continue;
            String string = reference2.getPropertyValue("$metaclass");
            if (ElementUtil.isConventionalMessage((PropertyMap)reference2)) {
                map.put(reference2.getEntity().getUniqueName().toString(), new ConventionalMessage(this, reference2));
                continue;
            }
            if (ElementUtil.isInteractionConnector((PropertyMap)reference2)) {
                map.put(reference2.getEntity().getUniqueName().toString(), new InteactionRefConnector(this, reference2));
                continue;
            }
            if ("ProcessDelayLink".equals(string)) {
                System.out.println(" -- PROCESS DELAY LINK is not supported" + string);
                continue;
            }
            if ("InterProcessMessageLink".equals(string)) {
                System.out.println(" -- INTERPROC MESSAGE LINK is not supported" + string);
                continue;
            }
            if (!"Messages Link".equals(string)) continue;
            this.addMessagesToMap(reference2, map);
        }
    }

    protected void addStatementBlocksToMap(List list, Map map) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Reference reference = (Reference)iterator.next();
            this.addStatementBlocksToMap(reference, map);
        }
    }

    protected void addStatementBlocksToMap(Reference reference, Map map) {
        ReferenceEnumeration referenceEnumeration = reference.references();
        while (referenceEnumeration.hasMoreElements()) {
            String string;
            Reference reference2 = referenceEnumeration.next();
            Entity entity = reference2.getEntity();
            if (entity == null || !ElementUtil.isStatementBlockMetaclass(string = reference2.getPropertyValue("$metaclass"))) continue;
            map.put(reference2.getEntity().getUniqueName().toString(), new StatementBlock(this, reference2));
        }
    }

    protected void buildElementsTree(SequenceElement sequenceElement, Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object v2;
            SequenceElement sequenceElement2 = (SequenceElement)map.get(iterator.next());
            SequenceElement sequenceElement3 = sequenceElement;
            String string = sequenceElement2.getProperty("predecessorUid");
            if (string != null && (v2 = map.get(string)) != null) {
                SequenceElement sequenceElement4 = (SequenceElement)v2;
                if (sequenceElement4 == sequenceElement2) {
                    System.err.println("ERROR : element refers to self: add to root: " + sequenceElement2.getMetaclass() + " name: " + sequenceElement2.getName());
                } else if (sequenceElement2.isNodeAncestor(sequenceElement4)) {
                    System.err.println("ERROR : element ancestor of predecessor: add to root: " + sequenceElement2.getMetaclass() + " name: " + sequenceElement2.getName());
                } else {
                    sequenceElement3 = sequenceElement4;
                }
            }
            int n2 = SequenceModelUtil.normalizedIndex2childIndex(sequenceElement3, sequenceElement2.getNormalizedIndex());
            sequenceElement3.addSubsequentElement(sequenceElement2, n2);
        }
    }

    public void handleMessageCreated(SequenceMessage sequenceMessage) {
        Object object;
        Reference reference = sequenceMessage.getTargetReference();
        if (reference == null) {
            object = "Couldn't find target reference for message: " + sequenceMessage.getProperty("$name") + "\ntarget entity: " + ElementUtil.getLinkTarget(sequenceMessage.getEntity());
            System.err.println((String)object);
            ElementUtil.dumpReferenceContainer((ReferenceContainer)ElementUtil.getParentCollection(sequenceMessage.getReference()), System.err);
            Assert.fail((String)object);
        }
        object = new SequenceObject(reference);
        ISequenceModelValidator iSequenceModelValidator = this.getValidator();
        iSequenceModelValidator.validateObjectPersistance((SequenceObject)object);
    }

    public void handleElementShifted(SequenceElement sequenceElement) {
        SequenceElement sequenceElement2 = sequenceElement.getPredecessorElement();
        int n2 = sequenceElement.getControlGainInterval().getInitialInstant();
        int n3 = SequenceModelUtil.timeInstant2childIndex(sequenceElement2, n2, sequenceElement);
        int n4 = sequenceElement2.getIndex(sequenceElement);
        if (n4 != -1 && n4 != n3) {
            this.removeFromModel(sequenceElement);
            this.addToModel(sequenceElement2, sequenceElement, n3);
            ISequenceModelValidator iSequenceModelValidator = this.getValidator();
            iSequenceModelValidator.revalidateSubsequentNormalizedIndices(sequenceElement2);
            if (sequenceElement instanceof SequenceMessage) {
                iSequenceModelValidator.validateObjectsPersistance((SequenceMessage)sequenceElement);
            }
        }
    }

    public void handleElementPredecessorChange(SequenceElement sequenceElement, SequenceElement sequenceElement2) {
        ISequenceModelValidator iSequenceModelValidator = this.getValidator();
        SequenceElement sequenceElement3 = sequenceElement.getPredecessorElement();
        if (sequenceElement3 != sequenceElement2) {
            int n2 = sequenceElement.getControlGainInterval().getInitialInstant();
            this.removeFromModel(sequenceElement);
            int n3 = SequenceModelUtil.timeInstant2childIndex(sequenceElement2, n2, null);
            this.addToModel(sequenceElement2, sequenceElement, n3);
            sequenceElement.setProperty("predecessorUid", sequenceElement2.getUID());
            iSequenceModelValidator.revalidateSubsequentNormalizedIndices(sequenceElement2);
        }
    }

    public void handleMessageSourceChange(SequenceMessage sequenceMessage, Reference reference, SequenceElement sequenceElement) {
        this.handleElementPredecessorChange(sequenceMessage, sequenceElement);
        ISequenceModelValidator iSequenceModelValidator = this.getValidator();
        iSequenceModelValidator.validateObjectsPersistance(sequenceMessage);
        if (reference != sequenceMessage.getSourceReference()) {
            iSequenceModelValidator.validateObjectPersistance(new SequenceObject(reference));
        }
    }

    public void handleMessageTargetChange(SequenceMessage sequenceMessage, Reference reference) {
        ISequenceModelValidator iSequenceModelValidator = this.getValidator();
        iSequenceModelValidator.validateObjectsPersistance(sequenceMessage);
        if (reference != sequenceMessage.getTargetReference()) {
            iSequenceModelValidator.validateObjectPersistance(new SequenceObject(reference));
        }
    }

    public void handleStatementBlockCreated(StatementBlock statementBlock) {
    }

    public SequenceElement findElement(UniqueName uniqueName) {
        if (uniqueName == null) {
            return null;
        }
        return this.findElement(uniqueName.toString());
    }

    public SequenceElement findElement(String string) {
        return this.mySequenceElementsTree.findElement(string);
    }

    public SequenceElement findElement(SequenceNumber sequenceNumber) {
        Enumeration enumeration = this.mySequenceElementsTree.elements();
        while (enumeration.hasMoreElements()) {
            SequenceElement sequenceElement = (SequenceElement)enumeration.nextElement();
            if (!sequenceNumber.equals(sequenceElement.getSequenceNumber())) continue;
            return sequenceElement;
        }
        return null;
    }

    public Enumeration elementsBreadthFirst() {
        return this.mySequenceElementsTree.elementsBreadthFirst();
    }

    public Enumeration elements() {
        return this.mySequenceElementsTree.elements();
    }

    public Iterator incomingMessages(Reference reference) {
        ArrayList<SequenceElement> arrayList = new ArrayList<SequenceElement>();
        Enumeration enumeration = this.mySequenceElementsTree.elements();
        while (enumeration.hasMoreElements()) {
            SequenceElement sequenceElement = (SequenceElement)enumeration.nextElement();
            if (!(sequenceElement instanceof SequenceMessage) || !((SequenceMessage)sequenceElement).isTarget(reference)) continue;
            arrayList.add(sequenceElement);
        }
        return ((AbstractList)arrayList).iterator();
    }

    public Iterator outgoingMessages(Reference reference) {
        ArrayList<SequenceElement> arrayList = new ArrayList<SequenceElement>();
        Enumeration enumeration = this.mySequenceElementsTree.elements();
        while (enumeration.hasMoreElements()) {
            SequenceElement sequenceElement = (SequenceElement)enumeration.nextElement();
            if (!(sequenceElement instanceof SequenceMessage) || !((SequenceMessage)sequenceElement).isSource(reference)) continue;
            arrayList.add(sequenceElement);
        }
        return ((AbstractList)arrayList).iterator();
    }

    public void addToModel(SequenceElement sequenceElement, SequenceElement sequenceElement2, int n2) {
        sequenceElement.addSubsequentElement(sequenceElement2, n2);
    }

    public void removeFromModel(SequenceElement sequenceElement) {
        SequenceElement sequenceElement2 = sequenceElement.getPredecessorElement();
        sequenceElement2.removeSubsequentElement(sequenceElement);
    }

    public String toString() {
        return "Sequence model " + (this.isDisposed() ? "DISPOSED" : "for diagram \"" + this.myDiagram.getPropertyValue("$name") + "\"");
    }
}

