/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.interaction.model;

import com.togethersoft.togetherxj.uml.interaction.model.ISequenceModelValidator;
import com.togethersoft.togetherxj.uml.interaction.model.SequenceElement;
import com.togethersoft.togetherxj.uml.interaction.model.SequenceModel;
import com.togethersoft.togetherxj.uml.interaction.model.SequenceModelImpl;
import com.togethersoft.togetherxj.uml.interaction.model.util.SequenceModelUtil;
import com.togethersoft.togetherxj.uml.interaction.util.Assert;
import com.togethersoft.togetherxj.uml.interaction.util.ElementUtil;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;

public class SequenceModelAccess {
    private static SequenceModelImpl myModel;
    private static Object _LOCK_;

    public static void invalidateModel(ReferenceCollection referenceCollection) {
        if (myModel == null || !myModel.isCreatedFor(referenceCollection)) {
            return;
        }
        SequenceModelAccess.disposeModel(myModel);
        myModel = null;
    }

    public static void setupModel(ReferenceCollection referenceCollection) {
        if (myModel != null && myModel.isCreatedFor(referenceCollection)) {
            return;
        }
        SequenceModelAccess.disposeModel(myModel);
        myModel = SequenceModelAccess.createModel(referenceCollection);
    }

    private static void disposeModel(SequenceModelImpl sequenceModelImpl) {
        if (sequenceModelImpl != null) {
            sequenceModelImpl.dispose();
        }
    }

    private static SequenceModelImpl createModel(ReferenceCollection referenceCollection) {
        SequenceModelImpl sequenceModelImpl = new SequenceModelImpl(referenceCollection);
        return sequenceModelImpl;
    }

    public static SequenceModel getModel(Reference reference) {
        ReferenceCollection referenceCollection = ElementUtil.getParentCollection(reference);
        return SequenceModelAccess.getModel(referenceCollection);
    }

    public static SequenceModel getModel(ReferenceCollection referenceCollection) {
        SequenceModelAccess.setupModel(referenceCollection);
        return myModel;
    }

    public static void invalidateAllModels() {
        SequenceModelAccess.disposeModel(myModel);
        myModel = null;
    }

    public static void startChanges() {
    }

    public static void completeChanges() {
        if (myModel != null) {
            ISequenceModelValidator iSequenceModelValidator = myModel.getValidator();
            iSequenceModelValidator.recountProcessingDuration();
        }
    }

    public static void handleElementCreated(SequenceElement sequenceElement) {
        SequenceModelUtil.renormalizeAllIndices(sequenceElement.getPredecessorElement());
    }

    public static void handleElementRelocated(SequenceElement sequenceElement) {
        SequenceModelUtil.renormalizeAllIndices(sequenceElement.getPredecessorElement());
    }

    public static ISequenceModelValidator getModelValidator() {
        if (myModel != null && !myModel.isDisposed()) {
            return myModel.getValidator();
        }
        return null;
    }

    public static synchronized void setLock(Object object) {
        Assert.assertTrue("Can't set lock : access is already locked", _LOCK_ == null || object == null);
        _LOCK_ = object;
    }

    public static boolean isLocked() {
        return _LOCK_ != null;
    }
}

