/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.interaction.model;

import com.togethersoft.togetherxj.uml.interaction.model.ISequenceModelValidator;
import com.togethersoft.togetherxj.uml.interaction.model.SequenceElement;
import com.togethersoft.togetherxj.uml.interaction.model.SequenceModel;
import com.togethersoft.togetherxj.uml.interaction.model.TimeInterval;
import com.togethersoft.togetherxj.uml.interaction.model.util.SequenceModelUtil;
import com.togethersoft.togetherxj.uml.interaction.model.util.SequenceNumber;
import com.togethersoft.togetherxj.uml.interaction.util.ElementUtil;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Reference;

public abstract class SequenceMessage
extends SequenceElement {
    private SequenceMessage myBranchingAnchor;
    private SequenceNumber mySequenceNumber;

    public SequenceMessage(SequenceModel sequenceModel, Reference reference) {
        super(sequenceModel, reference);
    }

    public void invalidate() {
        this.myBranchingAnchor = null;
        this.mySequenceNumber = null;
    }

    public void dispose() {
        this.myBranchingAnchor = null;
        this.mySequenceNumber = null;
        super.dispose();
    }

    public SequenceNumber getSequenceNumber() {
        if (this.mySequenceNumber == null) {
            ISequenceModelValidator iSequenceModelValidator = this.getSequenceModel().getValidator();
            iSequenceModelValidator.revalidateMessageNumbers();
        }
        return this.mySequenceNumber;
    }

    public void setSequenceNumber(SequenceNumber sequenceNumber) {
        this.mySequenceNumber = sequenceNumber;
    }

    public boolean isCreation() {
        return this.hasProperty("creation");
    }

    public void setCreation(boolean bl2) {
        this.setProperty("creation", bl2);
    }

    public boolean isDestruction() {
        return this.hasProperty("destruction");
    }

    public void setDestruction(boolean bl2) {
        this.setProperty("destruction", bl2);
    }

    public abstract boolean isNestedControlFlow();

    public boolean isToSelf() {
        return this.getSourceReference() == this.getTargetReference();
    }

    public Entity getCodeOperation() {
        return null;
    }

    public Reference getSourceReference() {
        Reference reference = this.getReference();
        return ElementUtil.getLinkSource(reference);
    }

    public Reference getTargetReference() {
        Reference reference = this.getReference();
        return ElementUtil.getLinkTarget(reference);
    }

    public Entity getTargetEntity() {
        Entity entity = this.getEntity();
        if (entity != null) {
            return ElementUtil.getLinkTarget(entity);
        }
        return null;
    }

    public boolean isSource(Reference reference) {
        return this.getSourceReference() == reference;
    }

    public boolean isTarget(Reference reference) {
        return this.getTargetReference() == reference;
    }

    public void setSendingInstant(int n2) {
        this.setProperty("sendingInstant", "" + n2);
    }

    public int getSendingInstant() {
        String string = this.getProperty("sendingInstant");
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            SequenceElement sequenceElement = this.getPredecessorElement();
            if (sequenceElement == null) {
                return 0;
            }
            int n2 = sequenceElement.getIndex(this);
            if (n2 < 0) {
                n2 = SequenceModelUtil.normalizedIndex2childIndex(sequenceElement, this.getNormalizedIndex());
            }
            int n3 = SequenceModelUtil.childIndex2timeInstant(sequenceElement, n2, null);
            return n3;
        }
    }

    public void setDeliveryTime(int n2) {
        this.setProperty("deliveryTime", "" + n2);
    }

    public int getDeliveryTime() {
        String string = this.getProperty("deliveryTime");
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 5;
        }
    }

    public boolean isAtomicDelivery() {
        return !this.hasProperty("hasDeliveryTime");
    }

    public void setBranchingAnchor(SequenceMessage sequenceMessage) {
        String string = null;
        if (sequenceMessage != null) {
            string = sequenceMessage.getUID();
        }
        this.myBranchingAnchor = sequenceMessage;
        this.setProperty("branchingAnchorUid", string);
    }

    public SequenceMessage getBranchingAnchor() {
        SequenceMessage sequenceMessage;
        if (!this.isBranched()) {
            return null;
        }
        if (this.myBranchingAnchor != null) {
            return this.myBranchingAnchor;
        }
        String string = this.getProperty("branchingAnchorUid");
        this.myBranchingAnchor = sequenceMessage = (SequenceMessage)this.getSequenceModel().findElement(string);
        return sequenceMessage;
    }

    public boolean isBranched() {
        return this.hasProperty("branchingAnchorUid");
    }

    public abstract TimeInterval getProcessingInterval();

    public abstract TimeInterval getControlGainInterval();
}

