/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.interaction.model;

import com.togethersoft.togetherxj.uml.interaction.model.SequenceElement$IteratorAdapter;
import com.togethersoft.togetherxj.uml.interaction.model.SequenceModel;
import com.togethersoft.togetherxj.uml.interaction.model.TimeInterval;
import com.togethersoft.togetherxj.uml.interaction.model.util.SequenceElementEntityUtil;
import com.togethersoft.togetherxj.uml.interaction.model.util.SequenceNumber;
import com.togethersoft.togetherxj.uml.interaction.util.ElementUtil;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Reference;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

public abstract class SequenceElement
extends DefaultMutableTreeNode {
    private Reference myReference;
    private SequenceModel mySequenceModel;

    public SequenceElement(SequenceModel sequenceModel, Reference reference) {
        this.myReference = reference;
        this.mySequenceModel = sequenceModel;
    }

    public abstract SequenceElement getExportableCopy(SequenceModel var1);

    public void dispose() {
        this.myReference = null;
        this.mySequenceModel = null;
        int n2 = this.getChildCount();
        int n3 = n2 - 1;
        while (n3 >= 0) {
            SequenceElement sequenceElement = (SequenceElement)this.getChildAt(n3);
            this.removeSubsequentElement(sequenceElement);
            sequenceElement.dispose();
            --n3;
        }
    }

    public abstract void invalidate();

    public SequenceModel getSequenceModel() {
        return this.mySequenceModel;
    }

    public void setSequenceModel(SequenceModel sequenceModel) {
        this.mySequenceModel = sequenceModel;
    }

    public Reference getReference() {
        return this.myReference;
    }

    public Entity getEntity() {
        return this.myReference != null ? this.myReference.getEntity() : null;
    }

    public void setReference(Reference reference) {
        this.myReference = reference;
        this.invalidate();
    }

    public String getUID() {
        return this.myReference == null ? null : this.myReference.getEntity().getUniqueName().toString();
    }

    public String getName() {
        return this.getProperty("$name");
    }

    public String getMetaclass() {
        return this.getProperty("$metaclass");
    }

    public boolean isInitialMessage() {
        return this.getPredecessorElement().isRootElement();
    }

    public abstract SequenceNumber getSequenceNumber();

    public boolean isRootElement() {
        return false;
    }

    public void addSubsequentElement(SequenceElement sequenceElement, int n2) {
        super.insert(sequenceElement, n2);
    }

    public void removeSubsequentElement(SequenceElement sequenceElement) {
        super.remove(sequenceElement);
    }

    public void insert(MutableTreeNode mutableTreeNode, int n2) {
        throw new RuntimeException("addSubsequentElement should be used!");
    }

    public void add(MutableTreeNode mutableTreeNode) {
        throw new RuntimeException("addSubsequentElement should be used!");
    }

    public void remove(MutableTreeNode mutableTreeNode) {
        throw new RuntimeException("removeSubsequentElement should be used!");
    }

    public SequenceElement getPredecessorElement() {
        return (SequenceElement)this.getParent();
    }

    public Iterator subsequentElements() {
        if (this.getChildCount() == 0) {
            Collections.EMPTY_LIST.iterator();
        }
        return new SequenceElement$IteratorAdapter(this.children());
    }

    public SequenceElement getSubsequentElementAt(int n2) {
        return (SequenceElement)this.getChildAt(n2);
    }

    public boolean isPredecessorElement(SequenceElement sequenceElement) {
        if (this.getPredecessorElement() != null) {
            return this.getPredecessorElement() == sequenceElement;
        }
        String string = this.getProperty("predecessorUid");
        if (string == null) {
            return sequenceElement.isRootElement();
        }
        return string.equals(sequenceElement.getUID());
    }

    public void shiftElement(int n2) {
        if (n2 == 0 || this.isRootElement()) {
            return;
        }
        TimeInterval timeInterval = this.getControlGainInterval();
        timeInterval.shift(n2);
    }

    public void shiftSubsequentElements(int n2, int n3) {
        if (n2 == 0) {
            return;
        }
        int n4 = this.getChildCount();
        int n5 = n3;
        while (n5 < n4) {
            SequenceElement sequenceElement = this.getSubsequentElementAt(n5);
            sequenceElement.shiftElement(n2);
            ++n5;
        }
    }

    public void validateInitialInstant(SequenceElement sequenceElement) {
        if (this.isBranched()) {
            return;
        }
        int n2 = sequenceElement.getControlGainInterval().getCompletionInstant();
        int n3 = n2 + 5;
        TimeInterval timeInterval = this.getControlGainInterval();
        int n4 = timeInterval.getInitialInstant();
        if (n4 < n3) {
            int n5 = n3 - n4;
            this.shiftElement(n5);
        }
    }

    public void setNormalizedIndex(float f2) {
        this.setProperty("normalizedIndex", String.valueOf(f2));
    }

    public float getNormalizedIndex() {
        return SequenceElementEntityUtil.getNormalizedIndex(this.getEntity());
    }

    public abstract boolean isBranched();

    public abstract TimeInterval getProcessingInterval();

    public abstract TimeInterval getControlGainInterval();

    public String toString() {
        return "- " + this.getMetaclass() + ":" + this.getName() + ", ni=" + this.getProperty("normalizedIndex") + ", processing " + this.getProcessingInterval() + ", control gain " + this.getControlGainInterval();
    }

    public void setProperty(String string, String string2) {
        Reference reference;
        Object object = reference = ElementUtil.isOurReferenceAttribute(string) ? this.getReference() : this.getEntity();
        if (reference != null) {
            reference.setPropertyValue(string, string2);
        }
    }

    public void setProperty(String string, boolean bl2) {
        Reference reference;
        Object object = reference = ElementUtil.isOurReferenceAttribute(string) ? this.getReference() : this.getEntity();
        if (reference != null) {
            if (bl2) {
                reference.setPropertyValue(string, "true");
            } else {
                reference.setPropertyValue(string, null);
            }
        }
    }

    public String getProperty(String string) {
        String string2;
        Reference reference;
        Object object = reference = ElementUtil.isOurReferenceAttribute(string) ? this.getReference() : this.getEntity();
        if (reference != null && (string2 = reference.getPropertyValue(string)) != null && string2.length() > 0) {
            return string2;
        }
        return null;
    }

    public boolean hasProperty(String string) {
        return this.getProperty(string) != null;
    }
}

