/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.interaction.model;

import com.togethersoft.togetherxj.uml.interaction.model.ConventionalMessage;
import com.togethersoft.togetherxj.uml.interaction.model.TimeInterval;
import com.tssap.selena.model.elements.Reference;

class MessageControlGainInterval
extends TimeInterval {
    private ConventionalMessage myMessage;

    public MessageControlGainInterval(ConventionalMessage conventionalMessage) {
        this.myMessage = conventionalMessage;
    }

    public boolean hasReliableInitialInstant() {
        return this.myMessage.hasProperty("sendingInstant");
    }

    public int getInitialInstant() {
        return this.myMessage.getSendingInstant();
    }

    public void setInitialInstant(int n2) {
        this.myMessage.setSendingInstant(n2);
    }

    public int getDuration() {
        int n2 = 0;
        if (this.myMessage.isNestedControlFlow()) {
            n2 = this.myMessage.getProcessingDuration();
            if (!this.myMessage.isAtomicDelivery()) {
                int n3 = this.myMessage.getDeliveryTime();
                n2 += n3;
            }
        } else {
            n2 = 0;
        }
        return n2;
    }

    public void setDuration(int n2) {
        throw new RuntimeException("Can't set duration to a message control gain interval.");
    }

    public int getMinimalDuration() {
        return this.getDuration();
    }

    public void setMinimalDuration(int n2) {
        throw new RuntimeException("Can't set minimal duration to a message control gain interval.");
    }

    public void shift(int n2) {
        if (n2 != 0) {
            int n3 = this.getInitialInstant();
            this.myMessage.setSendingInstant(n3 + n2);
            this.myMessage.shiftSubsequentElements(n2, 0);
        }
    }

    public Reference getLifelineOwner() {
        return this.myMessage.getSourceReference();
    }
}

