/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.interaction.model;

import com.togethersoft.togetherxj.uml.interaction.model.MessageControlGainInterval;
import com.togethersoft.togetherxj.uml.interaction.model.MessageProcessingInterval;
import com.togethersoft.togetherxj.uml.interaction.model.SequenceElement;
import com.togethersoft.togetherxj.uml.interaction.model.SequenceMessage;
import com.togethersoft.togetherxj.uml.interaction.model.SequenceModel;
import com.togethersoft.togetherxj.uml.interaction.model.TimeInterval;
import com.togethersoft.togetherxj.uml.interaction.model.util.SequenceElementEntityUtil;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Reference;

public class ConventionalMessage
extends SequenceMessage {
    private TimeInterval myControlGainInterval;
    private TimeInterval myProcessingInterval;
    private Entity myActivation;

    public ConventionalMessage(SequenceModel sequenceModel, Reference reference) {
        super(sequenceModel, reference);
    }

    public SequenceElement getExportableCopy(SequenceModel sequenceModel) {
        return new ConventionalMessage(sequenceModel, this.getReference());
    }

    public void invalidate() {
        this.myControlGainInterval = null;
        this.myProcessingInterval = null;
        this.myActivation = null;
        super.invalidate();
    }

    public boolean isNestedControlFlow() {
        String string = this.getProperty("controlFlowType");
        return !"asynchronous".equals(string);
    }

    public Entity getActivationEntity() {
        if (this.myActivation == null) {
            this.myActivation = SequenceElementEntityUtil.findActivationEntity(this.getEntity());
        }
        return this.myActivation;
    }

    public int getProcessingDuration() {
        String string = this.getProperty("processingDuration");
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 20;
        }
    }

    public void setProcessingDuration(int n2) {
        int n3 = this.getProcessingInterval().getMinimalDuration();
        n2 = Math.max(n2, n3);
        this.setProperty("processingDuration", "" + n2);
    }

    public TimeInterval getProcessingInterval() {
        if (this.myProcessingInterval == null) {
            this.myProcessingInterval = new MessageProcessingInterval(this);
        }
        return this.myProcessingInterval;
    }

    public TimeInterval getControlGainInterval() {
        if (this.myControlGainInterval == null) {
            this.myControlGainInterval = new MessageControlGainInterval(this);
        }
        return this.myControlGainInterval;
    }
}

