/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.interaction.cd.figures;

import com.togethersoft.togetherxj.uml.cdl.viewmaps.MessageLabelInplaceEditorApplier;
import com.togethersoft.togetherxj.uml.cdl.viewmaps.MessageLabelProvider;
import com.togethersoft.togetherxj.uml.interaction.cd.figures.MessageDecoration;
import com.togethersoft.togetherxj.uml.interaction.cd.figures.MessagesContainer;
import com.tssap.selena.draw2d.InvisibleRectangle;
import com.tssap.selena.gde.IInplaceEditorApplier;
import com.tssap.selena.gde.ModelElementEditPart;
import com.tssap.selena.gde.figures.DecorationFigure;
import com.tssap.selena.gde.viewmap.IViewMapParameters;
import com.tssap.selena.internal.viewmaps.figures.TextLabel;
import com.tssap.selena.layout.draw2d.BorderLayout;
import com.tssap.selena.model.elements.Reference;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jface.resource.JFaceResources;

public class MessageFigure
extends InvisibleRectangle {
    private MessageDecoration myArrow;
    private TextLabel myTextLabel;
    private boolean isHorizontal = true;
    protected Reference myReference;
    private MessageLabelInplaceEditorApplier myInplaceApplier;

    public MessageFigure(ModelElementEditPart modelElementEditPart, IViewMapParameters iViewMapParameters) {
        this.setFont(JFaceResources.getBannerFont());
        this.myArrow = new MessageDecoration();
        this.myArrow.setScale(7.0, 3.5);
        this.setLayoutManager((LayoutManager)new BorderLayout());
        this.myReference = (Reference)modelElementEditPart.getElement();
        String string = this.getLabelText(this.myReference);
        this.myTextLabel = new TextLabel(string);
        this.myTextLabel.setTextAlignment(1);
        this.myTextLabel.setLabelAlignment(1);
        this.add((IFigure)this.myArrow, "West");
        this.add((IFigure)this.myTextLabel, "Center");
        this.refreshLabelText();
    }

    protected Reference getReference() {
        return this.myReference;
    }

    public String getLabelText(Reference reference) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = reference.getPropertyValue("sequenceNumber");
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append(':');
        }
        MessageLabelProvider messageLabelProvider = new MessageLabelProvider();
        stringBuffer.append(messageLabelProvider.getText(reference));
        return stringBuffer.toString();
    }

    public void addNotify() {
        IFigure iFigure;
        MessagesContainer messagesContainer;
        IFigure iFigure2 = this.getParent();
        if (iFigure2 instanceof MessagesContainer) {
            messagesContainer = (MessagesContainer)iFigure2;
            messagesContainer.addMessage(this);
        }
        if (iFigure2 instanceof DecorationFigure && (iFigure = (messagesContainer = (DecorationFigure)iFigure2).getParent()) instanceof MessagesContainer) {
            MessagesContainer messagesContainer2 = (MessagesContainer)iFigure;
            messagesContainer2.addMessage(this);
        }
        this.refreshLabelText();
    }

    public void removeNotify() {
        IFigure iFigure;
        MessagesContainer messagesContainer;
        IFigure iFigure2 = this.getParent();
        if (iFigure2 instanceof MessagesContainer) {
            messagesContainer = (MessagesContainer)iFigure2;
            messagesContainer.removeMessage(this);
        }
        if (iFigure2 instanceof DecorationFigure && (iFigure = (messagesContainer = (DecorationFigure)iFigure2).getParent()) instanceof MessagesContainer) {
            MessagesContainer messagesContainer2 = (MessagesContainer)iFigure;
            messagesContainer2.removeMessage(this);
        }
    }

    public RotatableDecoration getArrow() {
        return this.myArrow;
    }

    public IInplaceEditorApplier getInplaceEditorApplier() {
        if (this.myInplaceApplier == null) {
            this.myInplaceApplier = new MessageLabelInplaceEditorApplier(this.getReference());
        }
        return this.myInplaceApplier;
    }

    public Dimension getPreferredSize() {
        int n2 = 0;
        int n3 = 0;
        double d2 = this.myArrow.getRotation();
        if (Math.abs(d2) >= 0.7853981633974483 && Math.abs(d2) <= 2.356194490192345) {
            n2 = Math.max(this.myArrow.getPreferredSize().height, this.myTextLabel.getPreferredSize().height);
            n3 = this.myArrow.getPreferredSize().width + this.myTextLabel.getPreferredSize().width;
        } else {
            n2 = this.myArrow.getPreferredSize().height + this.myTextLabel.getPreferredSize().height;
            n3 = Math.max(this.myArrow.getPreferredSize().width, this.myTextLabel.getPreferredSize().width);
        }
        Dimension dimension = new Dimension(n3, n2);
        return dimension;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void refreshLabelText() {
        if (this.myTextLabel != null) {
            IStatus iStatus = new MessageLabelProvider().getStatus(this.myReference);
            if (!iStatus.isOK()) {
                this.myTextLabel.setForegroundColor(ColorConstants.red);
                String string = iStatus.getMessage();
                if (string != null && string.length() > 0) {
                    this.myTextLabel.setToolTip((IFigure)new Label(string));
                }
            } else {
                this.myTextLabel.setForegroundColor(ColorConstants.black);
                this.myTextLabel.setToolTip(null);
            }
        }
    }

    public void layout() {
        double d2 = this.myArrow.getRotation();
        if (Math.abs(d2) >= 0.7853981633974483 && Math.abs(d2) <= 2.356194490192345) {
            if (!this.isHorizontal) {
                this.isHorizontal = true;
                this.getLayoutManager().remove((IFigure)this.myArrow);
                this.setConstraint((IFigure)this.myArrow, "West");
            }
        } else if (this.isHorizontal) {
            this.isHorizontal = false;
            this.getLayoutManager().remove((IFigure)this.myArrow);
            this.setConstraint((IFigure)this.myArrow, "North");
        }
        this.myTextLabel.setSize(this.myTextLabel.getPreferredSize());
        this.myArrow.setSize(this.myArrow.getPreferredSize());
        super.layout();
        this.setSize(this.getPreferredSize());
        this.repaint();
    }

    public TextLabel getNameLabel() {
        return this.myTextLabel;
    }
}

