/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.uml.interaction.cd.figures;

import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polygon;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transform;

public class MessageDecoration
extends Polygon
implements RotatableDecoration {
    public static final PointList TRIANGLE_TIP = new PointList();
    public static final PointList INVERTED_TRIANGLE_TIP = new PointList();
    private Point location = new Point();
    private PointList template = TRIANGLE_TIP;
    private Transform transform = new Transform();
    private double myAngle = 0.0;
    private static Rectangle LINEBOUNDS;
    private int TOLERANCE = 3;
    private int calculatedTolerance;

    public MessageDecoration() {
        this.setFill(true);
        this.setBackgroundColor(ColorConstants.white);
        this.setScale(7.0, 3.0);
    }

    protected PointList correctPoints(PointList pointList) {
        if (this.getParent() != null) {
            int n2;
            PointList pointList2;
            int n3 = 0;
            int n4 = 0;
            Rectangle rectangle = this.getParent().getBounds();
            int n5 = rectangle.x;
            int n6 = rectangle.y;
            int n7 = 0;
            while (n7 < pointList.size()) {
                pointList2 = pointList.getPoint(n7);
                n2 = n5 - pointList2.x;
                int n8 = n6 - pointList2.y;
                if (n2 > n3) {
                    n3 = n2;
                }
                if (n8 > n4) {
                    n4 = n8;
                }
                ++n7;
            }
            pointList2 = new PointList();
            n2 = 0;
            while (n2 < pointList.size()) {
                pointList2.addPoint(pointList.getPoint((int)n2).x + n3, pointList.getPoint((int)n2).y + n4);
                ++n2;
            }
            return pointList2;
        }
        return pointList;
    }

    protected PointList getPoints() {
        PointList pointList = new PointList();
        int n2 = 0;
        while (n2 < this.template.size()) {
            pointList.addPoint(this.transform.getTransformed(this.template.getPoint(n2)));
            ++n2;
        }
        return this.correctPoints(pointList);
    }

    public void setLocation(Point point) {
        this.setPoints(null);
        ((Figure)this).bounds = null;
        this.location.setLocation(point);
        this.transform.setTranslation((double)point.x, (double)point.y);
    }

    public void setTemplate(PointList pointList) {
        this.erase();
        this.template = pointList;
        this.setPoints(null);
        ((Figure)this).bounds = null;
        this.repaint();
    }

    public void setScale(double d2, double d3) {
        this.setPoints(null);
        ((Figure)this).bounds = null;
        this.transform.setScale(d2, d3);
    }

    public void setReferencePoint(Point point) {
        Point point2 = Point.SINGLETON;
        point2.setLocation(point);
        point2.negate().translate(this.location);
        this.setRotation(Math.atan2(point2.y, point2.x));
    }

    public void setRotation(double d2) {
        this.myAngle = d2;
        this.setPoints(null);
        ((Figure)this).bounds = null;
        this.transform.setRotation(d2);
    }

    public double getRotation() {
        return this.myAngle;
    }

    public Dimension getPreferredSize() {
        Point point;
        this.setPoints(null);
        PointList pointList = this.getPoints();
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MIN_VALUE;
        int n6 = 0;
        while (n6 < pointList.size()) {
            point = pointList.getPoint(n6);
            if (point.x > n3) {
                n3 = point.x;
            }
            if (point.x < n2) {
                n2 = point.x;
            }
            if (point.y > n5) {
                n5 = point.y;
            }
            if (point.y < n4) {
                n4 = point.y;
            }
            ++n6;
        }
        point = new Dimension(Math.abs(n3 - n2) + 2, Math.abs(n5 - n4) + 2);
        return point;
    }

    public boolean containsPoint(int n2, int n3) {
        this.calculateTolerance();
        LINEBOUNDS.setBounds(this.getBounds());
        LINEBOUNDS.expand(this.calculatedTolerance, this.calculatedTolerance);
        if (!LINEBOUNDS.contains(n2, n3)) {
            return false;
        }
        int[] nArray = this.getPoints().toIntArray();
        int n4 = 0;
        while (n4 < nArray.length - 3) {
            if (this.lineContainsPoint(nArray[n4], nArray[n4 + 1], nArray[n4 + 2], nArray[n4 + 3], n2, n3)) {
                return true;
            }
            n4 += 2;
        }
        List list = this.getChildren();
        int n5 = 0;
        while (n5 < list.size()) {
            if (((IFigure)list.get(n5)).containsPoint(n2, n3)) {
                return true;
            }
            ++n5;
        }
        return false;
    }

    private boolean lineContainsPoint(int n2, int n3, int n4, int n5, int n6, int n7) {
        LINEBOUNDS.setSize(0, 0);
        LINEBOUNDS.setLocation(n2, n3);
        LINEBOUNDS.union(n4, n5);
        LINEBOUNDS.expand(this.calculatedTolerance, this.calculatedTolerance);
        if (!LINEBOUNDS.contains(n6, n7)) {
            return false;
        }
        int n8 = 0;
        if (n2 != n4 && n3 != n5) {
            int n9 = n4 - n2;
            int n10 = n5 - n3;
            int n11 = n6 - n2;
            int n12 = n7 - n3;
            int n13 = n11 * n10 - n9 * n12;
            int n14 = n9 * n9 + n10 * n10;
            n8 = (n13 << 10) / n14 * n13 >> 10;
        }
        return n8 <= this.calculatedTolerance * this.calculatedTolerance;
    }

    private void calculateTolerance() {
        this.calculatedTolerance = this.TOLERANCE + ((Shape)this).lineWidth / 2;
    }

    static {
        TRIANGLE_TIP.addPoint(0, 1);
        TRIANGLE_TIP.addPoint(2, 1);
        TRIANGLE_TIP.addPoint(2, 0);
        TRIANGLE_TIP.addPoint(3, 1);
        TRIANGLE_TIP.addPoint(2, 2);
        TRIANGLE_TIP.addPoint(2, 1);
        LINEBOUNDS = Rectangle.SINGLETON;
    }
}

