/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;

public class TextUtilities {
    public static final String[] fgDelimiters = new String[]{"\n", "\r", "\r\n"};

    public static String determineLineDelimiter(String text, String hint) {
        try {
            int[] info = TextUtilities.indexOf(fgDelimiters, text, 0);
            return fgDelimiters[info[1]];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return hint;
        }
    }

    public static int[] indexOf(String[] searchStrings, String text, int offset) {
        int[] result = new int[]{-1, -1};
        int zeroIndex = -1;
        int i = 0;
        while (i < searchStrings.length) {
            int length = searchStrings[i].length();
            if (length == 0) {
                zeroIndex = i;
            } else {
                int index = text.indexOf(searchStrings[i], offset);
                if (index >= 0) {
                    if (result[0] == -1) {
                        result[0] = index;
                        result[1] = i;
                    } else if (index < result[0]) {
                        result[0] = index;
                        result[1] = i;
                    } else if (index == result[0] && length > searchStrings[result[1]].length()) {
                        result[0] = index;
                        result[1] = i;
                    }
                }
            }
            ++i;
        }
        if (zeroIndex > -1 && result[0] == -1) {
            result[0] = 0;
            result[1] = zeroIndex;
        }
        return result;
    }

    public static int endsWith(String[] searchStrings, String text) {
        int index = -1;
        int i = 0;
        while (i < searchStrings.length) {
            if (text.endsWith(searchStrings[i]) && (index == -1 || searchStrings[i].length() > searchStrings[index].length())) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    public static int startsWith(String[] searchStrings, String text) {
        int index = -1;
        int i = 0;
        while (i < searchStrings.length) {
            if (text.startsWith(searchStrings[i]) && (index == -1 || searchStrings[i].length() > searchStrings[index].length())) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    public static int equals(String[] compareStrings, String text) {
        int i = 0;
        while (i < compareStrings.length) {
            if (text.equals(compareStrings[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static DocumentEvent mergeUnprocessedDocumentEvents(IDocument unprocessedDocument, List documentEvents) throws BadLocationException {
        if (documentEvents.size() == 0) {
            return null;
        }
        Iterator iterator = documentEvents.iterator();
        DocumentEvent firstEvent = (DocumentEvent)iterator.next();
        IDocument document = unprocessedDocument;
        int offset = firstEvent.getOffset();
        int length = firstEvent.getLength();
        StringBuffer text = new StringBuffer(firstEvent.getText() == null ? "" : firstEvent.getText());
        while (iterator.hasNext()) {
            String eventText;
            int delta = text.length() - length;
            DocumentEvent event = (DocumentEvent)iterator.next();
            int eventOffset = event.getOffset();
            int eventLength = event.getLength();
            String string = eventText = event.getText() == null ? "" : event.getText();
            if (eventOffset > offset + length + delta) {
                String string2 = document.get(offset + length, eventOffset - delta - (offset + length));
                text.append(string2);
                text.append(eventText);
                length = eventOffset - delta + eventLength - offset;
                continue;
            }
            if (eventOffset + eventLength < offset) {
                String string3 = document.get(eventOffset + eventLength, offset - (eventOffset + eventLength));
                text.insert(0, string3);
                text.insert(0, eventText);
                length = offset + length - eventOffset;
                offset = eventOffset;
                continue;
            }
            int start = Math.max(0, eventOffset - offset);
            int end = Math.min(text.length(), eventLength + eventOffset - offset);
            text.replace(start, end, eventText);
            offset = Math.min(offset, eventOffset);
            int totalDelta = delta + eventText.length() - eventLength;
            length = text.length() - totalDelta;
        }
        return new DocumentEvent(document, offset, length, text.toString());
    }

    public static DocumentEvent mergeProcessedDocumentEvents(List documentEvents) throws BadLocationException {
        if (documentEvents.size() == 0) {
            return null;
        }
        ListIterator iterator = documentEvents.listIterator(documentEvents.size());
        DocumentEvent firstEvent = (DocumentEvent)iterator.previous();
        IDocument document = firstEvent.getDocument();
        int offset = firstEvent.getOffset();
        int length = firstEvent.getLength();
        int textLength = firstEvent.getText() == null ? 0 : firstEvent.getText().length();
        while (iterator.hasPrevious()) {
            int eventTextLength;
            int delta = length - textLength;
            DocumentEvent event = (DocumentEvent)iterator.previous();
            int eventOffset = event.getOffset();
            int eventLength = event.getLength();
            int n = eventTextLength = event.getText() == null ? 0 : event.getText().length();
            if (eventOffset > offset + textLength + delta) {
                length = eventOffset - delta - (offset + textLength) + length + eventLength;
                textLength = eventOffset - delta + eventTextLength - offset;
                continue;
            }
            if (eventOffset + eventTextLength < offset) {
                length = offset - (eventOffset + eventTextLength) + length + eventLength;
                textLength = offset + textLength - eventOffset;
                offset = eventOffset;
                continue;
            }
            int start = Math.max(0, eventOffset - offset);
            int end = Math.min(length, eventTextLength + eventOffset - offset);
            offset = Math.min(offset, eventOffset);
            int totalDelta = delta + eventLength - eventTextLength;
            textLength = (length += eventLength - (end - start)) - totalDelta;
        }
        String text = document.get(offset, textLength);
        return new DocumentEvent(document, offset, length, text);
    }
}

