/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.Fragment;
import org.eclipse.jface.text.FragmentUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.ProjectionPosition;
import org.eclipse.jface.text.ProjectionTextStore;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.SlaveDocumentEvent;

public final class ProjectionDocument
extends AbstractDocument {
    public static final String FRAGMENT_CATEGORY = "__fragment_category";
    private IDocument fParentDocument;
    private IDocumentExtension fExtension;
    private String fProjectionCategory;
    private DocumentEvent fParentEvent;
    private SlaveDocumentEvent fEvent;
    private boolean fIsUpdating = false;
    private FragmentUpdater fFragmentUpdater = new FragmentUpdater("__fragment_category");

    public ProjectionDocument(IDocument parentDocument, String projectionCategory) {
        this.fParentDocument = parentDocument;
        if (this.fParentDocument instanceof IDocumentExtension) {
            this.fExtension = (IDocumentExtension)((Object)this.fParentDocument);
        }
        ProjectionTextStore s = new ProjectionTextStore(this);
        DefaultLineTracker tracker = new DefaultLineTracker();
        this.setTextStore(s);
        this.setLineTracker(tracker);
        this.completeInitialization();
        this.initializeProjection(projectionCategory);
        tracker.set(s.get(0, s.getLength()));
    }

    private void initializeProjection(String projectionCategory) {
        this.fProjectionCategory = projectionCategory;
        try {
            this.addPositionCategory(FRAGMENT_CATEGORY);
            this.addPositionUpdater(this.fFragmentUpdater);
            int offset = 0;
            Position[] patch = this.fParentDocument.getPositions(this.fProjectionCategory);
            int i = 0;
            while (i < patch.length) {
                Position p = patch[i];
                this.addPosition(FRAGMENT_CATEGORY, new Fragment(offset, p.length, p));
                offset += p.length;
                ++i;
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
        }
        catch (BadLocationException badLocationException) {}
    }

    public Fragment createFragment(Position parentPosition) {
        try {
            int index = this.fParentDocument.computeIndexInCategory(this.fProjectionCategory, parentPosition.offset);
            if (index <= 0) {
                return new Fragment(0, parentPosition.length, parentPosition);
            }
            Position[] fragments = this.getPositions(FRAGMENT_CATEGORY);
            Position p = fragments[index - 1];
            return new Fragment(p.offset + p.length, parentPosition.length, parentPosition);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
        }
        catch (BadLocationException badLocationException) {}
        return null;
    }

    private int getPositionOfOffset(IDocument document, String category, int offset, int direction) throws BadPositionCategoryException, BadLocationException {
        Position[] positions = document.getPositions(category);
        if (positions != null && positions.length > 0) {
            int index = document.computeIndexInCategory(category, offset);
            if (index < positions.length && positions[index].includes(offset)) {
                return index;
            }
            if (index > 0 && positions[index - 1].includes(offset)) {
                return index - 1;
            }
            if (direction != 0) {
                if (direction > 0) {
                    if (index < positions.length && positions[index].overlapsWith(offset, direction)) {
                        return index;
                    }
                } else if (index > 0 && positions[index - 1].overlapsWith(offset + direction, -direction)) {
                    return index - 1;
                }
            }
        }
        return -1;
    }

    private Position getParentDocumentPositionOfOffset(int offsetInParent, int direction) {
        try {
            int index = this.getPositionOfOffset(this.fParentDocument, this.fProjectionCategory, offsetInParent, direction);
            if (index > -1) {
                Position[] positions = this.fParentDocument.getPositions(this.fProjectionCategory);
                return positions[index];
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
        }
        catch (BadLocationException badLocationException) {}
        return null;
    }

    private int toProjectionDocumentOffset(int offsetInParent, int direction) {
        Position p = this.getParentDocumentPositionOfOffset(offsetInParent, direction);
        if (p == null) {
            return -1;
        }
        int relative = offsetInParent - p.offset;
        if (direction > 0) {
            if (relative < 0) {
                relative = 0;
            }
        } else if (direction < 0 && relative >= p.length) {
            relative = p.length - 1;
        }
        Fragment f = this.findCorrespondingFragment(p);
        return f.offset + relative;
    }

    public Position computeProjectionDocumentPosition(int offsetInParent, int lengthInParent) {
        Position p = this.getParentDocumentCoverage();
        if (p != null) {
            Position[] fragments;
            if (p.overlapsWith(offsetInParent, lengthInParent)) {
                int o1 = this.toProjectionDocumentOffset(offsetInParent, lengthInParent);
                if (o1 == -1) {
                    return null;
                }
                if (lengthInParent == 0) {
                    return new Position(o1, 0);
                }
                int o2 = this.toProjectionDocumentOffset(offsetInParent + lengthInParent - 1, 1 - lengthInParent);
                if (o2 == -1) {
                    return null;
                }
                return new Position(o1, o2 - o1 + 1);
            }
            if (p.getOffset() + p.getLength() == offsetInParent + lengthInParent && (fragments = this.getFragmentation()) != null && fragments.length > 0) {
                Position last = fragments[fragments.length - 1];
                return new Position(last.getOffset() + last.getLength());
            }
        }
        return null;
    }

    public int toParentDocumentOffset(int offset) throws BadLocationException {
        Fragment fragment = this.getFragmentOfOffset(offset);
        if (fragment == null) {
            Position[] fragmentation = this.getFragmentation();
            if (fragmentation != null && fragmentation.length > 0) {
                Fragment last = (Fragment)fragmentation[fragmentation.length - 1];
                if (last.offset + last.length == offset) {
                    Position origin = last.getOrigin();
                    return origin.offset + origin.length;
                }
            }
            throw new BadLocationException();
        }
        int relative = offset - fragment.offset;
        return fragment.getOrigin().offset + relative;
    }

    public IRegion computeParentDocumentRegion(int offset, int length) throws BadLocationException {
        if (length == 0) {
            if (offset == 0 && length == this.getLength()) {
                return new Region(0, this.fParentDocument.getLength());
            }
            return new Region(this.toParentDocumentOffset(offset), 0);
        }
        int o1 = this.toParentDocumentOffset(offset);
        int o2 = this.toParentDocumentOffset(offset + length - 1);
        return new Region(o1, o2 - o1 + 1);
    }

    public void removeAllFragments() {
        Position[] projection = this.getProjection();
        if (projection == null) {
            return;
        }
        int i = 0;
        while (i < projection.length) {
            try {
                this.removeFragment(projection[i]);
            }
            catch (BadLocationException badLocationException) {}
            ++i;
        }
    }

    public void addFragment(int offsetInParent, int lengthInParent) throws BadLocationException {
        if (lengthInParent == 0) {
            return;
        }
        try {
            ProjectionPosition p = new ProjectionPosition(this, offsetInParent, lengthInParent);
            this.fParentDocument.addPosition(this.fProjectionCategory, p);
            Fragment fragment = this.createFragment(p);
            p.setFragment(fragment);
            this.fireDocumentProjectionChanged(new DocumentEvent(this, fragment.offset, 0, this.fParentDocument.get(offsetInParent, lengthInParent)));
            this.addPosition(FRAGMENT_CATEGORY, fragment);
            this.getTracker().set(this.getStore().get(0, this.getStore().getLength()));
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
    }

    public void joinFragments() {
        try {
            while (this.joinTwoFragments()) {
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
    }

    private boolean joinTwoFragments() throws BadPositionCategoryException {
        Position[] projection = this.getProjection();
        if (projection != null && projection.length > 0) {
            Position previous = projection[0];
            int i = 1;
            while (i < projection.length) {
                Position current = projection[i];
                if (previous.offset + previous.length == current.offset) {
                    this.join(previous, current);
                    return true;
                }
                previous = current;
                ++i;
            }
        }
        return false;
    }

    private void join(Position p1, Position p2) throws BadPositionCategoryException {
        Fragment fragment = this.findCorrespondingFragment(p2);
        this.removePosition(FRAGMENT_CATEGORY, fragment);
        this.fParentDocument.removePosition(this.fProjectionCategory, p2);
        fragment = this.findCorrespondingFragment(p1);
        fragment.length += p2.length;
        p1.length += p2.length;
    }

    public void removeFragment(Position parentPosition) throws BadLocationException {
        try {
            Fragment fragment = this.findCorrespondingFragment(parentPosition);
            if (fragment != null) {
                this.removePosition(FRAGMENT_CATEGORY, fragment);
                this.fParentDocument.removePosition(this.fProjectionCategory, parentPosition);
                this.fireDocumentProjectionChanged(new DocumentEvent(this, fragment.offset, fragment.length, null));
                this.getTracker().set(this.getStore().get(0, this.getStore().getLength()));
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
    }

    public Position[] getAffectedFragments(int offsetInParent, int lengthInParent) {
        Position p = this.computeProjectionDocumentPosition(offsetInParent, lengthInParent);
        if (p == null) {
            return null;
        }
        Fragment[] f = this.getFragmentsOfRange(p.offset, p.length);
        if (f == null) {
            return null;
        }
        Position[] result = new Position[f.length];
        int i = 0;
        while (i < f.length) {
            result[i] = f[i].getOrigin();
            ++i;
        }
        return result;
    }

    private Fragment findCorrespondingFragment(Position parentPosition) {
        try {
            Position[] fragments = this.getPositions(FRAGMENT_CATEGORY);
            int i = 0;
            while (i < fragments.length) {
                Fragment f = (Fragment)fragments[i];
                if (parentPosition.equals(f.getOrigin())) {
                    return f;
                }
                ++i;
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
        return null;
    }

    protected Fragment getFragmentOfOffset(int offset) throws BadLocationException {
        try {
            int index = this.getPositionOfOffset(this, FRAGMENT_CATEGORY, offset, 0);
            if (index > -1) {
                Position[] fragments = this.getPositions(FRAGMENT_CATEGORY);
                return (Fragment)fragments[index];
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
        return null;
    }

    protected Fragment[] getFragmentsOfRange(int offset, int length) {
        try {
            int start = this.getPositionOfOffset(this, FRAGMENT_CATEGORY, offset, length);
            int end = this.getPositionOfOffset(this, FRAGMENT_CATEGORY, offset + length - 1, 1 - length);
            if (start > -1 && end > -1) {
                Position[] positions = this.getPositions(FRAGMENT_CATEGORY);
                if (start == end) {
                    return new Fragment[]{(Fragment)positions[start]};
                }
                Object[] result = new Fragment[end - start + 1];
                int i = start;
                while (i <= end) {
                    result[i - start] = (Fragment)positions[i];
                    ++i;
                }
                this.sortFragments(result);
                return result;
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
        }
        catch (BadLocationException badLocationException) {}
        return new Fragment[0];
    }

    private void sortFragments(Object[] result) {
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                Fragment f1 = (Fragment)o1;
                Fragment f2 = (Fragment)o2;
                return f1.getOrigin().getOffset() - f2.getOrigin().getOffset();
            }

            public boolean equals(Object obj) {
                return false;
            }
        };
        Arrays.sort(result, comparator);
    }

    public Position getParentDocumentCoverage() {
        Position[] projection = this.getProjection();
        if (projection != null && projection.length > 0) {
            Position first = projection[0];
            Position last = projection[projection.length - 1];
            return new Position(first.offset, last.offset - first.offset + last.length);
        }
        return new Position(0, 0);
    }

    private void fireDocumentProjectionChanged(DocumentEvent event) {
        this.fFragmentUpdater.enableShiftMode(true);
        try {
            this.updatePositions(event);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.fFragmentUpdater.enableShiftMode(false);
            throw throwable;
        }
        Object var2_4 = null;
        this.fFragmentUpdater.enableShiftMode(false);
    }

    public IDocument getParentDocument() {
        return this.fParentDocument;
    }

    public Position[] getProjection() {
        try {
            return this.fParentDocument.getPositions(this.fProjectionCategory);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            return null;
        }
    }

    public Position[] getFragmentation() {
        try {
            Object[] fragmentation = this.getPositions(FRAGMENT_CATEGORY);
            this.sortFragments(fragmentation);
            return fragmentation;
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            return null;
        }
    }

    private SlaveDocumentEvent normalize(DocumentEvent e) {
        Position c = this.computeProjectionDocumentPosition(e.getOffset(), e.getLength());
        if (c != null) {
            if (c.length == 0) {
                int insertLength;
                int n = insertLength = e.getText() == null ? 0 : e.getText().length();
                if (insertLength == 0) {
                    return null;
                }
            }
            return new SlaveDocumentEvent(this, c.offset, c.length, e.getText(), e);
        }
        return null;
    }

    public void parentDocumentAboutToBeChanged(DocumentEvent event) {
        this.fParentEvent = event;
        this.fEvent = this.normalize(event);
        if (this.fEvent != null) {
            this.delayedFireDocumentAboutToBeChanged();
        }
    }

    public void parentDocumentChanged(DocumentEvent event) {
        if (!this.fIsUpdating && event == this.fParentEvent && this.fEvent != null) {
            try {
                this.getTracker().replace(this.fEvent.getOffset(), this.fEvent.getLength(), this.fEvent.getText());
                this.fireDocumentChanged(this.fEvent);
            }
            catch (BadLocationException badLocationException) {
                Assert.isLegal(false);
            }
        }
    }

    protected void fireDocumentAboutToBeChanged(DocumentEvent event) {
    }

    private void delayedFireDocumentAboutToBeChanged() {
        super.fireDocumentAboutToBeChanged(this.fEvent);
    }

    protected void fireDocumentChanged(DocumentEvent event) {
        super.fireDocumentChanged(this.fEvent);
    }

    public void replace(int offset, int length, String text) throws BadLocationException {
        block4: {
            try {
                this.fIsUpdating = true;
                if (this.fExtension != null) {
                    this.fExtension.stopPostNotificationProcessing();
                }
                super.replace(offset, length, text);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.fIsUpdating = false;
                if (this.fExtension != null) {
                    this.fExtension.resumePostNotificationProcessing();
                }
                throw throwable;
            }
            Object var4_6 = null;
            this.fIsUpdating = false;
            if (this.fExtension == null) break block4;
            this.fExtension.resumePostNotificationProcessing();
        }
    }

    public void set(String text) {
        block4: {
            try {
                this.fIsUpdating = true;
                if (this.fExtension != null) {
                    this.fExtension.stopPostNotificationProcessing();
                }
                super.set(text);
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.fIsUpdating = false;
                if (this.fExtension != null) {
                    this.fExtension.resumePostNotificationProcessing();
                }
                throw throwable;
            }
            Object var2_4 = null;
            this.fIsUpdating = false;
            if (this.fExtension == null) break block4;
            this.fExtension.resumePostNotificationProcessing();
        }
    }

    public void registerPostNotificationReplace(IDocumentListener owner, IDocumentExtension.IReplace replace) {
        if (!this.fIsUpdating) {
            throw new UnsupportedOperationException();
        }
        super.registerPostNotificationReplace(owner, replace);
    }

    public void hide(int offsetInParent, int lengthInParent) {
        IDocument parent = this.getParentDocument();
        Position[] effected = this.getAffectedFragments(offsetInParent, lengthInParent);
        try {
            if (effected == null) {
                int end = offsetInParent + lengthInParent;
                this.addFragment(0, offsetInParent);
                this.addFragment(end, parent.getLength() - end);
            } else if (effected.length == 1) {
                Position fragment = effected[0];
                this.removeFragment(fragment);
                this.addFragment(fragment.offset, offsetInParent - fragment.offset);
                int secondOffset = offsetInParent + lengthInParent;
                this.addFragment(secondOffset, fragment.offset + fragment.length - secondOffset);
            } else {
                this.internalShow(offsetInParent, lengthInParent, effected);
                this.hide(offsetInParent, lengthInParent);
            }
            this.joinFragments();
        }
        catch (BadLocationException badLocationException) {}
    }

    public void show(int offsetInParent, int lengthInParent) {
        Position[] effected = this.getAffectedFragments(offsetInParent, lengthInParent);
        if (effected == null || effected.length == 0) {
            try {
                this.addFragment(offsetInParent, lengthInParent);
                this.joinFragments();
            }
            catch (BadLocationException badLocationException) {}
            return;
        }
        this.internalShow(offsetInParent, lengthInParent, effected);
        this.joinFragments();
    }

    private void internalShow(int offsetInParent, int lengthInParent, Position[] effected) {
        try {
            int size = effected.length;
            int i = 0;
            while (i < size) {
                this.removeFragment(effected[i]);
                ++i;
            }
            int offset = Math.min(offsetInParent, effected[0].offset);
            int end = Math.max(offsetInParent + lengthInParent, effected[size - 1].offset + effected[size - 1].length);
            this.addFragment(offset, end - offset);
        }
        catch (BadLocationException badLocationException) {}
    }
}

