/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.ChildDocument;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentInformationMapping;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.ISlaveDocumentManager;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.ParentChildMapping;
import org.eclipse.jface.text.Position;

public final class ChildDocumentManager
implements IDocumentListener,
ISlaveDocumentManager {
    public static final String CHILDDOCUMENTS = "__childdocuments";
    private IPositionUpdater fChildPositionUpdater;

    protected IPositionUpdater getChildPositionUpdater() {
        if (this.fChildPositionUpdater == null) {
            this.fChildPositionUpdater = new ChildPositionUpdater();
        }
        return this.fChildPositionUpdater;
    }

    public IDocument createSlaveDocument(IDocument master) {
        if (!master.containsPositionCategory(CHILDDOCUMENTS)) {
            master.addPositionCategory(CHILDDOCUMENTS);
            master.addPositionUpdater(this.getChildPositionUpdater());
            master.addDocumentListener(this);
        }
        ChildPosition pos = new ChildPosition(master, 0, 0);
        try {
            master.addPosition(CHILDDOCUMENTS, pos);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
        }
        catch (BadLocationException badLocationException) {}
        ChildDocument child = new ChildDocument(master, pos);
        ChildPartitioner partitioner = new ChildPartitioner();
        child.setDocumentPartitioner(partitioner);
        partitioner.connect(child);
        pos.fChildDocument = child;
        return child;
    }

    public void freeSlaveDocument(IDocument slave) {
        if (!(slave instanceof ChildDocument)) {
            return;
        }
        ChildDocument childDocument = (ChildDocument)slave;
        childDocument.getDocumentPartitioner().disconnect();
        ChildPosition pos = (ChildPosition)childDocument.getParentDocumentRange();
        IDocument parent = pos.fParentDocument;
        try {
            parent.removePosition(CHILDDOCUMENTS, pos);
            Position[] category = parent.getPositions(CHILDDOCUMENTS);
            if (category.length == 0) {
                parent.removeDocumentListener(this);
                parent.removePositionUpdater(this.getChildPositionUpdater());
                parent.removePositionCategory(CHILDDOCUMENTS);
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
    }

    public IDocumentInformationMapping createMasterSlaveMapping(IDocument slave) {
        if (slave instanceof ChildDocument) {
            return new ParentChildMapping((ChildDocument)slave);
        }
        return null;
    }

    public IDocument getMasterDocument(IDocument slave) {
        if (slave instanceof ChildDocument) {
            return ((ChildDocument)slave).getParentDocument();
        }
        return null;
    }

    public boolean isSlaveDocument(IDocument document) {
        return document instanceof ChildDocument;
    }

    protected void fireDocumentEvent(boolean about, DocumentEvent event) {
        try {
            IDocument parent = event.getDocument();
            Position[] children = parent.getPositions(CHILDDOCUMENTS);
            int i = 0;
            while (i < children.length) {
                Position o = children[i];
                if (o instanceof ChildPosition) {
                    ChildPosition pos = (ChildPosition)o;
                    if (about) {
                        pos.fChildDocument.parentDocumentAboutToBeChanged(event);
                    } else {
                        pos.fChildDocument.parentDocumentChanged(event);
                    }
                }
                ++i;
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
    }

    public void documentChanged(DocumentEvent event) {
        this.fireDocumentEvent(false, event);
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
        this.fireDocumentEvent(true, event);
    }

    public void setAutoExpandMode(IDocument slaveDocument, boolean autoExpand) {
        if (slaveDocument instanceof ChildDocument) {
            ((ChildDocument)slaveDocument).setAutoExpandMode(autoExpand);
        }
    }

    static class ChildPosition
    extends Position {
        public IDocument fParentDocument;
        public ChildDocument fChildDocument;

        public ChildPosition(IDocument parentDocument, int offset, int length) {
            super(offset, length);
            this.fParentDocument = parentDocument;
        }

        public boolean overlapsWith(int offset, int length) {
            boolean append;
            boolean bl = append = offset == this.offset + this.length && length == 0;
            return append || super.overlapsWith(offset, length);
        }
    }

    static class ChildPositionUpdater
    extends DefaultPositionUpdater {
        private DocumentEvent fDocumentEvent;

        protected ChildPositionUpdater() {
            super(ChildDocumentManager.CHILDDOCUMENTS);
        }

        protected boolean notDeleted() {
            return true;
        }

        public void update(DocumentEvent event) {
            try {
                this.fDocumentEvent = event;
                super.update(event);
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.fDocumentEvent = null;
                throw throwable;
            }
            Object var2_4 = null;
            this.fDocumentEvent = null;
        }

        protected void adaptToInsert() {
            int myStart = this.fPosition.offset;
            int myEnd = this.fPosition.offset + this.fPosition.length;
            boolean isAutoExpanding = this.isAutoExpanding();
            if (this.fLength != 0 && this.fOffset < myEnd && !isAutoExpanding) {
                super.adaptToInsert();
                return;
            }
            int yoursStart = this.fOffset;
            int yoursEnd = this.fOffset + this.fReplaceLength - 1;
            yoursEnd = Math.max(yoursStart, yoursEnd);
            if (myEnd < yoursStart) {
                if (isAutoExpanding) {
                    this.fPosition.length = yoursEnd - myStart + 1;
                }
                return;
            }
            if (myStart <= yoursStart) {
                this.fPosition.length += this.fReplaceLength;
            } else if (isAutoExpanding) {
                this.fPosition.offset = yoursStart;
                this.fPosition.length += myStart - yoursStart + this.fReplaceLength;
            } else {
                this.fPosition.offset += this.fReplaceLength;
            }
        }

        private boolean isAutoExpanding() {
            if (this.fPosition instanceof ChildPosition) {
                ChildPosition position = (ChildPosition)this.fPosition;
                return position.fChildDocument.isAutoExpandEvent(this.fDocumentEvent);
            }
            return false;
        }
    }

    static class ChildPartitioner
    implements IDocumentPartitioner {
        protected ChildDocument fChildDocument;
        protected IDocument fParentDocument;

        protected ChildPartitioner() {
        }

        public ITypedRegion getPartition(int offset) {
            try {
                return this.fParentDocument.getPartition(offset += this.fChildDocument.getParentDocumentRange().getOffset());
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }

        public ITypedRegion[] computePartitioning(int offset, int length) {
            try {
                return this.fParentDocument.computePartitioning(offset += this.fChildDocument.getParentDocumentRange().getOffset(), length);
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }

        public String getContentType(int offset) {
            try {
                return this.fParentDocument.getContentType(offset += this.fChildDocument.getParentDocumentRange().getOffset());
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }

        public String[] getLegalContentTypes() {
            return this.fParentDocument.getLegalContentTypes();
        }

        public boolean documentChanged(DocumentEvent event) {
            return false;
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void disconnect() {
            this.fChildDocument = null;
            this.fParentDocument = null;
        }

        public void connect(IDocument childDocument) {
            Assert.isTrue(childDocument instanceof ChildDocument);
            this.fChildDocument = (ChildDocument)childDocument;
            this.fParentDocument = this.fChildDocument.getParentDocument();
        }
    }
}

