/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Line;
import org.eclipse.jface.text.Region;

public abstract class AbstractLineTracker
implements ILineTracker {
    private List fLines = new ArrayList();
    private int fTextLength;

    protected AbstractLineTracker() {
    }

    private int findLine(int offset) {
        if (this.fLines.size() == 0) {
            return -1;
        }
        int left = 0;
        int right = this.fLines.size() - 1;
        int mid = 0;
        Line line = null;
        while (left < right) {
            mid = (left + right) / 2;
            line = (Line)this.fLines.get(mid);
            if (offset < line.offset) {
                if (left == mid) {
                    right = left;
                    continue;
                }
                right = mid - 1;
                continue;
            }
            if (offset > line.offset) {
                if (right == mid) {
                    left = right;
                    continue;
                }
                left = mid + 1;
                continue;
            }
            if (offset != line.offset) continue;
            left = right = mid;
        }
        line = (Line)this.fLines.get(left);
        if (line.offset > offset) {
            --left;
        }
        return left;
    }

    private int getNumberOfLines(int startLine, int offset, int length) throws BadLocationException {
        if (length == 0) {
            return 1;
        }
        int target = offset + length;
        Line l = (Line)this.fLines.get(startLine);
        if (l.delimiter == null) {
            return 1;
        }
        if (l.offset + l.length > target) {
            return 1;
        }
        if (l.offset + l.length == target) {
            return 2;
        }
        return this.getLineNumberOfOffset(target) - startLine + 1;
    }

    public int getLineLength(int line) throws BadLocationException {
        int lines = this.fLines.size();
        if (line < 0 || line > lines) {
            throw new BadLocationException();
        }
        if (lines == 0 || lines == line) {
            return 0;
        }
        Line l = (Line)this.fLines.get(line);
        return l.length;
    }

    public int getLineNumberOfOffset(int position) throws BadLocationException {
        if (position > this.fTextLength) {
            throw new BadLocationException();
        }
        if (position == this.fTextLength) {
            int lastLine = this.fLines.size() - 1;
            if (lastLine < 0) {
                return 0;
            }
            Line l = (Line)this.fLines.get(lastLine);
            return l.delimiter != null ? lastLine + 1 : lastLine;
        }
        return this.findLine(position);
    }

    public IRegion getLineInformationOfOffset(int position) throws BadLocationException {
        if (position > this.fTextLength) {
            throw new BadLocationException();
        }
        if (position == this.fTextLength) {
            int size = this.fLines.size();
            if (size == 0) {
                return new Region(0, 0);
            }
            Line l = (Line)this.fLines.get(size - 1);
            return l.delimiter != null ? new Line(this.fTextLength, 0) : new Line(this.fTextLength - l.length, l.length);
        }
        return this.getLineInformation(this.findLine(position));
    }

    public IRegion getLineInformation(int line) throws BadLocationException {
        int lines = this.fLines.size();
        if (line < 0 || line > lines) {
            throw new BadLocationException();
        }
        if (lines == 0) {
            return new Line(0, 0);
        }
        if (line == lines) {
            Line l = (Line)this.fLines.get(line - 1);
            return new Line(l.offset + l.length, 0);
        }
        Line l = (Line)this.fLines.get(line);
        return l.delimiter != null ? new Line(l.offset, l.length - l.delimiter.length()) : l;
    }

    public int getLineOffset(int line) throws BadLocationException {
        int lines = this.fLines.size();
        if (line < 0 || line > lines) {
            throw new BadLocationException();
        }
        if (lines == 0) {
            return 0;
        }
        if (line == lines) {
            Line l = (Line)this.fLines.get(line - 1);
            return l.offset + l.length;
        }
        Line l = (Line)this.fLines.get(line);
        return l.offset;
    }

    public int getNumberOfLines() {
        int lines = this.fLines.size();
        if (lines == 0) {
            return 1;
        }
        Line l = (Line)this.fLines.get(lines - 1);
        return l.delimiter != null ? lines + 1 : lines;
    }

    public int getNumberOfLines(int position, int length) throws BadLocationException {
        if (position < 0 || position + length > this.fTextLength) {
            throw new BadLocationException();
        }
        if (length == 0) {
            return 1;
        }
        return this.getNumberOfLines(this.getLineNumberOfOffset(position), position, length);
    }

    public int computeNumberOfLines(String text) {
        int count = 0;
        int start = 0;
        DelimiterInfo delimiterInfo = this.nextDelimiterInfo(text, start);
        while (delimiterInfo != null && delimiterInfo.delimiterIndex > -1) {
            ++count;
            start = delimiterInfo.delimiterIndex + delimiterInfo.delimiterLength;
            delimiterInfo = this.nextDelimiterInfo(text, start);
        }
        return count;
    }

    protected abstract DelimiterInfo nextDelimiterInfo(String var1, int var2);

    private int createLines(String text, int insertPosition, int offset) {
        int count = 0;
        int start = 0;
        DelimiterInfo delimiterInfo = this.nextDelimiterInfo(text, 0);
        while (delimiterInfo != null && delimiterInfo.delimiterIndex > -1) {
            int index = delimiterInfo.delimiterIndex + (delimiterInfo.delimiterLength - 1);
            if (insertPosition + count >= this.fLines.size()) {
                this.fLines.add(new Line(offset + start, offset + index, delimiterInfo.delimiter));
            } else {
                this.fLines.add(insertPosition + count, new Line(offset + start, offset + index, delimiterInfo.delimiter));
            }
            ++count;
            start = index + 1;
            delimiterInfo = this.nextDelimiterInfo(text, start);
        }
        if (start < text.length()) {
            if (insertPosition + count < this.fLines.size()) {
                Line l = (Line)this.fLines.get(insertPosition + count);
                int delta = text.length() - start;
                l.offset -= delta;
                l.length += delta;
            } else {
                this.fLines.add(new Line(offset + start, offset + text.length() - 1, null));
                ++count;
            }
        }
        return count;
    }

    private int insert(int lineNumber, int offset, String text) throws BadLocationException {
        if (text == null || text.length() == 0) {
            return 0;
        }
        this.fTextLength += text.length();
        int size = this.fLines.size();
        if (size == 0 || lineNumber >= size) {
            return this.createLines(text, size, offset);
        }
        Line line = (Line)this.fLines.get(lineNumber);
        DelimiterInfo delimiterInfo = this.nextDelimiterInfo(text, 0);
        if (delimiterInfo == null || delimiterInfo.delimiterIndex == -1) {
            line.length += text.length();
            return 0;
        }
        int restLength = line.offset + line.length - offset;
        if (restLength > 0) {
            Line lineRest = new Line(offset, restLength);
            lineRest.delimiter = line.delimiter;
            lineRest.offset += text.length();
            this.fLines.add(lineNumber + 1, lineRest);
        }
        line.delimiter = delimiterInfo.delimiter;
        int nextStart = offset + delimiterInfo.delimiterIndex + delimiterInfo.delimiterLength;
        line.length = nextStart - line.offset;
        text = text.substring(delimiterInfo.delimiterIndex + delimiterInfo.delimiterLength);
        return this.createLines(text, lineNumber + 1, nextStart) + 1;
    }

    private boolean remove(int lineNumber, int offset, int length) throws BadLocationException {
        if (length == 0) {
            return false;
        }
        int removedLineEnds = this.getNumberOfLines(lineNumber, offset, length) - 1;
        Line line = (Line)this.fLines.get(lineNumber);
        if (lineNumber == this.fLines.size() - 1 && removedLineEnds > 0) {
            line.length -= length;
            line.delimiter = null;
        } else {
            ++lineNumber;
            int i = 1;
            while (i <= removedLineEnds) {
                if (lineNumber == this.fLines.size()) {
                    line.delimiter = null;
                    break;
                }
                Line line2 = (Line)this.fLines.get(lineNumber);
                line.length += line2.length;
                line.delimiter = line2.delimiter;
                this.fLines.remove(lineNumber);
                ++i;
            }
            line.length -= length;
        }
        this.fTextLength -= length;
        if (line.length == 0) {
            this.fLines.remove(line);
            return true;
        }
        return false;
    }

    private void adaptLineOffsets(int lineNumber, int delta) {
        int size = this.fLines.size();
        int i = lineNumber + 1;
        while (i < size) {
            Line l = (Line)this.fLines.get(i);
            l.offset += delta;
            ++i;
        }
    }

    public void replace(int position, int length, String text) throws BadLocationException {
        int firstLine;
        int insertLineNumber = firstLine = this.getLineNumberOfOffset(position);
        if (this.remove(firstLine, position, length)) {
            --firstLine;
        }
        int lastLine = firstLine + this.insert(insertLineNumber, position, text);
        int delta = -length;
        if (text != null) {
            delta = text.length() + delta;
        }
        if (delta != 0) {
            this.adaptLineOffsets(lastLine, delta);
        }
    }

    public void set(String text) {
        this.fLines.clear();
        if (text != null) {
            this.fTextLength = text.length();
            this.createLines(text, 0, 0);
        }
    }

    public String getLineDelimiter(int line) throws BadLocationException {
        int lines = this.fLines.size();
        if (line < 0 || line > lines) {
            throw new BadLocationException();
        }
        if (lines == 0) {
            return null;
        }
        if (line == lines) {
            return null;
        }
        Line l = (Line)this.fLines.get(line);
        return l.delimiter;
    }

    public abstract String[] getLegalLineDelimiters();

    protected static class DelimiterInfo {
        public int delimiterIndex;
        public int delimiterLength;
        public String delimiter;

        protected DelimiterInfo() {
        }
    }
}

