/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentExtension2;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IDocumentPartitionerExtension;
import org.eclipse.jface.text.IDocumentPartitioningListener;
import org.eclipse.jface.text.IDocumentPartitioningListenerExtension;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextStore;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TypedRegion;

public abstract class AbstractDocument
implements IDocument,
IDocumentExtension,
IDocumentExtension2 {
    private ITextStore fStore;
    private ILineTracker fTracker;
    private IDocumentPartitioner fDocumentPartitioner;
    private IDocumentPartitionerExtension fDocumentPartitionerExtension;
    private List fDocumentListeners;
    private List fPrenotifiedDocumentListeners;
    private List fDocumentPartitioningListeners;
    private Map fPositions;
    private List fPositionUpdaters;
    private List fPostNotificationChanges;
    private int fReentranceCount = 0;
    private int fStoppedCount = 0;
    private boolean fAcceptPostNotificationReplaces = true;
    private int fStoppedListenerNotification = 0;
    private DocumentEvent fDeferredDocumentEvent;
    private boolean fPartitionHasChanged;
    private IRegion fChangedPartition;

    protected AbstractDocument() {
    }

    protected ITextStore getStore() {
        Assert.isNotNull(this.fStore);
        return this.fStore;
    }

    protected ILineTracker getTracker() {
        Assert.isNotNull(this.fTracker);
        return this.fTracker;
    }

    protected List getDocumentListeners() {
        return this.fDocumentListeners;
    }

    protected List getDocumentPartitioningListeners() {
        return this.fDocumentPartitioningListeners;
    }

    protected Map getDocumentManagedPositions() {
        return this.fPositions;
    }

    public IDocumentPartitioner getDocumentPartitioner() {
        return this.fDocumentPartitioner;
    }

    protected void setTextStore(ITextStore store) {
        this.fStore = store;
    }

    protected void setLineTracker(ILineTracker tracker) {
        this.fTracker = tracker;
    }

    public void setDocumentPartitioner(IDocumentPartitioner partitioner) {
        this.fDocumentPartitioner = partitioner;
        if (this.fDocumentPartitioner instanceof IDocumentPartitionerExtension) {
            this.fDocumentPartitionerExtension = (IDocumentPartitionerExtension)((Object)this.fDocumentPartitioner);
        }
        this.fireDocumentPartitioningChanged(new Region(0, this.getLength()));
    }

    protected void completeInitialization() {
        this.fPositions = new HashMap();
        this.fPositionUpdaters = new ArrayList();
        this.fDocumentListeners = new ArrayList();
        this.fPrenotifiedDocumentListeners = new ArrayList();
        this.fDocumentPartitioningListeners = new ArrayList();
        this.addPositionCategory("__dflt_position_category");
        this.addPositionUpdater(new DefaultPositionUpdater("__dflt_position_category"));
    }

    public void addDocumentListener(IDocumentListener listener) {
        Assert.isNotNull(listener);
        if (!this.fDocumentListeners.contains(listener)) {
            this.fDocumentListeners.add(listener);
        }
    }

    public void removeDocumentListener(IDocumentListener listener) {
        Assert.isNotNull(listener);
        this.fDocumentListeners.remove(listener);
    }

    public void addPrenotifiedDocumentListener(IDocumentListener listener) {
        Assert.isNotNull(listener);
        if (!this.fPrenotifiedDocumentListeners.contains(listener)) {
            this.fPrenotifiedDocumentListeners.add(listener);
        }
    }

    public void removePrenotifiedDocumentListener(IDocumentListener listener) {
        Assert.isNotNull(listener);
        this.fPrenotifiedDocumentListeners.remove(listener);
    }

    public void addDocumentPartitioningListener(IDocumentPartitioningListener listener) {
        Assert.isNotNull(listener);
        if (!this.fDocumentPartitioningListeners.contains(listener)) {
            this.fDocumentPartitioningListeners.add(listener);
        }
    }

    public void removeDocumentPartitioningListener(IDocumentPartitioningListener listener) {
        Assert.isNotNull(listener);
        this.fDocumentPartitioningListeners.remove(listener);
    }

    public void addPosition(String category, Position position) throws BadLocationException, BadPositionCategoryException {
        if (position.offset < 0 || position.length < 0 || position.offset + position.length > this.getLength()) {
            throw new BadLocationException();
        }
        if (category == null) {
            throw new BadPositionCategoryException();
        }
        List list = (List)this.fPositions.get(category);
        if (list == null) {
            throw new BadPositionCategoryException();
        }
        list.add(this.computeIndexInPositionList(list, position.offset), position);
    }

    public void addPosition(Position position) throws BadLocationException {
        try {
            this.addPosition("__dflt_position_category", position);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
    }

    public void addPositionCategory(String category) {
        if (category == null) {
            return;
        }
        if (!this.containsPositionCategory(category)) {
            this.fPositions.put(category, new ArrayList());
        }
    }

    public void addPositionUpdater(IPositionUpdater updater) {
        this.insertPositionUpdater(updater, this.fPositionUpdaters.size());
    }

    public boolean containsPosition(String category, int offset, int length) {
        if (category == null) {
            return false;
        }
        List list = (List)this.fPositions.get(category);
        if (list == null) {
            return false;
        }
        int size = list.size();
        if (size == 0) {
            return false;
        }
        int index = this.computeIndexInPositionList(list, offset);
        if (index < size) {
            Position p = (Position)list.get(index);
            while (p != null && p.offset == offset) {
                if (p.length == length) {
                    return true;
                }
                Position position = p = ++index < size ? (Position)list.get(index) : null;
            }
        }
        return false;
    }

    public boolean containsPositionCategory(String category) {
        if (category != null) {
            return this.fPositions.containsKey(category);
        }
        return false;
    }

    protected int computeIndexInPositionList(List positions, int offset) {
        if (positions.size() == 0) {
            return 0;
        }
        int left = 0;
        int right = positions.size() - 1;
        int mid = 0;
        Position p = null;
        while (left < right) {
            mid = (left + right) / 2;
            p = (Position)positions.get(mid);
            if (offset < p.getOffset()) {
                if (left == mid) {
                    right = left;
                    continue;
                }
                right = mid - 1;
                continue;
            }
            if (offset > p.getOffset()) {
                if (right == mid) {
                    left = right;
                    continue;
                }
                left = mid + 1;
                continue;
            }
            if (offset != p.getOffset()) continue;
            left = right = mid;
        }
        int pos = left;
        p = (Position)positions.get(pos);
        if (offset > p.getOffset()) {
            ++pos;
        } else {
            while (--pos >= 0 && offset == (p = (Position)positions.get(pos)).getOffset()) {
            }
            ++pos;
        }
        Assert.isTrue(pos >= 0 && pos <= positions.size());
        return pos;
    }

    public int computeIndexInCategory(String category, int offset) throws BadLocationException, BadPositionCategoryException {
        if (offset < 0 || offset > this.getLength()) {
            throw new BadLocationException();
        }
        List c = (List)this.fPositions.get(category);
        if (c == null) {
            throw new BadPositionCategoryException();
        }
        return this.computeIndexInPositionList(c, offset);
    }

    protected void fireDocumentPartitioningChanged() {
        if (this.fDocumentPartitioningListeners != null && this.fDocumentPartitioningListeners.size() > 0) {
            ArrayList list = new ArrayList(this.fDocumentPartitioningListeners);
            Iterator e = list.iterator();
            while (e.hasNext()) {
                IDocumentPartitioningListener l = (IDocumentPartitioningListener)e.next();
                l.documentPartitioningChanged(this);
            }
        }
    }

    protected void fireDocumentPartitioningChanged(IRegion region) {
        if (this.fDocumentPartitioningListeners != null && this.fDocumentPartitioningListeners.size() > 0) {
            ArrayList list = new ArrayList(this.fDocumentPartitioningListeners);
            Iterator e = list.iterator();
            while (e.hasNext()) {
                IDocumentPartitioningListener l = (IDocumentPartitioningListener)e.next();
                if (l instanceof IDocumentPartitioningListenerExtension) {
                    ((IDocumentPartitioningListenerExtension)((Object)l)).documentPartitioningChanged(this, region);
                    continue;
                }
                l.documentPartitioningChanged(this);
            }
        }
    }

    protected void fireDocumentAboutToBeChanged(DocumentEvent event) {
        IDocumentListener l;
        Iterator e;
        ArrayList list;
        if (this.fReentranceCount == 0) {
            this.flushPostNotificationChanges();
        }
        if (this.fDocumentPartitioner != null) {
            this.fDocumentPartitioner.documentAboutToBeChanged(event);
        }
        if (this.fPrenotifiedDocumentListeners.size() > 0) {
            list = new ArrayList(this.fPrenotifiedDocumentListeners);
            e = list.iterator();
            while (e.hasNext()) {
                l = (IDocumentListener)e.next();
                l.documentAboutToBeChanged(event);
            }
        }
        if (this.fDocumentListeners.size() > 0) {
            list = new ArrayList(this.fDocumentListeners);
            e = list.iterator();
            while (e.hasNext()) {
                l = (IDocumentListener)e.next();
                l.documentAboutToBeChanged(event);
            }
        }
    }

    protected void updateDocumentStructures(DocumentEvent event) {
        this.fPartitionHasChanged = false;
        this.fChangedPartition = null;
        if (this.fDocumentPartitioner != null) {
            if (this.fDocumentPartitionerExtension != null) {
                this.fChangedPartition = this.fDocumentPartitionerExtension.documentChanged2(event);
                this.fPartitionHasChanged = this.fChangedPartition != null;
            } else {
                this.fPartitionHasChanged = this.fDocumentPartitioner.documentChanged(event);
            }
        }
        if (this.fPositions.size() > 0) {
            this.updatePositions(event);
        }
    }

    protected void doFireDocumentChanged(DocumentEvent event) {
        boolean hasChanged = this.fPartitionHasChanged;
        IRegion changedRegion = this.fChangedPartition;
        this.fPartitionHasChanged = false;
        this.fChangedPartition = null;
        this.doFireDocumentChanged(event, hasChanged, changedRegion);
    }

    protected void doFireDocumentChanged(DocumentEvent event, boolean firePartitionChange, IRegion partitionChange) {
        Object var4_4;
        IDocumentListener l;
        Iterator e;
        ArrayList list;
        if (firePartitionChange) {
            this.fireDocumentPartitioningChanged(partitionChange);
        }
        if (this.fPrenotifiedDocumentListeners.size() > 0) {
            list = new ArrayList(this.fPrenotifiedDocumentListeners);
            e = list.iterator();
            while (e.hasNext()) {
                l = (IDocumentListener)e.next();
                l.documentChanged(event);
            }
        }
        if (this.fDocumentListeners.size() > 0) {
            list = new ArrayList(this.fDocumentListeners);
            e = list.iterator();
            while (e.hasNext()) {
                l = (IDocumentListener)e.next();
                l.documentChanged(event);
            }
        }
        ++this.fReentranceCount;
        try {
            if (this.fReentranceCount == 1) {
                this.executePostNotificationChanges();
            }
        }
        catch (Throwable throwable) {
            var4_4 = null;
            --this.fReentranceCount;
            throw throwable;
        }
        var4_4 = null;
        --this.fReentranceCount;
    }

    protected void fireDocumentChanged(DocumentEvent event) {
        this.updateDocumentStructures(event);
        if (this.fStoppedListenerNotification == 0) {
            this.doFireDocumentChanged(event);
        } else {
            this.fDeferredDocumentEvent = event;
        }
    }

    public char getChar(int pos) throws BadLocationException {
        if (pos < 0 || pos >= this.getLength()) {
            throw new BadLocationException();
        }
        return this.getStore().get(pos);
    }

    public String getContentType(int offset) throws BadLocationException {
        if (offset < 0 || offset > this.getLength()) {
            throw new BadLocationException();
        }
        if (this.fDocumentPartitioner == null) {
            return "__dftl_partition_content_type";
        }
        return this.fDocumentPartitioner.getContentType(offset);
    }

    public String[] getLegalContentTypes() {
        if (this.fDocumentPartitioner == null) {
            return new String[]{"__dftl_partition_content_type"};
        }
        return this.fDocumentPartitioner.getLegalContentTypes();
    }

    public int getLength() {
        return this.getStore().getLength();
    }

    public String getLineDelimiter(int line) throws BadLocationException {
        return this.getTracker().getLineDelimiter(line);
    }

    public String[] getLegalLineDelimiters() {
        return this.getTracker().getLegalLineDelimiters();
    }

    public int getLineLength(int line) throws BadLocationException {
        return this.getTracker().getLineLength(line);
    }

    public int getLineOfOffset(int pos) throws BadLocationException {
        return this.getTracker().getLineNumberOfOffset(pos);
    }

    public int getLineOffset(int line) throws BadLocationException {
        return this.getTracker().getLineOffset(line);
    }

    public IRegion getLineInformation(int line) throws BadLocationException {
        return this.getTracker().getLineInformation(line);
    }

    public IRegion getLineInformationOfOffset(int offset) throws BadLocationException {
        return this.getTracker().getLineInformationOfOffset(offset);
    }

    public int getNumberOfLines() {
        return this.getTracker().getNumberOfLines();
    }

    public int getNumberOfLines(int offset, int length) throws BadLocationException {
        return this.getTracker().getNumberOfLines(offset, length);
    }

    public int computeNumberOfLines(String text) {
        return this.getTracker().computeNumberOfLines(text);
    }

    public ITypedRegion getPartition(int offset) throws BadLocationException {
        if (offset < 0 || offset > this.getLength()) {
            throw new BadLocationException();
        }
        if (this.fDocumentPartitioner == null) {
            return new TypedRegion(0, this.getLength(), "__dftl_partition_content_type");
        }
        return this.fDocumentPartitioner.getPartition(offset);
    }

    public ITypedRegion[] computePartitioning(int offset, int length) throws BadLocationException {
        if (offset < 0 || length < 0 || offset + length > this.getLength()) {
            throw new BadLocationException();
        }
        if (this.fDocumentPartitioner == null) {
            return new TypedRegion[]{new TypedRegion(offset, length, "__dftl_partition_content_type")};
        }
        return this.fDocumentPartitioner.computePartitioning(offset, length);
    }

    public Position[] getPositions(String category) throws BadPositionCategoryException {
        if (category == null) {
            throw new BadPositionCategoryException();
        }
        List c = (List)this.fPositions.get(category);
        if (c == null) {
            throw new BadPositionCategoryException();
        }
        Position[] positions = new Position[c.size()];
        c.toArray(positions);
        return positions;
    }

    public String[] getPositionCategories() {
        String[] categories = new String[this.fPositions.size()];
        Iterator keys = this.fPositions.keySet().iterator();
        int i = 0;
        while (i < categories.length) {
            categories[i] = (String)keys.next();
            ++i;
        }
        return categories;
    }

    public IPositionUpdater[] getPositionUpdaters() {
        IPositionUpdater[] updaters = new IPositionUpdater[this.fPositionUpdaters.size()];
        this.fPositionUpdaters.toArray(updaters);
        return updaters;
    }

    public String get() {
        return this.getStore().get(0, this.getLength());
    }

    public String get(int pos, int length) throws BadLocationException {
        int myLength = this.getLength();
        if (pos < 0 || length < 0 || pos + length > myLength) {
            throw new BadLocationException();
        }
        return this.getStore().get(pos, length);
    }

    public void insertPositionUpdater(IPositionUpdater updater, int index) {
        int i = this.fPositionUpdaters.size() - 1;
        while (i >= 0) {
            if (this.fPositionUpdaters.get(i) == updater) {
                return;
            }
            --i;
        }
        if (index == this.fPositionUpdaters.size()) {
            this.fPositionUpdaters.add(updater);
        } else {
            this.fPositionUpdaters.add(index, updater);
        }
    }

    public void removePosition(String category, Position position) throws BadPositionCategoryException {
        if (position == null) {
            return;
        }
        if (category == null) {
            throw new BadPositionCategoryException();
        }
        List c = (List)this.fPositions.get(category);
        if (c == null) {
            throw new BadPositionCategoryException();
        }
        int size = c.size();
        int i = 0;
        while (i < size) {
            if (position == c.get(i)) {
                c.remove(i);
                return;
            }
            ++i;
        }
    }

    public void removePosition(Position position) {
        try {
            this.removePosition("__dflt_position_category", position);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
    }

    public void removePositionCategory(String category) throws BadPositionCategoryException {
        if (category == null) {
            return;
        }
        if (!this.containsPositionCategory(category)) {
            throw new BadPositionCategoryException();
        }
        this.fPositions.remove(category);
    }

    public void removePositionUpdater(IPositionUpdater updater) {
        int i = this.fPositionUpdaters.size() - 1;
        while (i >= 0) {
            if (this.fPositionUpdaters.get(i) == updater) {
                this.fPositionUpdaters.remove(i);
                return;
            }
            --i;
        }
    }

    public void replace(int pos, int length, String text) throws BadLocationException {
        if (pos < 0 || length < 0 || pos + length > this.getLength()) {
            throw new BadLocationException();
        }
        DocumentEvent e = new DocumentEvent(this, pos, length, text);
        this.fireDocumentAboutToBeChanged(e);
        this.getStore().replace(pos, length, text);
        this.getTracker().replace(pos, length, text);
        this.fireDocumentChanged(e);
    }

    public void set(String text) {
        int length = this.getStore().getLength();
        DocumentEvent e = new DocumentEvent(this, 0, length, text);
        this.fireDocumentAboutToBeChanged(e);
        this.getStore().set(text);
        this.getTracker().set(text);
        this.fireDocumentChanged(e);
    }

    protected void updatePositions(DocumentEvent event) {
        ArrayList list = new ArrayList(this.fPositionUpdaters);
        Iterator e = list.iterator();
        while (e.hasNext()) {
            IPositionUpdater u = (IPositionUpdater)e.next();
            u.update(event);
        }
    }

    public int search(int startPosition, String findString, boolean forwardSearch, boolean caseSensitive, boolean wholeWord) throws BadLocationException {
        if (findString == null || findString.length() == 0) {
            return -1;
        }
        ITextStore store = this.getStore();
        if (startPosition < -1 || startPosition > store.getLength()) {
            throw new BadLocationException();
        }
        if (!caseSensitive) {
            findString = findString.toLowerCase();
        }
        char[] fs = new char[findString.length()];
        findString.getChars(0, fs.length, fs, 0);
        if (forwardSearch) {
            if (startPosition == -1) {
                startPosition = 0;
            }
            int end = this.getLength();
            while (startPosition < end) {
                int pos = AbstractDocument.indexOf(store, fs, startPosition, caseSensitive);
                if (!wholeWord || pos == -1 || AbstractDocument.isWholeWord(store, pos, pos + fs.length)) {
                    return pos;
                }
                startPosition = pos + 1;
            }
        } else {
            if (startPosition == -1) {
                startPosition = this.getLength();
            }
            while (startPosition >= 0) {
                int pos = AbstractDocument.lastIndexOf(store, fs, startPosition, caseSensitive);
                if (!wholeWord || pos == -1 || AbstractDocument.isWholeWord(store, pos, pos + fs.length)) {
                    return pos;
                }
                startPosition = pos - 1;
            }
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    private static int indexOf(ITextStore store, char[] str, int fromIndex, boolean caseSensitive) {
        block9: {
            count = store.getLength();
            if (fromIndex >= count) {
                return -1;
            }
            if (fromIndex < 0) {
                fromIndex = 0;
            }
            if ((strLen = str.length) == 0) {
                return fromIndex;
            }
            first = str[0];
            i = fromIndex;
            max = count - strLen;
lbl11:
            // 2 sources

            block0: while (true) {
                block10: {
                    if (!caseSensitive) ** GOTO lbl18
                    while (i <= max && store.get(i) != first) {
                        ++i;
                    }
                    break block10;
lbl-1000:
                    // 1 sources

                    {
                        ++i;
lbl18:
                        // 2 sources

                        ** while (i <= max && Character.toLowerCase((char)store.get((int)i)) != first)
                    }
                }
                if (i > max) {
                    return -1;
                }
                j = i + 1;
                end = j + strLen - 1;
                k = 1;
                if (!caseSensitive) ** GOTO lbl34
                while (j < end) {
                    if (store.get(j++) == str[k++]) continue;
                    ++i;
                    continue block0;
                }
                break block9;
                break;
            }
lbl-1000:
            // 1 sources

            {
                if (Character.toLowerCase(store.get(j++)) == str[k++]) continue;
                ++i;
                ** continue;
lbl34:
                // 2 sources

                ** while (j < end)
            }
        }
        return i;
    }

    /*
     * Unable to fully structure code
     */
    private static int lastIndexOf(ITextStore store, char[] str, int fromIndex, boolean caseSensitive) {
        block9: {
            if (fromIndex < 0) {
                return -1;
            }
            count = store.getLength();
            rightIndex = count - (strLen = str.length);
            if (fromIndex > rightIndex) {
                fromIndex = rightIndex;
            }
            if (strLen == 0) {
                return fromIndex;
            }
            strLastIndex = strLen - 1;
            strLastChar = str[strLastIndex];
            min = strLen - 1;
            i = min + fromIndex;
lbl13:
            // 2 sources

            block0: while (true) {
                block10: {
                    if (!caseSensitive) ** GOTO lbl20
                    while (i >= min && store.get(i) != strLastChar) {
                        --i;
                    }
                    break block10;
lbl-1000:
                    // 1 sources

                    {
                        --i;
lbl20:
                        // 2 sources

                        ** while (i >= min && Character.toLowerCase((char)store.get((int)i)) != strLastChar)
                    }
                }
                if (i < min) {
                    return -1;
                }
                j = i - 1;
                start = j - (strLen - 1);
                k = strLastIndex - 1;
                if (!caseSensitive) ** GOTO lbl36
                while (j > start) {
                    if (store.get(j--) == str[k--]) continue;
                    --i;
                    continue block0;
                }
                break block9;
                break;
            }
lbl-1000:
            // 1 sources

            {
                if (Character.toLowerCase(store.get(j--)) == str[k--]) continue;
                --i;
                ** continue;
lbl36:
                // 2 sources

                ** while (j > start)
            }
        }
        return start + 1;
    }

    private static boolean isWholeWord(ITextStore store, int from, int to) {
        char ch;
        if (from > 0 && (Character.isLetterOrDigit(ch = store.get(from - 1)) || ch == '_')) {
            return false;
        }
        return to >= store.getLength() || !Character.isLetterOrDigit(ch = store.get(to)) && ch != '_';
    }

    private void flushPostNotificationChanges() {
        if (this.fPostNotificationChanges != null) {
            this.fPostNotificationChanges.clear();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void executePostNotificationChanges() {
        if (this.fStoppedCount <= 0) ** GOTO lbl10
        return;
lbl-1000:
        // 1 sources

        {
            changes = this.fPostNotificationChanges;
            this.fPostNotificationChanges = null;
            e = changes.iterator();
            while (e.hasNext()) {
                replace = (RegisteredReplace)e.next();
                replace.fReplace.perform(this, replace.fOwner);
            }
lbl10:
            // 2 sources

            ** while (this.fPostNotificationChanges != null)
        }
lbl11:
        // 1 sources

    }

    public void acceptPostNotificationReplaces() {
        this.fAcceptPostNotificationReplaces = true;
    }

    public void ignorePostNotificationReplaces() {
        this.fAcceptPostNotificationReplaces = false;
    }

    public void registerPostNotificationReplace(IDocumentListener owner, IDocumentExtension.IReplace replace) {
        if (this.fAcceptPostNotificationReplaces) {
            if (this.fPostNotificationChanges == null) {
                this.fPostNotificationChanges = new ArrayList(1);
            }
            this.fPostNotificationChanges.add(new RegisteredReplace(owner, replace));
        }
    }

    public void stopPostNotificationProcessing() {
        ++this.fStoppedCount;
    }

    public void resumePostNotificationProcessing() {
        --this.fStoppedCount;
        if (this.fStoppedCount == 0 && this.fReentranceCount == 0) {
            this.executePostNotificationChanges();
        }
    }

    public void startSequentialRewrite(boolean normalized) {
    }

    public void stopSequentialRewrite() {
    }

    public void resumeListenerNotification() {
        --this.fStoppedListenerNotification;
        if (this.fStoppedListenerNotification == 0) {
            this.resumeDocumentListenerNotification();
        }
    }

    public void stopListenerNotification() {
        ++this.fStoppedListenerNotification;
    }

    private void resumeDocumentListenerNotification() {
        if (this.fDeferredDocumentEvent != null) {
            DocumentEvent event = this.fDeferredDocumentEvent;
            this.fDeferredDocumentEvent = null;
            this.doFireDocumentChanged(event);
        }
    }

    private static class RegisteredReplace {
        IDocumentListener fOwner;
        IDocumentExtension.IReplace fReplace;

        RegisteredReplace(IDocumentListener owner, IDocumentExtension.IReplace replace) {
            this.fOwner = owner;
            this.fReplace = replace;
        }
    }
}

