/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.core.besrv.principal;

import com.sap.caf.core.besrv.principal.Principal;
import com.sap.caf.rt.bol.EntityServiceBase;
import com.sap.caf.rt.bol.IBusinessObject;
import com.sap.caf.rt.exception.CAFPermissionException;
import com.sap.caf.rt.exception.ServiceException;
import com.sap.caf.rt.security.acl.impl.CAFPermission;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.security.api.IPrincipal;
import com.sap.security.api.IPrincipalFactory;
import com.sap.security.api.IUser;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.tc.logging.Location;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalObject;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

public class PrincipalServiceBean
extends EntityServiceBase
implements SessionBean {
    private static final String APPLICATION = (class$com$sap$caf$core$besrv$principal$PrincipalServiceBean == null ? (class$com$sap$caf$core$besrv$principal$PrincipalServiceBean = PrincipalServiceBean.class$("com.sap.caf.core.besrv.principal.PrincipalServiceBean")) : class$com$sap$caf$core$besrv$principal$PrincipalServiceBean).getName();
    private static final Location logger = Location.getLocation((String)APPLICATION);
    private static final String jARMReqPrefix = "CAF:CORE:security:";
    private static final String jARMRequest = "CAF:CORE:security:" + APPLICATION;
    private static final String UNDEFINED_VALUE = "<undefined>";
    private static final String[] STRING_ARRAY_TYPE = new String[0];
    static /* synthetic */ Class class$com$sap$caf$core$besrv$principal$PrincipalServiceBean;

    public Principal read(String principalID) throws ServiceException {
        String method = jARMRequest + ":read(String principalID)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        Principal principal = null;
        try {
            IPrincipalFactory principalFactory = UMFactory.getPrincipalFactory();
            IPrincipal iPrincipal = principalFactory.getPrincipal(principalID);
            principal = new Principal();
            principal.setPrincipalID(principalID);
            principal.setPrincipalName(iPrincipal.getDisplayName());
            principal.setPrincipalType(principalFactory.getPrincipalType(principalID));
            String[] description = iPrincipal.getAttribute("com.sap.security.core.usermanagement", "description");
            if (description != null && description.length > 0) {
                principal.setDescription(description[0]);
            }
            if (iPrincipal instanceof IUser) {
                principal.setEmail(((IUser)iPrincipal).getEmail());
            } else {
                principal.setEmail(UNDEFINED_VALUE);
            }
        }
        catch (UMException e) {
            CAFPublicLogger.traceThrowable((int)500, (Location)logger, (String)method, (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        }
        return principal;
    }

    protected SessionContext getSessionContext() {
        return this.sessionContext;
    }

    public void ejbRemove() {
    }

    public void ejbCreate() throws CreateException {
    }

    protected static final void checkParameter(String parameterValue, String name) throws ServiceException {
        if (parameterValue == null || parameterValue.length() == 0) {
            throw new ServiceException((Throwable)new Exception("Parameter " + name + " is missed"));
        }
    }

    protected String getKey(String pk) {
        return pk == null || pk.length() <= 2 ? pk : pk.substring(1, pk.length() - 1);
    }

    protected String getCurrentUserID() {
        String method = jARMRequest + ":getCurrentUserID()";
        String loginUserID = null;
        try {
            String callerName = this.getSessionContext().getCallerPrincipal().getName();
            if (callerName != null) {
                IUser user = UMFactory.getUserFactory().getUserByLogonID(callerName);
                loginUserID = user.getUniqueID();
            }
        }
        catch (UMException e) {
            CAFPublicLogger.traceThrowable((int)500, (Location)logger, (String)method, (Throwable)e);
        }
        return loginUserID;
    }

    public static void release(EJBLocalObject object) {
        String method = jARMRequest + ":release(EJBLocalObject object)";
        if (object != null) {
            try {
                object.remove();
            }
            catch (EJBException e) {
                CAFPublicLogger.traceThrowable((int)500, (Location)logger, (String)method, (Throwable)e);
            }
            catch (RemoveException e) {
                CAFPublicLogger.traceThrowable((int)500, (Location)logger, (String)method, (Throwable)e);
            }
        }
    }

    public String getUser() {
        String user = null;
        String method = jARMRequest + ":getUser()";
        try {
            user = null != this.sessionContext ? this.sessionContext.getCallerPrincipal().getName() : null;
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowable((int)500, (Location)logger, (String)method, (Throwable)e);
        }
        return user;
    }

    public String getApplicationName() {
        return APPLICATION;
    }

    public boolean checkPermission(String permission, IBusinessObject object, String user, String objectName) {
        try {
            if (!CAFPermission.checkAclPermission((Object)object, (String)user, (String)permission, (String)objectName)) {
                return false;
            }
        }
        catch (CAFPermissionException e) {
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

