/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.core.appsrv.doccontent;

import com.sap.caf.core.CoreServices;
import com.sap.caf.core.appsrv.datatypes.DocumentLockInfo;
import com.sap.caf.core.appsrv.datatypes.IDocumentLockInfo;
import com.sap.caf.core.besrv.document.Document;
import com.sap.caf.core.besrv.document.DocumentPK;
import com.sap.caf.core.besrv.document.DocumentServiceLocal;
import com.sap.caf.km.da.DocumentDataAccessService;
import com.sap.caf.km.da.KMDataAccessHelper;
import com.sap.caf.km.da.RidUtils;
import com.sap.caf.km.ejb.data.document.DocumentProxyEJBLocal;
import com.sap.caf.km.ejb.data.util.NodeContent;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.rt.bol.IDependentObject;
import com.sap.caf.rt.bol.context.CAFContext;
import com.sap.caf.rt.bol.context.CAFProperties;
import com.sap.caf.rt.exception.CAFBaseException;
import com.sap.caf.rt.exception.CAFCreateException;
import com.sap.caf.rt.exception.CAFFindException;
import com.sap.caf.rt.exception.CAFRetrieveException;
import com.sap.caf.rt.exception.CAFUpdateException;
import com.sap.caf.rt.exception.DataAccessException;
import com.sap.caf.rt.exception.ServiceException;
import com.sap.caf.rt.metamodel.MetaModel;
import com.sap.caf.rt.srv.ApplicationServiceBean;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;
import com.sap.tc.webdynpro.services.sal.url.api.WDWebResourceType;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import javax.activation.MimetypesFileTypeMap;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionContext;

public class DocContentBean
extends ApplicationServiceBean {
    protected String _objectName = "sap.com/caf.core/DocContent";
    private static final String APPLICATION = (class$com$sap$caf$core$appsrv$doccontent$DocContentBean == null ? (class$com$sap$caf$core$appsrv$doccontent$DocContentBean = DocContentBean.class$("com.sap.caf.core.appsrv.doccontent.DocContentBean")) : class$com$sap$caf$core$appsrv$doccontent$DocContentBean).getName();
    private static final String jARMReqPrefix = "XAP:BO:";
    private static final String JARM_REQUEST = "XAP:BO:" + APPLICATION;
    private static final Location location = Location.getLocation((String)APPLICATION);
    private static final String DEF_MIME_TYPE = "application/octet-stream";
    private static final String PARAM_ROOT_FOLDER = "KM_TMP_REPOSITORY_FOLDER";
    private static final char RID_SEPARATOR = '/';
    private static final MimetypesFileTypeMap s_mimeTypes = new MimetypesFileTypeMap();
    private String m_rootFolder;
    private MetaModel mmrProxy;
    static /* synthetic */ Class class$com$sap$caf$core$appsrv$doccontent$DocContentBean;
    static /* synthetic */ Class class$com$sap$caf$core$besrv$document$Document;

    public void ejbCreate() throws CreateException {
    }

    public void ejbActivate() throws EJBException, RemoteException {
    }

    public void ejbPassivate() throws EJBException, RemoteException {
    }

    public void ejbRemove() throws EJBException, RemoteException {
        this.mmrProxy = null;
    }

    public void setSessionContext(SessionContext arg0) throws EJBException, RemoteException {
        this.sessionContext = arg0;
    }

    public String copyDocument(String srcRid, String dstBOName, String dstBOGuid) throws CAFUpdateException {
        String method = JARM_REQUEST + ":copyDocument(String, String, String)";
        String user = this.getUser();
        CAFPublicLogger.entering((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (Object[])new Object[]{srcRid, dstBOName, dstBOGuid}, (int)1);
        try {
            String string = KMDataAccessHelper.getDocumentProxyService().copyBODocument(dstBOName, dstBOGuid, srcRid);
            return string;
        }
        catch (Exception e) {
            location.throwing(method, (Throwable)e);
            throw new CAFUpdateException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
        }
    }

    public String uploadDocument(String key, byte[] content) throws CAFCreateException {
        String method = JARM_REQUEST + ":uploadDocument(String, byte[])";
        String user = this.getUser();
        CAFPublicLogger.entering((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (Object[])new Object[]{key, content}, (int)1);
        try {
            DocumentDataAccessService service = DocumentDataAccessService.getInstance();
            Document doc = (Document)service.load((Object)new DocumentPK(key), class$com$sap$caf$core$besrv$document$Document == null ? (class$com$sap$caf$core$besrv$document$Document = DocContentBean.class$("com.sap.caf.core.besrv.document.Document")) : class$com$sap$caf$core$besrv$document$Document);
            if (content == null) {
                content = new byte[]{};
            }
            KMDataAccessHelper.getDocumentProxyService().saveDocumentContent(doc.getDocumentId(), doc.getParentFolder(), (long)content.length, null, null, content);
            String string = doc.getKey();
            return string;
        }
        catch (Exception e) {
            location.throwing(method, (Throwable)e);
            throw new CAFCreateException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
        }
    }

    public String uploadExtLink(String key, String url) throws CAFCreateException {
        String method = JARM_REQUEST + ":uploadExtLink(String, String)";
        String user = this.getUser();
        CAFPublicLogger.entering((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (Object[])new Object[]{key, url}, (int)1);
        try {
            Document doc = (Document)DocumentDataAccessService.getInstance().load((Object)new DocumentPK(key), class$com$sap$caf$core$besrv$document$Document == null ? (class$com$sap$caf$core$besrv$document$Document = DocContentBean.class$("com.sap.caf.core.besrv.document.Document")) : class$com$sap$caf$core$besrv$document$Document);
            doc.setLink(url);
            DocumentDataAccessService.getInstance().store((IDependentObject)doc);
            String string = doc.getKey();
            return string;
        }
        catch (Exception e) {
            location.throwing(method, (Throwable)e);
            throw new CAFCreateException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
        }
    }

    public boolean isAttached(String rid) throws CAFBaseException {
        String method = JARM_REQUEST + ":isAttached(String)";
        String user = this.getUser();
        CAFPublicLogger.entering((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (Object[])new Object[]{rid}, (int)1);
        try {
            this.readProperties();
            boolean bl = rid.startsWith(this.m_rootFolder);
            return bl;
        }
        catch (CAFBaseException e) {
            location.throwing(method, (Throwable)e);
            throw new CAFFindException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
        }
    }

    public String addRelatedObjectRid(String documentKey, String boName, String boGuid, String boRid) throws CAFUpdateException {
        String method = JARM_REQUEST + "addRelatedObjectRid(String, String, String, String)";
        String user = this.getUser();
        CAFPublicLogger.entering((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (Object[])new Object[]{documentKey, boName, boGuid, boRid}, (int)1);
        try {
            DocumentServiceLocal documentService = CoreServices.getDocumentService();
            Collection result = documentService.findByDocumentKey(documentKey);
            Document doc = (Document)result.iterator().next();
            String sOldRid = doc.getRid();
            ArrayList<String> docRids = new ArrayList<String>(1);
            docRids.add(sOldRid);
            Collection newDocRids = KMDataAccessHelper.getDocumentProxyService().copyAttachedKMDocuments(boName, boGuid, docRids);
            String newDocRid = (String)newDocRids.iterator().next();
            doc.setParentFolder(RidUtils.getPath((String)newDocRid));
            doc.setDocumentId(RidUtils.getName((String)newDocRid));
            DocumentDataAccessService.getInstance().store((IDependentObject)doc);
            result = documentService.findByDocumentKey(documentKey);
            doc = (Document)result.iterator().next();
            doc.addRelatedObjectRids(this.createRid(boName, boGuid));
            documentService.update(doc);
            if (!newDocRid.equals(sOldRid)) {
                try {
                    KMDataAccessHelper.getDocumentProxyService().deleteDocument(RidUtils.getName((String)sOldRid), RidUtils.getPath((String)sOldRid));
                }
                catch (Throwable e) {
                    location.throwing(method, e);
                }
            }
            String string = doc.getKey();
            return string;
        }
        catch (Exception e) {
            location.throwing(method, (Throwable)e);
            throw new CAFUpdateException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
        }
    }

    public void removeRelatedObjectRid(String documentKey, String boName, String boInstanceGuid) throws CAFUpdateException {
        String method = JARM_REQUEST + ":removeRelatedObjectRid(String, String, String)";
        String user = this.getUser();
        CAFPublicLogger.entering((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (Object[])new Object[]{documentKey, boName, boInstanceGuid}, (int)1);
        try {
            String docRepository;
            String rootBORid;
            DocumentServiceLocal documentService = CoreServices.getDocumentService();
            Collection result = documentService.findByDocumentKey(documentKey);
            Document doc = (Document)result.iterator().next();
            doc.removeRelatedObjectRids(this.createRid(boName, boInstanceGuid));
            documentService.update(doc);
            Collection relatedObjects = doc.getRelatedObjectRids();
            if (relatedObjects.isEmpty() && (rootBORid = RidUtils.getBORootFolder((String)(docRepository = CAFContext.KM_TMP_REPOSITORY_FOLDER), (String)documentKey)) != null) {
                DocumentDataAccessService.getInstance().remove((IDependentObject)doc);
                KMDataAccessHelper.getFolderProxyService().deleteEmptyFolders(RidUtils.getName((String)rootBORid), RidUtils.getPath((String)rootBORid));
            }
        }
        catch (Exception e) {
            location.throwing(method, (Throwable)e);
            throw new CAFUpdateException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
        }
    }

    public String relateDocument(String srcRid, String dstBOName, String dstBOGuid) throws CAFUpdateException {
        String method = JARM_REQUEST + ":relateDocument(String, String, String)";
        String user = this.getUser();
        CAFPublicLogger.entering((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (Object[])new Object[]{srcRid, dstBOName, dstBOGuid}, (int)1);
        try {
            String string = KMDataAccessHelper.getDocumentProxyService().relateKMDocument(dstBOName, dstBOGuid, srcRid);
            return string;
        }
        catch (Exception e) {
            location.throwing(method, (Throwable)e);
            throw new CAFUpdateException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
        }
    }

    public byte[] readDocumentContent(String documentKey) throws CAFRetrieveException {
        String method = JARM_REQUEST + ":readDocumentContent(String)";
        String user = this.getUser();
        CAFPublicLogger.entering((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (Object[])new Object[]{documentKey}, (int)1);
        try {
            DocumentDataAccessService service = DocumentDataAccessService.getInstance();
            Document doc = (Document)service.load((Object)new DocumentPK(documentKey), class$com$sap$caf$core$besrv$document$Document == null ? (class$com$sap$caf$core$besrv$document$Document = DocContentBean.class$("com.sap.caf.core.besrv.document.Document")) : class$com$sap$caf$core$besrv$document$Document);
            NodeContent data = KMDataAccessHelper.getDocumentProxyService().readDocumentContent(doc.getDocumentId(), doc.getParentFolder());
            byte[] byArray = data.getContent();
            return byArray;
        }
        catch (Exception e) {
            location.throwing(method, (Throwable)e);
            throw new CAFRetrieveException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
        }
    }

    public boolean isDocumentLocked(String rid) throws ServiceException {
        String method = JARM_REQUEST + ":isDocumentLocked(String)";
        String user = this.getUser();
        CAFPublicLogger.entering((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (Object[])new Object[]{rid}, (int)1);
        try {
            boolean bl = KMDataAccessHelper.getDocumentProxyService().isDocumentLocked(rid);
            return bl;
        }
        catch (Exception e) {
            location.throwing((Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
        }
    }

    public IDocumentLockInfo getLockInfo(String rid) throws ServiceException {
        String method = JARM_REQUEST + ":getLockInfo(String)";
        String user = this.getUser();
        CAFPublicLogger.entering((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (Object[])new Object[]{rid}, (int)1);
        try {
            DocumentProxyEJBLocal docProxy = KMDataAccessHelper.getDocumentProxyService();
            String lockOwnwer = docProxy.getLockOwner(rid);
            boolean allowUnlock = docProxy.authorizationCheck(rid);
            DocumentLockInfo documentLockInfo = new DocumentLockInfo(lockOwnwer, allowUnlock);
            return documentLockInfo;
        }
        catch (Exception e) {
            location.throwing((Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
        }
    }

    public boolean unLockDocument(String rid) throws ServiceException {
        String method = JARM_REQUEST + ":unLockDocument(String)";
        String user = this.getUser();
        CAFPublicLogger.entering((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (Object[])new Object[]{rid}, (int)1);
        try {
            boolean bl = KMDataAccessHelper.getDocumentProxyService().unlockDocument(rid);
            return bl;
        }
        catch (Exception e) {
            location.throwing((Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
        }
    }

    public void disableDocumentVersioning(String rid) throws ServiceException {
        String method = JARM_REQUEST + ":disableDocumentVersioning(String)";
        String user = this.getUser();
        CAFPublicLogger.entering((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (Object[])new Object[]{rid}, (int)1);
        try {
            KMDataAccessHelper.getDocumentProxyService().disableDocumentVersioning(rid);
        }
        catch (Exception e) {
            location.throwing((Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
        }
    }

    public void enableDocumentVersioning(String rid) throws ServiceException {
        String method = JARM_REQUEST + ":enableDocumentVersioning(String)";
        String user = this.getUser();
        CAFPublicLogger.entering((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (Object[])new Object[]{rid}, (int)1);
        try {
            KMDataAccessHelper.getDocumentProxyService().enableDocumentVersioning(rid);
        }
        catch (Exception e) {
            location.throwing((Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
        }
    }

    public boolean isDocumentVersioned(String rid) throws ServiceException {
        String method = JARM_REQUEST + ":isDocumentVersioned(String)";
        String user = this.getUser();
        CAFPublicLogger.entering((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (Object[])new Object[]{rid}, (int)1);
        try {
            boolean bl = KMDataAccessHelper.getDocumentProxyService().isDocumentVersioned(rid);
            return bl;
        }
        catch (Exception e) {
            location.throwing((Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
        }
    }

    public String[] getVersionHistory(String rid) throws ServiceException {
        String method = JARM_REQUEST + ":getVersionHistory(String)";
        String user = this.getUser();
        CAFPublicLogger.entering((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (Object[])new Object[]{rid}, (int)1);
        try {
            String[] stringArray = KMDataAccessHelper.getDocumentProxyService().getVersionHistory(rid);
            return stringArray;
        }
        catch (Exception e) {
            location.throwing((Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
        }
    }

    public void setAsCurrentVersion(String historyRid, String rid) throws ServiceException {
        String method = JARM_REQUEST + ":setAsCurrentVersion(String)";
        String user = this.getUser();
        CAFPublicLogger.entering((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (Object[])new Object[]{rid}, (int)1);
        try {
            KMDataAccessHelper.getDocumentProxyService().setAsCurrentVersion(historyRid, rid);
        }
        catch (Exception e) {
            location.throwing((Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
        }
    }

    public void deleteVersion(String historyRid) throws ServiceException {
        String method = JARM_REQUEST + ":deleteVersion(String)";
        String user = this.getUser();
        CAFPublicLogger.entering((String)this.getUser(), (String)JARM_REQUEST, (String)method, (Location)location, (Object[])new Object[]{historyRid}, (int)1);
        try {
            KMDataAccessHelper.getDocumentProxyService().deleteVersion(historyRid);
        }
        catch (Exception e) {
            location.throwing((Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
        }
    }

    public String getCurrentVersion(String rid) throws ServiceException {
        String method = JARM_REQUEST + ":getCurrentVersion(String)";
        String user = this.getUser();
        CAFPublicLogger.entering((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (Object[])new Object[]{rid}, (int)1);
        try {
            String string = KMDataAccessHelper.getDocumentProxyService().getCurrentVersion(rid);
            return string;
        }
        catch (Exception e) {
            location.throwing((Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
        }
    }

    private void readProperties() throws DataAccessException {
        CAFProperties properties = new CAFProperties();
        properties.loadApplicationProperties();
        this.m_rootFolder = properties.getProperty(PARAM_ROOT_FOLDER);
    }

    private String[] normalizePathname(String folderPath, String filePathname) throws Exception {
        if (folderPath == null || filePathname == null) {
            throw new Exception("Method parameters can not be null!");
        }
        int i = filePathname.lastIndexOf(47);
        if (i > 0) {
            folderPath = folderPath + '/' + filePathname.substring(0, i);
            filePathname = filePathname.substring(i + 1);
        }
        return new String[]{folderPath, filePathname};
    }

    private String getMimeType(String sFileName) {
        int i = sFileName.lastIndexOf(46);
        if (i < 0) {
            return DEF_MIME_TYPE;
        }
        String sFileExt = sFileName.substring(i + 1);
        if (sFileExt.length() == 0) {
            return DEF_MIME_TYPE;
        }
        WDWebResourceType wdMimeType = WDWebResourceType.getWebResourceTypeForFileExtentsion((String)sFileExt);
        String sMimeType = wdMimeType != null ? wdMimeType.getHtmlMime() : s_mimeTypes.getContentType(sFileName);
        return sMimeType != null ? sMimeType : DEF_MIME_TYPE;
    }

    private String createRid(String boName, String boInstanceGuid) throws DataAccessException {
        if (this.mmrProxy == null) {
            this.mmrProxy = new MetaModel();
        }
        DataObject obj = this.mmrProxy.getDataObject(boName);
        return CAFContext.KM_REPOSITORY + "/" + obj.getObjectId() + "/" + boInstanceGuid.substring(0, 2) + "/" + boInstanceGuid.substring(0, 4) + "/r" + boInstanceGuid;
    }

    private String getUser() {
        return this.sessionContext.getCallerPrincipal().getName();
    }

    public Object execute(String operationName, ArrayList parameters) throws ServiceException {
        String method = "execute(String, ArrayList)";
        String user = this.sessionContext.getCallerPrincipal().getName();
        Object result = null;
        CAFPublicLogger.entering((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (Object[])new Object[]{operationName, parameters}, (int)1);
        if (operationName == null) {
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location);
            throw new ServiceException("APPSRV_NULL_OPERATION_ERROR");
        }
        try {
            try {
                if (!"".equals(operationName)) {
                    throw new ServiceException("Operation not defined");
                }
                Object var8_6 = null;
            }
            catch (Exception e) {
                CAFPublicLogger.traceThrowableT((int)100, (Location)location, (String)method, (String)("Error in " + method), (Throwable)e);
                location.throwing(method, (Throwable)e);
                throw new ServiceException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (Object)new Object[]{result}, (int)1);
            throw throwable;
        }
        CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (Object)new Object[]{result}, (int)1);
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

