/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.core.appsrv.currencyconversion;

import com.sap.caf.core.appsrv.datatypes.Amount;
import com.sap.caf.core.besrv.exchangerate.ExchangeRate;
import com.sap.caf.core.besrv.exchangerate.ExchangeRateServiceLocal;
import com.sap.caf.core.besrv.exchangerate.ExchangeRateServiceLocalHome;
import com.sap.caf.core.utils.HomeFactory;
import com.sap.caf.rt.bol.util.QueryFilter;
import com.sap.caf.rt.exception.CAFFindException;
import com.sap.caf.rt.exception.CAFPermissionException;
import com.sap.caf.rt.exception.ServiceException;
import com.sap.caf.rt.security.acl.impl.CAFPermission;
import com.sap.caf.rt.security.srv.ServicePermission;
import com.sap.caf.rt.srv.ApplicationServiceBean;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import javax.ejb.CreateException;
import javax.ejb.SessionContext;

public class CurrencyConversionBean
extends ApplicationServiceBean {
    public static final String PROVIDER = "sap.com";
    public static final String APPLICATION = "caf.core";
    public static final String APP_SRV_NAME = "CurrencyConversion";
    public static final String OBJECT_NAME = "sap.com/caf.core/CurrencyConversion";
    public static final String JARM_REQUEST = "XAP:APPSERV:sap.com/caf.core/CurrencyConversion";
    private static final Location location = Location.getLocation((Class)(class$com$sap$caf$core$appsrv$currencyconversion$CurrencyConversionBean == null ? (class$com$sap$caf$core$appsrv$currencyconversion$CurrencyConversionBean = CurrencyConversionBean.class$("com.sap.caf.core.appsrv.currencyconversion.CurrencyConversionBean")) : class$com$sap$caf$core$appsrv$currencyconversion$CurrencyConversionBean));
    static /* synthetic */ Class class$com$sap$caf$core$appsrv$currencyconversion$CurrencyConversionBean;

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void setSessionContext(SessionContext context) {
        this.sessionContext = context;
    }

    public void ejbCreate() throws CreateException {
        this.objectGuid = "1B56A7D1-3369-9A21-2F3D-D448B37E";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList convertCurrency(String rateType, String currencyFrom, String currencyTo, Date date) throws CAFFindException {
        ArrayList retValue;
        String user = this.sessionContext.getCallerPrincipal().getName();
        String methodHeader = "convertCurrency(java.lang.String, java.lang.String, java.lang.String, java.sql.Date)";
        Object[] parameters = new Object[]{rateType, currencyFrom, currencyTo, date};
        CAFPublicLogger.entering((String)user, (String)JARM_REQUEST, (String)methodHeader, (Location)location, (Object[])parameters);
        try {
            try {
                ExchangeRateServiceLocal exchangeRateServiceLocal = this.getExchangeRateService();
                retValue = exchangeRateServiceLocal.getExchangeRate(new QueryFilter(currencyFrom), new QueryFilter(currencyTo), new QueryFilter(rateType), new QueryFilter(new SimpleDateFormat("yyyy-MM-dd").format(date)));
            }
            catch (Exception e) {
                throw new CAFFindException((Throwable)e);
            }
        }
        finally {
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)methodHeader, (Location)location, (Object)parameters);
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList convertCurrencyForToday(String currencyFrom, String currencyTo) throws CAFFindException {
        ArrayList retValue;
        String user = this.sessionContext.getCallerPrincipal().getName();
        String methodHeader = "convertCurrencyForToday(java.lang.String, java.lang.String)";
        Object[] parameters = new Object[]{currencyFrom, currencyTo};
        CAFPublicLogger.entering((String)user, (String)JARM_REQUEST, (String)methodHeader, (Location)location, (Object[])parameters);
        try {
            Date currentDate = new Date(System.currentTimeMillis());
            retValue = this.convertCurrency("M", currencyFrom, currencyTo, currentDate);
        }
        finally {
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)methodHeader, (Location)location, (Object)parameters);
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList convertCurrencyWithStructure(Amount amount, String currencyTarget, Date date, String rateType) throws CAFFindException {
        ArrayList<Amount> retValue;
        String user = this.sessionContext.getCallerPrincipal().getName();
        String methodHeader = "convertCurrencyWithStructure(com.sap.caf.core.appsrv.datatypes.Amount, java.lang.String, java.sql.Date, java.lang.String)";
        Object[] parameters = new Object[]{amount, currencyTarget, date, rateType};
        CAFPublicLogger.entering((String)user, (String)JARM_REQUEST, (String)methodHeader, (Location)location, (Object[])parameters);
        try {
            ArrayList amountCollection = this.convertCurrency(rateType, amount.getCurrency(), currencyTarget, date);
            retValue = new ArrayList<Amount>();
            Amount amountResult = new Amount();
            ExchangeRate exchangeRate = (ExchangeRate)amountCollection.iterator().next();
            if (exchangeRate != null) {
                amountResult.setCurrency(currencyTarget);
                amountResult.setValue(exchangeRate.getExchangeRate().multiply(amount.getValue()));
            }
            retValue.add(amountResult);
        }
        finally {
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)methodHeader, (Location)location, (Object)parameters);
        }
        return retValue;
    }

    private ExchangeRateServiceLocal getExchangeRateService() throws ServiceException {
        String method = "getExchangeRateService()";
        String jndiName = "localejbs/sap.com/caf.core/ExchangeRateService";
        String user = this.sessionContext.getCallerPrincipal().getName();
        ExchangeRateServiceLocal local = null;
        CAFPublicLogger.entering((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
        try {
            ExchangeRateServiceLocalHome localHome = (ExchangeRateServiceLocalHome)HomeFactory.getInstance().getLocalHome(jndiName);
            local = localHome.create();
        }
        catch (ServiceException se) {
            Object[] args = new Object[]{jndiName};
            CAFPublicLogger.categoryCAF.logThrowableT(500, location, method, "APPSRV_JNDI_LOOKUP_ERROR", args, (Throwable)se);
            location.throwing(method, (Throwable)se);
            throw new ServiceException((Throwable)se);
        }
        catch (CreateException e) {
            Object[] args = new Object[]{method};
            CAFPublicLogger.traceThrowableT((int)100, (Location)location, (String)method, (String)"APPSRV_SIMPLE_ERROR", (Object[])args, (Throwable)e);
            location.throwing(method, (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (int)1);
        }
        return local;
    }

    private void checkPermission(String user, String permission, String methodHeader) throws CAFPermissionException {
        if (!CAFPermission.checkServicePermission((String)user, (ServicePermission)new ServicePermission(permission))) {
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)methodHeader, (Location)location, (int)1);
            throw new CAFPermissionException("APPSRV_AUTH_PERMISSION_ERROR", new Object[0]);
        }
    }

    public Object execute(String operationName, ArrayList parameters) throws ServiceException {
        String method = "execute(String, ArrayList)";
        String user = this.sessionContext.getCallerPrincipal().getName();
        Object result = null;
        CAFPublicLogger.entering((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (Object[])new Object[]{operationName, parameters}, (int)1);
        if (operationName == null) {
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location);
            throw new ServiceException("APPSRV_NULL_OPERATION_ERROR");
        }
        try {
            try {
                if (!"".equals(operationName)) {
                    throw new ServiceException("Operation not defined");
                }
                Object var8_6 = null;
            }
            catch (Exception e) {
                CAFPublicLogger.traceThrowableT((int)100, (Location)location, (String)method, (String)("Error in " + method), (Throwable)e);
                location.throwing(method, (Throwable)e);
                throw new ServiceException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (Object)new Object[]{result}, (int)1);
            throw throwable;
        }
        CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (Object)new Object[]{result}, (int)1);
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

