/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.core.appsrv.classificationrefservice;

import com.sap.caf.core.appsrv.datatypes.ClassificationRef;
import com.sap.caf.core.besrv.category.Category;
import com.sap.caf.core.besrv.category.CategoryServiceLocal;
import com.sap.caf.core.besrv.category.CategoryServiceLocalHome;
import com.sap.caf.core.besrv.categoryvalue.CategoryValue;
import com.sap.caf.core.besrv.categoryvalue.CategoryValueServiceLocal;
import com.sap.caf.core.besrv.categoryvalue.CategoryValueServiceLocalHome;
import com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchClassify;
import com.sap.caf.km.ejb.svc.idxsearch.bean.IndexSearchLocal;
import com.sap.caf.km.ejb.svc.idxsearch.bean.IndexSearchLocalHome;
import com.sap.caf.rt.exception.CAFPermissionException;
import com.sap.caf.rt.exception.ServiceException;
import com.sap.caf.rt.security.acl.impl.CAFPermission;
import com.sap.caf.rt.security.srv.ServicePermission;
import com.sap.caf.rt.srv.ApplicationServiceBean;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.ejb.CreateException;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;

public class ClassificationRefServiceBean
extends ApplicationServiceBean {
    public static final String PROVIDER = "sap.com";
    public static final String APPLICATION = "classificationref";
    public static final String APP_SRV_NAME = "ClassificationRefService";
    public static final String OBJECT_NAME = "sap.com/classificationref/ClassificationRefService";
    public static final String JARM_REQUEST = "XAP:APPSERV:sap.com/classificationref/ClassificationRefService";
    private static final Location location = Location.getLocation((Class)(class$com$sap$caf$core$appsrv$classificationrefservice$ClassificationRefServiceBean == null ? (class$com$sap$caf$core$appsrv$classificationrefservice$ClassificationRefServiceBean = ClassificationRefServiceBean.class$("com.sap.caf.core.appsrv.classificationrefservice.ClassificationRefServiceBean")) : class$com$sap$caf$core$appsrv$classificationrefservice$ClassificationRefServiceBean));
    private SessionContext sessionContext;
    private static final String JNDI_CATEGORY_NAME = "localejbs/sap.com/caf.tc/CategoryService";
    private static final String JNDI_CATEGORY_VALUE_NAME = "localejbs/sap.com/caf.tc/CategoryValueService";
    private static final String JNDI_INDEX_SEARCH_NAME = "localejbs/sap.com/caf~com.sap.caf.runtime/IndexSearchBean";
    private CategoryValueServiceLocal categoryValueService;
    private CategoryServiceLocal categoryService;
    static /* synthetic */ Class class$com$sap$caf$core$appsrv$classificationrefservice$ClassificationRefServiceBean;
    static /* synthetic */ Class class$java$lang$String;

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void setSessionContext(SessionContext context) {
        this.sessionContext = context;
    }

    public void ejbCreate() throws CreateException {
        this.objectGuid = "208211DF1D0E888963EC8D933CA90DDD";
    }

    private Object getServiceByType(String refType) throws ServiceException {
        String user = this.sessionContext.getCallerPrincipal().getName();
        String methodHeader = "getServiceByType(java.lang.String)";
        Object[] parameters = new Object[]{refType};
        CAFPublicLogger.entering((String)user, (String)JARM_REQUEST, (String)methodHeader, (Location)location, (Object[])parameters);
        try {
            Object ejbRef;
            String jndiName = "localejbs/" + refType;
            Object homeRef = new InitialContext().lookup(jndiName);
            Method createMethod = homeRef.getClass().getMethod("create", new Class[0]);
            Object object = ejbRef = createMethod.invoke(homeRef, new Object[0]);
            return object;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)methodHeader, (Location)location, (Object)parameters);
        }
    }

    private IIndexSearchClassify getClassifyBean() throws Exception {
        String user = this.sessionContext.getCallerPrincipal().getName();
        String methodHeader = "getClassifyBean()";
        Object[] parameters = new Object[]{};
        CAFPublicLogger.entering((String)user, (String)JARM_REQUEST, (String)methodHeader, (Location)location, (Object[])parameters);
        InitialContext context = new InitialContext();
        IndexSearchLocalHome idxHome = (IndexSearchLocalHome)context.lookup(JNDI_INDEX_SEARCH_NAME);
        IndexSearchLocal idxs = idxHome.create();
        CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)methodHeader, (Location)location, (Object)parameters);
        return idxs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getCategoryClassifications(String guid, String refType) throws ServiceException {
        String user = this.sessionContext.getCallerPrincipal().getName();
        String methodHeader = "getCategoryClassifications(java.lang.String, java.lang.String)";
        Object[] parameters = new Object[]{guid, refType};
        CAFPublicLogger.entering((String)user, (String)JARM_REQUEST, (String)methodHeader, (Location)location, (Object[])parameters);
        ArrayList<ClassificationRef> result = Collections.EMPTY_LIST;
        CategoryServiceLocal service = this.getCategoryService();
        try {
            Category currentCategory = service.read(guid);
            Collection values = currentCategory.getValues();
            if (values == null || values.isEmpty()) {
                ArrayList<ClassificationRef> arrayList = result;
                return arrayList;
            }
            String taxonomy = currentCategory.getName();
            result = new ArrayList<ClassificationRef>(values.size());
            Iterator iter = values.iterator();
            while (iter.hasNext()) {
                String catValueKey = (String)iter.next();
                CategoryValue vo = this.getCategoryValueService().read(catValueKey);
                ClassificationRef bean = new ClassificationRef();
                bean.setClassificationID(vo.getKey());
                bean.setObjectID(null);
                bean.setRefType(refType);
                bean.setTaxonomy(taxonomy);
                bean.setTaxonomyID(guid);
                bean.setCategory(vo.getName());
                result.add(bean);
            }
        }
        catch (Exception e) {
        }
        finally {
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)methodHeader, (Location)location, (Object)parameters);
        }
        return result;
    }

    private CategoryServiceLocal getCategoryService() throws ServiceException {
        if (this.categoryService == null) {
            try {
                InitialContext context = new InitialContext();
                CategoryServiceLocalHome categoryHome = (CategoryServiceLocalHome)context.lookup(JNDI_CATEGORY_NAME);
                this.categoryService = categoryHome.create();
            }
            catch (Exception ex) {
                throw new ServiceException((Throwable)ex);
            }
        }
        return this.categoryService;
    }

    private CategoryValueServiceLocal getCategoryValueService() throws Exception {
        if (this.categoryValueService == null) {
            InitialContext context = new InitialContext();
            CategoryValueServiceLocalHome categoryHome = (CategoryValueServiceLocalHome)context.lookup(JNDI_CATEGORY_VALUE_NAME);
            this.categoryValueService = categoryHome.create();
        }
        return this.categoryValueService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getObjectClassifications(String refType, String objectID, String categoryID) throws ServiceException {
        String user = this.sessionContext.getCallerPrincipal().getName();
        String methodHeader = "getObjectClassifications(java.lang.String, java.lang.String, java.lang.String)";
        Object[] parameters = new Object[]{refType, objectID, categoryID};
        CAFPublicLogger.entering((String)user, (String)JARM_REQUEST, (String)methodHeader, (Location)location, (Object[])parameters);
        ArrayList<ClassificationRef> result = Collections.EMPTY_LIST;
        CategoryServiceLocal service = this.getCategoryService();
        try {
            Category currentCategory = service.read(categoryID);
            String taxonomy = currentCategory.getName();
            Collection voGuids = this.getClassifyBean().getClassification(objectID, categoryID);
            result = new ArrayList<ClassificationRef>(voGuids.size());
            Iterator iter = voGuids.iterator();
            while (iter.hasNext()) {
                String voGuid = (String)iter.next();
                CategoryValue vo = this.getCategoryValueService().read(voGuid);
                ClassificationRef bean = new ClassificationRef();
                bean.setClassificationID(vo.getKey());
                bean.setObjectID(objectID);
                bean.setRefType(refType);
                bean.setTaxonomy(taxonomy);
                bean.setTaxonomyID(categoryID);
                bean.setCategory(vo.getName());
                result.add(bean);
            }
        }
        catch (Exception e) {
        }
        finally {
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)methodHeader, (Location)location, (Object)parameters);
        }
        return result;
    }

    public void createClassificationRef(String refType, String objectId, String classificationId, String taxonomyId) throws ServiceException {
        String user = this.sessionContext.getCallerPrincipal().getName();
        String methodHeader = "createClassificationRef(java.lang.String, java.lang.String, java.lang.String, java.lang.String)";
        Object[] parameters = new Object[]{refType, objectId, classificationId, taxonomyId};
        CAFPublicLogger.entering((String)user, (String)JARM_REQUEST, (String)methodHeader, (Location)location, (Object[])parameters);
        Object srv = this.getServiceByType(refType);
        try {
            Method addClsfMet = srv.getClass().getMethod("addClassification", class$java$lang$String == null ? (class$java$lang$String = ClassificationRefServiceBean.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = ClassificationRefServiceBean.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = ClassificationRefServiceBean.class$("java.lang.String")) : class$java$lang$String);
            addClsfMet.invoke(srv, objectId, classificationId, taxonomyId);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)methodHeader, (Location)location, (Object)parameters);
        }
    }

    public void deleteClassificationRef(String refType, String objectId, String classificationId) throws ServiceException {
        String user = this.sessionContext.getCallerPrincipal().getName();
        String methodHeader = "deleteClassificationRef(java.lang.String, java.lang.String, java.lang.String)";
        Object[] parameters = new Object[]{refType, objectId, classificationId};
        CAFPublicLogger.entering((String)user, (String)JARM_REQUEST, (String)methodHeader, (Location)location, (Object[])parameters);
        Object srv = this.getServiceByType(refType);
        try {
            Method delClsfMet = srv.getClass().getMethod("removeClassification", class$java$lang$String == null ? (class$java$lang$String = ClassificationRefServiceBean.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = ClassificationRefServiceBean.class$("java.lang.String")) : class$java$lang$String);
            delClsfMet.invoke(srv, objectId, classificationId);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)methodHeader, (Location)location, (Object)parameters);
        }
    }

    public Collection taxonomyList(String refType) throws ServiceException {
        String user = this.sessionContext.getCallerPrincipal().getName();
        String methodHeader = "taxonomyList(java.lang.String)";
        Object[] parameters = new Object[]{refType};
        CAFPublicLogger.entering((String)user, (String)JARM_REQUEST, (String)methodHeader, (Location)location, (Object[])parameters);
        Collection categoryGuids = null;
        try {
            categoryGuids = this.getClassifyBean().getCategories(refType);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
        if (categoryGuids == null || categoryGuids.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList retValue = new ArrayList(categoryGuids.size() * 10);
        Iterator iter = categoryGuids.iterator();
        while (iter.hasNext()) {
            String guid = (String)iter.next();
            retValue.addAll(this.getCategoryClassifications(guid, refType));
        }
        CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)methodHeader, (Location)location, (Object)parameters);
        return retValue;
    }

    public Collection classificationList(String refType, String objectId) throws ServiceException {
        String user = this.sessionContext.getCallerPrincipal().getName();
        String methodHeader = "classificationList(java.lang.String, java.lang.String)";
        Object[] parameters = new Object[]{refType, objectId};
        CAFPublicLogger.entering((String)user, (String)JARM_REQUEST, (String)methodHeader, (Location)location, (Object[])parameters);
        Collection categoryGuids = null;
        try {
            categoryGuids = this.getClassifyBean().getCategories(refType);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
        if (categoryGuids == null || categoryGuids.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList retValue = new ArrayList(categoryGuids.size() * 10);
        Iterator iter = categoryGuids.iterator();
        while (iter.hasNext()) {
            String categoryID = (String)iter.next();
            retValue.addAll(this.getObjectClassifications(refType, objectId, categoryID));
        }
        CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)methodHeader, (Location)location, (Object)parameters);
        return retValue;
    }

    public Collection classifListForBO(String refType) throws ServiceException {
        ArrayList<ClassificationRef> retValue;
        String user = this.sessionContext.getCallerPrincipal().getName();
        String methodHeader = "classifListForAllBOs(String)";
        Object[] parameters = new Object[]{refType};
        CAFPublicLogger.entering((String)user, (String)JARM_REQUEST, (String)methodHeader, (Location)location, (Object[])parameters);
        try {
            IIndexSearchClassify classifySrv = this.getClassifyBean();
            retValue = new ArrayList<ClassificationRef>();
            CategoryServiceLocal catSrv = this.getCategoryService();
            CategoryValueServiceLocal catValueSrv = this.getCategoryValueService();
            Collection assignment = classifySrv.getAssignedClassification(refType);
            Iterator iter = assignment.iterator();
            while (iter.hasNext()) {
                String[] row = (String[])iter.next();
                ClassificationRef ref = new ClassificationRef();
                ref.setRefType(refType);
                ref.setObjectID(row[0]);
                ref.setTaxonomyID(row[2]);
                ref.setClassificationID(row[1]);
                ref.setTaxonomy(catSrv.read(row[2]).getName());
                ref.setCategory(catValueSrv.read(row[1]).getName());
                retValue.add(ref);
            }
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowableT((int)100, (Location)location, (String)methodHeader, (String)("Error in " + methodHeader), (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)methodHeader, (Location)location, (Object)parameters);
        }
        return retValue;
    }

    public Collection findAllClassifications(Map mapNameToFilter) throws ServiceException {
        String user = this.sessionContext.getCallerPrincipal().getName();
        String methodHeader = "findByMultipleParameters(Map)";
        Object[] parameters = new Object[]{mapNameToFilter};
        CAFPublicLogger.entering((String)user, (String)JARM_REQUEST, (String)methodHeader, (Location)location, (Object[])parameters);
        try {
            Collection collection = this.classifListForBO(null);
            return collection;
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowableT((int)100, (Location)location, (String)methodHeader, (String)("Error in " + methodHeader), (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)methodHeader, (Location)location, (Object)parameters);
        }
    }

    public ClassificationRef create() {
        return new ClassificationRef();
    }

    public ClassificationRef read(String key) {
        return new ClassificationRef();
    }

    public void update(ClassificationRef classificationRef) {
    }

    public void delete(ClassificationRef classificationRef) {
    }

    private void checkPermission(String user, String permission, String methodHeader) throws CAFPermissionException {
        if (!CAFPermission.checkServicePermission((String)user, (ServicePermission)new ServicePermission(permission))) {
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)methodHeader, (Location)location, (int)1);
            throw new CAFPermissionException("APPSRV_AUTH_PERMISSION_ERROR", new Object[0]);
        }
    }

    public Object execute(String operationName, ArrayList parameters) throws ServiceException {
        String method = "execute(String, ArrayList)";
        String user = this.sessionContext.getCallerPrincipal().getName();
        Object result = null;
        CAFPublicLogger.entering((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (Object[])new Object[]{operationName, parameters}, (int)1);
        if (operationName == null) {
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location);
            throw new ServiceException("APPSRV_NULL_OPERATION_ERROR");
        }
        try {
            try {
                if (!"".equals(operationName)) {
                    throw new ServiceException("Operation not defined");
                }
                Object var8_6 = null;
            }
            catch (Exception e) {
                CAFPublicLogger.traceThrowableT((int)100, (Location)location, (String)method, (String)("Error in " + method), (Throwable)e);
                location.throwing(method, (Throwable)e);
                throw new ServiceException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (Object)new Object[]{result}, (int)1);
            throw throwable;
        }
        CAFPublicLogger.exiting((String)user, (String)JARM_REQUEST, (String)method, (Location)location, (Object)new Object[]{result}, (int)1);
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

