/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.logger;

import java.io.PrintStream;
import java.text.MessageFormat;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildLogger;
import org.eclipse.ant.core.AntSecurityException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ui.externaltools.internal.ant.AntSupportMessages;

public class NullBuildLogger
implements BuildLogger {
    protected int fMessageOutputLevel = 2;
    private PrintStream fErr = null;
    private PrintStream fOut = null;
    protected boolean fEmacsMode = false;
    protected Throwable fHandledException = null;

    public void setMessageOutputLevel(int level) {
        this.fMessageOutputLevel = level;
    }

    protected int getMessageOutputLevel() {
        return this.fMessageOutputLevel;
    }

    public void setEmacsMode(boolean emacsMode) {
        this.fEmacsMode = emacsMode;
    }

    public void buildStarted(BuildEvent event) {
    }

    public void buildFinished(BuildEvent event) {
        this.handleException(event);
        this.fHandledException = null;
    }

    public void targetStarted(BuildEvent event) {
    }

    public void targetFinished(BuildEvent event) {
        this.handleException(event);
    }

    public void taskStarted(BuildEvent event) {
    }

    public void taskFinished(BuildEvent event) {
        this.handleException(event);
    }

    public void messageLogged(BuildEvent event) {
        this.logMessage(event.getMessage(), event.getPriority());
    }

    protected PrintStream getErrorPrintStream() {
        return this.fErr;
    }

    protected PrintStream getOutputPrintStream() {
        return this.fOut;
    }

    public void setErrorPrintStream(PrintStream err) {
        this.fErr = err == System.err ? null : err;
    }

    public void setOutputPrintStream(PrintStream output) {
        this.fOut = output == System.out ? null : output;
    }

    protected void logMessage(String message, int priority) {
        if (priority > this.getMessageOutputLevel()) {
            return;
        }
        if (priority == 0) {
            if (this.getErrorPrintStream() != null && this.getErrorPrintStream() != System.err) {
                this.getErrorPrintStream().println(message);
            }
        } else if (this.getOutputPrintStream() != null && this.getOutputPrintStream() != System.out) {
            this.getOutputPrintStream().println(message);
        }
    }

    protected void handleException(BuildEvent event) {
        Throwable exception = event.getException();
        if (exception == null || exception == this.fHandledException || exception instanceof OperationCanceledException || exception instanceof AntSecurityException) {
            return;
        }
        this.fHandledException = exception;
        this.logMessage(MessageFormat.format(AntSupportMessages.getString("AntProcessBuildLogger.BUILD_FAILED__{0}_1"), exception.toString()), 0);
    }
}

