/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ant.logger;

import java.io.File;
import java.text.MessageFormat;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.FileUtils;
import org.eclipse.ant.core.AntSecurityException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.console.FileLink;
import org.eclipse.debug.ui.console.IConsoleHyperlink;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.externaltools.internal.ant.AntSupportMessages;
import org.eclipse.ui.externaltools.internal.ant.launchConfigurations.AntProcess;
import org.eclipse.ui.externaltools.internal.ant.launchConfigurations.AntStreamMonitor;
import org.eclipse.ui.externaltools.internal.ant.launchConfigurations.AntStreamsProxy;
import org.eclipse.ui.externaltools.internal.ant.launchConfigurations.TaskLinkManager;
import org.eclipse.ui.externaltools.internal.ant.logger.NullBuildLogger;

public class AntProcessBuildLogger
extends NullBuildLogger {
    private File fBuildFileParent = null;
    private long fStartTime;
    public static final int LEFT_COLUMN_SIZE = 15;
    private AntProcess fProcess = null;

    protected void logMessage(String message, BuildEvent event, int overridePriority) {
        String fileName;
        IFile file;
        int priority = overridePriority;
        if (priority == -1) {
            priority = event.getPriority();
        }
        if (priority > this.getMessageOutputLevel()) {
            return;
        }
        AntProcess antProcess = this.getAntProcess(event.getProject().getUserProperty("org.eclipse.ui.externaltools.ATTR_ANT_PROCESS_ID"));
        if (antProcess == null) {
            return;
        }
        AntStreamMonitor monitor = this.getMonitor(priority);
        if (event.getTarget() == null && message.startsWith("Buildfile:") && (file = this.getFileForLocation(fileName = message.substring(10).trim())) != null) {
            FileLink link = new FileLink(file, null, -1, -1, -1);
            TaskLinkManager.addTaskHyperlink((IProcess)this.fProcess, (IConsoleHyperlink)link, (IRegion)new Region(11 + System.getProperty("line.separator").length(), fileName.length()), (String)fileName);
            this.fBuildFileParent = file.getLocation().toFile().getParentFile();
        }
        StringBuffer fullMessage = new StringBuffer(System.getProperty("line.separator"));
        if (event.getTask() != null && !this.fEmacsMode) {
            this.getAdornedMessage(event, fullMessage);
        }
        fullMessage.append(message);
        message = fullMessage.toString();
        monitor.append(message);
        this.logMessageToLogFile(message, priority);
    }

    private void getAdornedMessage(BuildEvent event, StringBuffer fullMessage) {
        String name = event.getTask().getTaskName();
        if (name == null) {
            name = "null";
        }
        int size = 15 - (name.length() + 3);
        int i = 0;
        while (i < size) {
            fullMessage.append(' ');
            ++i;
        }
        fullMessage.append('[');
        fullMessage.append(name);
        fullMessage.append("] ");
        int offset = Math.max(size, 0) + 1;
        int length = 15 - size - 3;
        IConsoleHyperlink taskLink = this.getTaskLink(event);
        if (taskLink != null) {
            TaskLinkManager.addTaskHyperlink((IProcess)this.fProcess, (IConsoleHyperlink)taskLink, (IRegion)new Region(offset, length), (String)name);
        }
    }

    private AntStreamMonitor getMonitor(int priority) {
        AntStreamsProxy proxy = (AntStreamsProxy)this.fProcess.getStreamsProxy();
        AntStreamMonitor monitor = null;
        switch (priority) {
            case 2: {
                monitor = (AntStreamMonitor)proxy.getOutputStreamMonitor();
                break;
            }
            case 0: {
                monitor = (AntStreamMonitor)proxy.getErrorStreamMonitor();
                break;
            }
            case 4: {
                monitor = (AntStreamMonitor)proxy.getDebugStreamMonitor();
                break;
            }
            case 1: {
                monitor = (AntStreamMonitor)proxy.getWarningStreamMonitor();
                break;
            }
            case 3: {
                monitor = (AntStreamMonitor)proxy.getVerboseStreamMonitor();
            }
        }
        return monitor;
    }

    private void logMessageToLogFile(String message, int priority) {
        if (priority == 0) {
            if (this.getErrorPrintStream() != null && this.getErrorPrintStream() != System.err) {
                this.getErrorPrintStream().println(message);
            }
        } else if (this.getOutputPrintStream() != null && this.getOutputPrintStream() != System.out) {
            this.getOutputPrintStream().println(message);
        }
    }

    private IConsoleHyperlink getTaskLink(BuildEvent event) {
        Location location;
        Task task = event.getTask();
        if (task != null && (location = task.getLocation()) != null) {
            String fileName;
            IFile file;
            int index;
            String path = location.toString().trim();
            if (path.length() == 0) {
                return null;
            }
            if (path.startsWith("file:")) {
                path = path.substring(5, path.length());
            }
            if ((index = path.lastIndexOf(58)) == path.length() - 1) {
                path = path.substring(0, index);
                index = path.lastIndexOf(58);
            }
            if ((file = this.getFileForLocation(fileName = path.substring(0, index))) != null) {
                try {
                    String lineNumber = path.substring(index + 1);
                    int line = Integer.parseInt(lineNumber);
                    return new FileLink(file, null, -1, -1, line);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        return null;
    }

    private AntProcess getAntProcess(String processId) {
        if (this.fProcess == null && processId != null) {
            IProcess[] all = DebugPlugin.getDefault().getLaunchManager().getProcesses();
            int i = 0;
            while (i < all.length) {
                IProcess process = all[i];
                if (process instanceof AntProcess && processId.equals(process.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_PROCESS_ID"))) {
                    this.fProcess = (AntProcess)process;
                    break;
                }
                ++i;
            }
        }
        return this.fProcess;
    }

    public void buildStarted(BuildEvent event) {
        this.fStartTime = System.currentTimeMillis();
    }

    public void buildFinished(BuildEvent event) {
        this.handleException(event);
        this.fHandledException = null;
        this.fBuildFileParent = null;
        this.logMessage(this.getTimeString(System.currentTimeMillis() - this.fStartTime), event, this.fMessageOutputLevel);
        this.fProcess = null;
        event.getProject().removeBuildListener((BuildListener)this);
    }

    private String getTimeString(long milliseconds) {
        long seconds = milliseconds / 1000L;
        long minutes = seconds / 60L;
        seconds %= 60L;
        StringBuffer result = new StringBuffer(AntSupportMessages.getString("AntProcessBuildLogger.Total_time"));
        if (minutes > 0L) {
            result.append(minutes);
            if (minutes > 1L) {
                result.append(AntSupportMessages.getString("AntProcessBuildLogger._minutes_2"));
            } else {
                result.append(AntSupportMessages.getString("AntProcessBuildLogger._minute_3"));
            }
        }
        if (seconds > 0L) {
            if (minutes > 0L) {
                result.append(' ');
            }
            result.append(seconds);
            if (seconds > 1L) {
                result.append(AntSupportMessages.getString("AntProcessBuildLogger._seconds_4"));
            } else {
                result.append(AntSupportMessages.getString("AntProcessBuildLogger._second_5"));
            }
        }
        if (seconds == 0L && minutes == 0L) {
            result.append(milliseconds);
            result.append(AntSupportMessages.getString("AntProcessBuildLogger._milliseconds_6"));
        }
        return result.toString();
    }

    public void messageLogged(BuildEvent event) {
        this.logMessage(event.getMessage(), event, -1);
    }

    protected void handleException(BuildEvent event) {
        Throwable exception = event.getException();
        if (exception == null || exception == this.fHandledException || exception instanceof OperationCanceledException || exception instanceof AntSecurityException) {
            return;
        }
        this.fHandledException = exception;
        this.logMessage(MessageFormat.format(AntSupportMessages.getString("AntProcessBuildLogger.BUILD_FAILED__{0}_1"), exception.toString()), event, 0);
    }

    public void targetStarted(BuildEvent event) {
        if (2 > this.getMessageOutputLevel()) {
            return;
        }
        StringBuffer msg = new StringBuffer(System.getProperty("line.separator"));
        msg.append(event.getTarget().getName());
        msg.append(':');
        this.logMessage(msg.toString(), event, 2);
    }

    private IFile getFileForLocation(String absolutePath) {
        Path filePath = new Path(absolutePath);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)filePath);
        if (file == null) {
            File relativeFile = null;
            try {
                relativeFile = FileUtils.newFileUtils().resolveFile(this.fBuildFileParent, absolutePath);
                filePath = new Path(relativeFile.getAbsolutePath());
                file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)filePath);
                if (file == null) {
                    return null;
                }
            }
            catch (BuildException buildException) {
                return null;
            }
        }
        if (file.exists()) {
            return file;
        }
        return null;
    }
}

