/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.mmr.adapter;

import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.Configuration;
import com.sap.caf.metamodel.Constraint;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.metamodel.DataStructure;
import com.sap.caf.metamodel.Entry;
import com.sap.caf.metamodel.ExternalInterface;
import com.sap.caf.metamodel.FaultMessage;
import com.sap.caf.metamodel.MOFInterface;
import com.sap.caf.metamodel.Message;
import com.sap.caf.metamodel.Operation;
import com.sap.caf.metamodel.Properties;
import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.core.data.service.IDataServiceFactory;
import com.sap.caf.mp.core.data.service.interfce.api.IOperation;
import com.sap.caf.mp.core.data.service.interfce.api.IOperationpart;
import com.sap.caf.mp.core.data.service.interfce.api.IPorttype;
import com.sap.caf.mp.core.data.service.interfce.base.Operationpart;
import com.sap.caf.mp.core.data.service.interfce.base.Porttype;
import com.sap.caf.mp.core.data.service.registry.IServiceDefinition;
import com.sap.caf.mp.core.data.service.registry.ServiceDefinition;
import com.sap.caf.mp.core.data.types.api.IElement;
import com.sap.caf.mp.core.data.types.api.IMessage;
import com.sap.caf.mp.core.data.types.api.IMessagepart;
import com.sap.caf.mp.core.data.types.api.ISimpleType;
import com.sap.caf.mp.core.data.types.api.IStructure;
import com.sap.caf.mp.core.data.types.api.IType;
import com.sap.caf.mp.core.data.types.base.ComplexType;
import com.sap.caf.mp.core.data.types.base.Element;
import com.sap.caf.mp.core.data.types.base.Messagepart;
import com.sap.caf.mp.core.data.types.base.SimpleType;
import com.sap.caf.mp.core.data.values.api.ISimpleTypeValue;
import com.sap.caf.mp.core.data.values.base.SimpleTypeValue;
import com.sap.caf.mp.mmr.adapter.ITypeConverter;
import com.sap.caf.mp.mmr.adapter.SimpleTypeMapping;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class ServiceDefinitionTypeConverter
implements ITypeConverter {
    private IServiceDefinition serviceDefinition;
    private IPorttype porttype;

    public IServiceDefinition getServiceDefinition() {
        return this.serviceDefinition;
    }

    public IPorttype getPorttype() {
        return this.porttype;
    }

    private static boolean isEntityAttribute(Attribute attr) {
        return attr.getTypeJavaDdic() == null && attr.getReferencedObject() != null && attr.getReferencedObject() instanceof DataObject && ((DataObject)attr.getReferencedObject()).getBusinessEntityInterface() != null;
    }

    public void convertCAFInterface(MOFInterface aInterface) throws InvocationException, EngineException {
        Hashtable processedAttributes = new Hashtable();
        Hashtable processedDataStructures = new Hashtable();
        String portTypeId = aInterface.getObjectId();
        Porttype mpPorttype = portTypeId == null || portTypeId.length() <= 0 ? new Porttype(aInterface.getObjectName() != null ? aInterface.getObjectName() : "") : new Porttype(aInterface.getObjectId(), aInterface.getObjectName() != null ? aInterface.getObjectName() : "");
        List coreOperations = aInterface.getOperations();
        Iterator iter = coreOperations.iterator();
        while (iter.hasNext()) {
            Collection coreFaultMessages;
            Message output;
            Operation coreOperation = (Operation)iter.next();
            com.sap.caf.mp.core.data.service.interfce.base.Operation mpOperation = new com.sap.caf.mp.core.data.service.interfce.base.Operation(coreOperation.getObjectName() != null ? coreOperation.getObjectName() : "");
            Message input = coreOperation.getInput();
            if (input != null) {
                Operationpart mpInputOperationPart = new Operationpart("");
                mpInputOperationPart.setMessage(ServiceDefinitionTypeConverter.getMpMessage(input, processedAttributes, processedDataStructures));
                mpOperation.setInputOperationpart((IOperationpart)mpInputOperationPart);
            }
            if ((output = coreOperation.getOutput()) != null) {
                Operationpart mpOutputOperationPart = new Operationpart("");
                mpOutputOperationPart.setMessage(ServiceDefinitionTypeConverter.getMpMessage(output, processedAttributes, processedDataStructures));
                mpOperation.setOutputOperationpart((IOperationpart)mpOutputOperationPart);
            }
            if ((coreFaultMessages = coreOperation.getFault()) != null) {
                Iterator iterator = coreFaultMessages.iterator();
                while (iterator.hasNext()) {
                    Operationpart mpFaultOperationPart = new Operationpart("");
                    mpFaultOperationPart.setMessage(ServiceDefinitionTypeConverter.getMpMessage((Message)iterator.next(), processedAttributes, processedDataStructures));
                    mpOperation.addFaultOperationpart((IOperationpart)mpFaultOperationPart);
                }
            }
            mpPorttype.addOperation((IOperation)mpOperation);
        }
        this.porttype = mpPorttype;
    }

    public void convertExternalInterfaceWithProperties(ExternalInterface externalInterface, IDataServiceFactory dataServiceFactory) throws InvocationException, EngineException {
        String definitionType = "";
        switch (externalInterface.getType()) {
            case 0: {
                definitionType = "SAP_RFC_MODULE";
                break;
            }
            case 1: {
                definitionType = "WEB_SERVICE_WSDL1.1";
            }
        }
        ServiceDefinition serviceDefinition = new ServiceDefinition(definitionType, externalInterface.getObjectId(), null, null, null, null, dataServiceFactory);
        this.convertCAFInterface((MOFInterface)externalInterface);
        serviceDefinition.setPortType(this.porttype);
        Properties interfaceProperties = externalInterface.getConfiguration().getProperties();
        Iterator iter = interfaceProperties.getEntries().iterator();
        while (iter.hasNext()) {
            Entry cafPropertiesEntry = (Entry)iter.next();
            serviceDefinition.setProperty(cafPropertiesEntry.getKey(), cafPropertiesEntry.getValue());
        }
        iter = externalInterface.getOperations().iterator();
        while (iter.hasNext()) {
            Operation coreOperation = (Operation)iter.next();
            String operationName = coreOperation.getObjectName();
            Configuration configuration = coreOperation.getConfiguration();
            if (configuration == null) continue;
            Properties operationProperties = configuration.getProperties();
            Iterator entries = operationProperties.getEntries().iterator();
            while (entries.hasNext()) {
                Entry cafPropertiesEntry = (Entry)entries.next();
                serviceDefinition.setProperty(operationName, cafPropertiesEntry.getKey(), cafPropertiesEntry.getValue());
            }
        }
        this.serviceDefinition = serviceDefinition;
    }

    public static IMessage getMpMessage(Message coreMessage, Hashtable processedAttributes, Hashtable processedDataStructures) throws InvocationException, EngineException {
        String messageName = coreMessage.getObjectName();
        String messageId = coreMessage.getObjectId();
        if (messageName == null) {
            messageName = "";
        }
        com.sap.caf.mp.core.data.types.base.Message mpMessage = new com.sap.caf.mp.core.data.types.base.Message(messageId, messageName);
        if (ServiceDefinitionTypeConverter.isCoreMsgBelongsToExternalInterface(coreMessage)) {
            List coreMsgParts = coreMessage.getMessageParts();
            if (coreMsgParts.isEmpty() || coreMsgParts.size() > 1) {
                throw new InvocationException("Inconsistant Message structure for External operation!");
            }
            Attribute coreMessagePart = (Attribute)coreMsgParts.get(0);
            Messagepart mpMessagepart = new Messagepart(coreMessagePart.getObjectName());
            DataStructure coreDataStructure = coreMessagePart.getReferencedObject();
            List attributes = coreDataStructure.getAttributes();
            if (attributes.isEmpty() || attributes.size() > 1) {
                throw new InvocationException("Inconsistant Message structure for External operation!");
            }
            Attribute mainIElement = (Attribute)attributes.get(0);
            IElement mpElement = ServiceDefinitionTypeConverter.getMpElement(mainIElement, processedAttributes, processedDataStructures);
            mpMessagepart.setStructure((IStructure)mpElement);
            mpMessage.addMessagepart((IMessagepart)mpMessagepart);
        } else {
            Messagepart mpMessagepart = new Messagepart("parameters");
            Operation coreOperation = ServiceDefinitionTypeConverter.getOperation(coreMessage);
            Element mainMPElement = new Element(coreOperation.getObjectName());
            ComplexType holder = new ComplexType();
            Iterator iter = coreMessage.getMessageParts().iterator();
            while (iter.hasNext()) {
                Attribute coreAttribute = (Attribute)iter.next();
                if (ServiceDefinitionTypeConverter.isEntityAttribute(coreAttribute)) continue;
                holder.addElement(ServiceDefinitionTypeConverter.getMpElement(coreAttribute, processedAttributes, processedDataStructures));
            }
            mainMPElement.setType((IType)holder);
            mpMessagepart.setStructure((IStructure)mainMPElement);
            mpMessage.addMessagepart((IMessagepart)mpMessagepart);
        }
        return mpMessage;
    }

    public static boolean isCoreMsgBelongsToExternalInterface(Message coreMessage) {
        Operation operation;
        MOFInterface mofInterface;
        Collection operations = coreMessage.getInputMessageOperation();
        if ((operations == null || operations.isEmpty()) && ((operations = coreMessage.getOutputMessageOperation()) == null || operations.isEmpty())) {
            operations = ((FaultMessage)coreMessage).getFaultMessageOperation();
        }
        return (mofInterface = (operation = (Operation)operations.iterator().next()).getMOFInterface()) instanceof ExternalInterface;
    }

    public static Operation getOperation(Message coreMessage) {
        Collection operations = coreMessage.getInputMessageOperation();
        if ((operations == null || operations.isEmpty()) && ((operations = coreMessage.getOutputMessageOperation()) == null || operations.isEmpty())) {
            operations = ((FaultMessage)coreMessage).getFaultMessageOperation();
        }
        Operation operation = (Operation)operations.iterator().next();
        return operation;
    }

    private static IElement getMpElement(Attribute coreAttribute, Hashtable processedAttributes, Hashtable processedDataStructures) throws InvocationException, EngineException {
        IType mpType;
        IElement mpAttributeElement = (IElement)processedAttributes.get(coreAttribute);
        if (mpAttributeElement != null) {
            return mpAttributeElement;
        }
        Element mpElement = new Element(coreAttribute.getObjectName());
        int maxOccurs = coreAttribute.getMaxOccurs();
        if (maxOccurs == -1) {
            maxOccurs = 0;
        }
        mpElement.setMaxOccurs(maxOccurs);
        mpElement.setMinOccurs(coreAttribute.getMinOccurs().intValue());
        DataStructure coreDataStructure = coreAttribute.getReferencedObject();
        if (coreDataStructure != null && processedDataStructures.contains(coreDataStructure)) {
            mpType = (IType)processedDataStructures.get(coreDataStructure);
        } else {
            if (coreDataStructure != null) {
                Attribute attribute;
                ComplexType mpComplexType = new ComplexType();
                Integer cafAttributeListType = coreAttribute.getListType();
                if (cafAttributeListType != null) {
                    switch (coreAttribute.getListType()) {
                        case 0: {
                            mpComplexType.setMode(1);
                            break;
                        }
                        case 1: {
                            mpComplexType.setMode(3);
                            break;
                        }
                        case 2: {
                            mpComplexType.setMode(2);
                        }
                    }
                } else {
                    mpComplexType.setMode(3);
                }
                Iterator iter = coreDataStructure.getKeys().iterator();
                while (iter.hasNext()) {
                    attribute = (Attribute)iter.next();
                    if (ServiceDefinitionTypeConverter.isEntityAttribute(attribute)) continue;
                    mpComplexType.addElement(ServiceDefinitionTypeConverter.getMpElement(attribute, processedAttributes, processedDataStructures));
                }
                iter = coreDataStructure.getAttributes().iterator();
                while (iter.hasNext()) {
                    attribute = (Attribute)iter.next();
                    if (ServiceDefinitionTypeConverter.isEntityAttribute(attribute)) continue;
                    mpComplexType.addElement(ServiceDefinitionTypeConverter.getMpElement(attribute, processedAttributes, processedDataStructures));
                }
                mpType = mpComplexType;
            } else {
                SimpleType mpSimpleType = new SimpleType(SimpleTypeMapping.getSimpleTypeBase(coreAttribute));
                mpType = mpSimpleType;
                Constraint restrictions = coreAttribute.getAttributeConstraint();
                if (restrictions != null) {
                    Iterator i;
                    if (restrictions.getMinLength() != null) {
                        mpSimpleType.setMinLength(restrictions.getMinLength().intValue());
                    }
                    if (restrictions.getMaxLength() != null) {
                        mpSimpleType.setMaxLength(restrictions.getMaxLength().intValue());
                    }
                    if (restrictions.getTotalDigits() != null) {
                        mpSimpleType.setTotalDigits(restrictions.getTotalDigits().intValue());
                    }
                    if (restrictions.getFractionDigits() != null) {
                        mpSimpleType.setFractionDigits(restrictions.getFractionDigits().intValue());
                    }
                    if (restrictions.getEnumeration() != null) {
                        i = restrictions.getEnumeration().iterator();
                        while (i.hasNext()) {
                            SimpleTypeValue enumValue = new SimpleTypeValue((ISimpleType)mpSimpleType);
                            enumValue.setValueString((String)i.next());
                            mpSimpleType.addConstant((ISimpleTypeValue)enumValue);
                        }
                    }
                    if (restrictions.getPattern() != null) {
                        i = restrictions.getPattern().iterator();
                        while (i.hasNext()) {
                            mpSimpleType.addPattern((String)i.next());
                        }
                    }
                }
            }
            processedDataStructures.put(coreAttribute, mpType);
        }
        mpElement.setType(mpType);
        processedAttributes.put(coreAttribute, mpElement);
        return mpElement;
    }
}

