/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.engine.util;

import com.sap.bc.proj.jstartup.api.JStartupClusterControlException;
import com.sap.bc.proj.jstartup.api.JStartupClusterController;
import com.sap.bc.proj.jstartup.api.JStartupClusterInstance;
import com.sap.bc.proj.jstartup.api.JStartupControlInstance;
import com.sap.bc.proj.jstartup.api.JStartupControlProcess;
import com.sap.ide.eclipse.j2ee.engine.EnginePlugin;
import com.sap.ide.eclipse.j2ee.engine.util.DispatcherProcessNode;
import com.sap.ide.eclipse.j2ee.engine.util.ProcessNode;
import com.sap.ide.eclipse.j2ee.engine.util.SdmProcessNode;
import com.sap.ide.eclipse.j2ee.engine.util.ServerProcessNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class ProcessNodeManagement {
    private static final int SERVER_TYPE_UNDEFINED = -1;
    private static Comparator instanceComparator = new InstanceComparator();
    private static Comparator processComparator = new ProcessComparator();

    public static ProcessNode createNode(String processName) throws IllegalArgumentException, JStartupClusterControlException {
        return ProcessNodeManagement.createNode(null, processName);
    }

    public static ProcessNode createNode(String instanceName, String processName) throws IllegalArgumentException, JStartupClusterControlException {
        JStartupClusterInstance instance = ProcessNodeManagement.getClusterInstance(instanceName);
        JStartupControlProcess process = ProcessNodeManagement.getControlProcess(instance, processName);
        return ProcessNodeManagement.createNode(instance, process);
    }

    public static ProcessNode createNode(JStartupClusterInstance instance, JStartupControlProcess process) {
        ProcessNode procNode = null;
        switch (process.getType()) {
            case 2: {
                procNode = new DispatcherProcessNode(instance, process);
                break;
            }
            case 4: {
                procNode = new SdmProcessNode(instance, process);
                break;
            }
            case 3: {
                procNode = new ServerProcessNode(instance, process);
                break;
            }
            default: {
                throw new IllegalArgumentException("Could not determine process type !");
            }
        }
        return procNode;
    }

    public static ProcessNode[] getNodesOfType(int type) throws JStartupClusterControlException {
        return ProcessNodeManagement.getNodesOfType(type, true);
    }

    public static ProcessNode[] getNodesOfType(int type, boolean observeState) throws JStartupClusterControlException {
        ArrayList<ProcessNode> serverList = new ArrayList<ProcessNode>();
        JStartupClusterInstance[] instances = ProcessNodeManagement.getClusterInstances();
        int inst = 0;
        while (inst < instances.length) {
            JStartupClusterInstance instance = instances[inst];
            JStartupControlProcess[] procs = new JStartupControlProcess[]{};
            procs = instance.getControlInstance().getProcesses();
            Arrays.sort(procs, processComparator);
            int i = 0;
            while (i < procs.length) {
                JStartupControlProcess process = procs[i];
                if (!(observeState && procs[i].getState() != 3 && procs[i].getState() != 7 || type != -1 && procs[i].getType() != type)) {
                    ProcessNode procNode = ProcessNodeManagement.createNode(instance, process);
                    serverList.add(procNode);
                }
                ++i;
            }
            ++inst;
        }
        ProcessNode[] serverNodes = serverList.toArray(new ProcessNode[0]);
        return serverNodes;
    }

    public static ServerProcessNode[] getAllServerNodes() throws JStartupClusterControlException {
        ProcessNode[] procNodes = ProcessNodeManagement.getNodesOfType(3, true);
        ServerProcessNode[] serverProcNodes = new ServerProcessNode[procNodes.length];
        System.arraycopy(procNodes, 0, serverProcNodes, 0, procNodes.length);
        return serverProcNodes;
    }

    public static DispatcherProcessNode[] getAllDispatcherNodes() throws JStartupClusterControlException {
        ProcessNode[] procNodes = ProcessNodeManagement.getNodesOfType(2, true);
        DispatcherProcessNode[] dispProcNodes = new DispatcherProcessNode[procNodes.length];
        System.arraycopy(procNodes, 0, dispProcNodes, 0, procNodes.length);
        return dispProcNodes;
    }

    public static SdmProcessNode getSdmNode() throws JStartupClusterControlException {
        SdmProcessNode sdmNode = null;
        ProcessNode[] possibleNodes = ProcessNodeManagement.getNodesOfType(4, false);
        if (possibleNodes.length > 0) {
            sdmNode = (SdmProcessNode)possibleNodes[0];
        }
        return sdmNode;
    }

    public static JStartupClusterInstance getClusterInstance(String instanceName) throws JStartupClusterControlException, IllegalArgumentException {
        JStartupClusterInstance instance = null;
        JStartupClusterInstance[] intances = ProcessNodeManagement.getClusterInstances();
        int inst = 0;
        while (inst < intances.length && instance == null) {
            if (instanceName == null || instanceName.equals("") || instanceName.equals(intances[inst].getName().trim())) {
                instance = intances[inst];
            }
            ++inst;
        }
        if (instance == null) {
            throw new IllegalArgumentException("Instance could not be found : " + instanceName);
        }
        return instance;
    }

    public static JStartupControlProcess getControlProcess(JStartupClusterInstance instance, String processName) throws JStartupClusterControlException {
        JStartupControlProcess serverProcess = null;
        if (instance != null && instance.getMessageType() == 1) {
            JStartupControlInstance ctrlInst = instance.getControlInstance();
            JStartupControlProcess[] processes = ctrlInst.getProcesses();
            int proc = 0;
            while (proc < processes.length && serverProcess == null) {
                JStartupControlProcess process = processes[proc];
                if (processName.equals(process.getName().trim())) {
                    serverProcess = process;
                }
                ++proc;
            }
        }
        if (serverProcess == null) {
            throw new IllegalArgumentException("Process could not be found : " + processName);
        }
        return serverProcess;
    }

    public static JStartupClusterInstance[] getClusterInstances() {
        ArrayList<JStartupClusterInstance> realClusterInstList = new ArrayList<JStartupClusterInstance>();
        JStartupClusterController clusterController = EnginePlugin.getDefault().getClusterController();
        if (clusterController != null) {
            try {
                JStartupClusterInstance[] allInstances = clusterController.getInstances();
                if (allInstances != null) {
                    int i = 0;
                    while (i < allInstances.length) {
                        JStartupClusterInstance instance = allInstances[i];
                        if (instance.getMessageType() == 1) {
                            realClusterInstList.add(instance);
                        }
                        ++i;
                    }
                }
            }
            catch (JStartupClusterControlException e) {
                EnginePlugin.getTracer().error("Error on getting cluster instances from cluster controller", (Throwable)e);
            }
        }
        JStartupClusterInstance[] clusterInstances = realClusterInstList.toArray(new JStartupClusterInstance[0]);
        Arrays.sort(clusterInstances, instanceComparator);
        return clusterInstances;
    }

    private static class ProcessComparator
    implements Comparator {
        private ProcessComparator() {
        }

        public int compare(Object o1, Object o2) {
            int compVal = 0;
            if (o1 instanceof JStartupControlProcess && o2 instanceof JStartupControlProcess) {
                JStartupControlProcess proc1 = (JStartupControlProcess)o1;
                JStartupControlProcess proc2 = (JStartupControlProcess)o2;
                compVal = proc1.getName().compareTo(proc2.getName());
            }
            return compVal;
        }
    }

    private static class InstanceComparator
    implements Comparator {
        private InstanceComparator() {
        }

        public int compare(Object o1, Object o2) {
            int compVal = 0;
            if (o1 instanceof JStartupClusterInstance && o2 instanceof JStartupClusterInstance) {
                JStartupClusterInstance inst1 = (JStartupClusterInstance)o1;
                JStartupClusterInstance inst2 = (JStartupClusterInstance)o2;
                if (inst1.getMessageType() == 1 && inst2.getMessageType() == 1) {
                    try {
                        compVal = inst1.getControlInstance().getSAPSystem().compareTo(inst2.getControlInstance().getSAPSystem());
                    }
                    catch (JStartupClusterControlException e) {
                        EnginePlugin.getTracer().warning("Could not sort instances", (Throwable)e);
                    }
                }
            }
            return compVal;
        }
    }
}

