/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.engine.ui.local;

import com.sap.ide.eclipse.j2ee.engine.EnginePlugin;
import com.sap.ide.eclipse.j2ee.engine.installation.ILocalEngine;
import com.sap.ide.eclipse.j2ee.engine.installation.LocalEngineRecognition;
import com.tssap.util.ui.dialog.ObjectSelectionDialog;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class EnginePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IPreferenceStore myPrefStore;
    private Button localInstButton;
    private Text host;
    private Text port;
    private Button remoteInstButton;
    private Button browseButton;
    private Text systemName;
    private Text scsInstNr;
    private Text j2eeInstNr;
    private Text scsInstProfile;
    private Text j2eeInstProfile;
    private String remoteHost;
    private String remotePort;
    private static final Image SYS_IMAGE = SapIdeUtilImages.createImageFromIconsDirectory((String)"com.sap.ide.eclipse.j2ee.engine", (String)"view/cluster_gray.gif");

    public void init(IWorkbench workbench) {
        this.myPrefStore = EnginePlugin.getDefault().getPreferenceStore();
    }

    protected Control createContents(Composite parent) {
        IGridLayoutPane mainPane = PaneFactory.createGridLayoutPane((Composite)parent, (int)3);
        mainPane.addTextLabel("Please select an engine installation to be used for development.", mainPane.createGridLayoutData(1, 1, 3, 1));
        this.remoteInstButton = mainPane.addRadioButton("SAP J2EE engine is installed on remote host.", mainPane.createGridLayoutData(1, 1, 3, 1));
        mainPane.addTextLabel("Message Server Host:");
        this.host = mainPane.addTextField(false, mainPane.createGridLayoutData(4, 1, true, false, 2, 1));
        mainPane.addTextLabel("Message Server Port:");
        this.port = mainPane.addTextField(false, mainPane.createGridLayoutData(4, 1, true, false, 2, 1));
        mainPane.addPlaceholder(3, 1);
        this.localInstButton = mainPane.addRadioButton("SAP J2EE engine is installed on local host.", mainPane.createGridLayoutData(1, 1, 2, 1));
        this.browseButton = mainPane.addPushButton("Browse ...");
        mainPane.addTextLabel("System Name:");
        this.systemName = mainPane.addTextField(true);
        this.systemName.setText("   ");
        mainPane.addPlaceholder();
        mainPane.addTextLabel("J2EE Instance:");
        this.j2eeInstNr = mainPane.addTextField(true);
        mainPane.addPlaceholder();
        mainPane.addTextLabel("SCS Instance:");
        this.scsInstNr = mainPane.addTextField(true);
        mainPane.addPlaceholder();
        mainPane.addPlaceholder(3, 1);
        this.j2eeInstProfile = mainPane.addTextField(true, mainPane.createGridLayoutData(4, 4, true, false, 3, 1));
        this.scsInstProfile = mainPane.addTextField(true, mainPane.createGridLayoutData(4, 4, true, false, 3, 1));
        InnerNumericFocusListener numericListener = new InnerNumericFocusListener();
        this.port.addFocusListener((FocusListener)numericListener);
        InnerRadioButtonSelectionListener selListener = new InnerRadioButtonSelectionListener();
        this.remoteInstButton.addSelectionListener((SelectionListener)selListener);
        this.localInstButton.addSelectionListener((SelectionListener)selListener);
        InnerBrowseButtonSelectionHandler butListener = new InnerBrowseButtonSelectionHandler();
        this.browseButton.addSelectionListener((SelectionListener)butListener);
        String hostText = this.myPrefStore.getString("MsgSrvHost");
        this.host.setText(hostText);
        this.host.setToolTipText("The installation host of the engine.");
        String portText = this.myPrefStore.getString("MsgSrvPort");
        this.port.setText(portText);
        String toolTipText = "The message server port can be computed by \n3600 plus the instance number of the SCS instance (not the J2EE instance !).\n(e.g. 3601 for SCS instance 01)";
        this.port.setToolTipText(toolTipText);
        String sysNameText = this.myPrefStore.getString("SystemId");
        this.systemName.setText(sysNameText);
        String j2eeInstNrText = this.myPrefStore.getString("J2eeInst");
        this.j2eeInstNr.setText(j2eeInstNrText);
        String scsInstNrText = this.myPrefStore.getString("ScsInst");
        this.scsInstNr.setText(scsInstNrText);
        String j2eeInstProfileText = this.myPrefStore.getString("J2eeProfile");
        this.j2eeInstProfile.setText(j2eeInstProfileText);
        String scsInstProfileText = this.myPrefStore.getString("ScsProfile");
        this.scsInstProfile.setText(scsInstProfileText);
        int installationType = this.myPrefStore.getInt("InstType");
        this.remoteInstButton.setSelection(installationType == 0);
        this.localInstButton.setSelection(installationType == 1);
        this.updatePage();
        return mainPane.getComposite();
    }

    protected void performApply() {
        this.performOk();
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.localInstButton.setSelection(false);
        this.remoteInstButton.setSelection(true);
        this.host.setText("localhost");
        this.port.setText("3601");
        this.systemName.setText("");
        this.j2eeInstNr.setText("");
        this.scsInstNr.setText("");
        this.j2eeInstProfile.setText("");
        this.scsInstProfile.setText("");
        this.updatePage();
    }

    public boolean performOk() {
        this.myPrefStore.setValue("MsgSrvHost", this.host.getText());
        this.myPrefStore.setValue("MsgSrvPort", this.port.getText());
        this.myPrefStore.setValue("SystemId", this.systemName.getText());
        this.myPrefStore.setValue("J2eeInst", this.j2eeInstNr.getText());
        this.myPrefStore.setValue("ScsInst", this.scsInstNr.getText());
        this.myPrefStore.setValue("J2eeProfile", this.j2eeInstProfile.getText());
        this.myPrefStore.setValue("ScsProfile", this.scsInstProfile.getText());
        if (this.remoteInstButton.getSelection()) {
            this.myPrefStore.setValue("InstType", 0);
        }
        if (this.localInstButton.getSelection()) {
            this.myPrefStore.setValue("InstType", 1);
        }
        return super.performOk();
    }

    private void updatePage() {
        if (this.localInstButton.getSelection()) {
            ILocalEngine[] localEngines = new ILocalEngine[]{};
            try {
                localEngines = LocalEngineRecognition.get();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.host.setText("");
            this.port.setText("");
            int i = 0;
            while (i < localEngines.length) {
                if (localEngines[i].getSystemName() != null && localEngines[i].getSystemName().equals(this.systemName.getText())) {
                    this.host.setText(localEngines[i].getMsHost());
                    this.port.setText(Integer.toString(localEngines[i].getMsPort()));
                }
                ++i;
            }
        }
        this.host.setEditable(this.remoteInstButton.getSelection());
        this.port.setEditable(this.remoteInstButton.getSelection());
        this.browseButton.setEnabled(this.localInstButton.getSelection());
    }

    private class InnerBrowseButtonSelectionHandler
    extends LabelProvider
    implements SelectionListener {
        private InnerBrowseButtonSelectionHandler() {
        }

        public void widgetDefaultSelected(SelectionEvent evt) {
            this.widgetSelected(evt);
        }

        public void widgetSelected(SelectionEvent e) {
            try {
                Object[] localEngines = LocalEngineRecognition.search();
                ObjectSelectionDialog osd = new ObjectSelectionDialog(EnginePreferencePage.this.getShell(), "Local engine installations", "Please select one");
                osd.setSingleSelection(true);
                osd.setLabelProvider((ILabelProvider)this);
                Object[] ret = osd.openDialog(localEngines);
                if (ret != null && ret.length >= 1 && ret[0] instanceof ILocalEngine) {
                    ILocalEngine engine = (ILocalEngine)ret[0];
                    EnginePreferencePage.this.systemName.setText(engine.getSystemName());
                    EnginePreferencePage.this.host.setText(engine.getMsHost());
                    EnginePreferencePage.this.port.setText(Integer.toString(engine.getMsPort()));
                    EnginePreferencePage.this.remoteHost = engine.getMsHost();
                    EnginePreferencePage.this.remotePort = Integer.toString(engine.getMsPort());
                    EnginePreferencePage.this.j2eeInstNr.setText(Integer.toString(engine.getJ2eeInstNumber()));
                    EnginePreferencePage.this.j2eeInstProfile.setText(engine.getJ2eeProfile().getAbsolutePath());
                    EnginePreferencePage.this.scsInstNr.setText(Integer.toString(engine.getScsInstNumber()));
                    EnginePreferencePage.this.scsInstProfile.setText(engine.getScsProfile().getAbsolutePath());
                }
            }
            catch (Exception ex) {
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error", (String)("No local engine could be found!\nReason : " + ex.getMessage() + "\nPlease configure your engine as remote host installation." + "\nSee error log for more information."));
                EnginePlugin.getTracer().error("No local engine found!", (Throwable)ex);
            }
        }

        public Image getImage(Object element) {
            return SYS_IMAGE;
        }

        public String getText(Object element) {
            String text = "UNKNOWN";
            if (element instanceof ILocalEngine) {
                ILocalEngine engine = (ILocalEngine)element;
                text = engine.getSystemName();
            } else {
                text = "Not an ILocalEngine";
            }
            return text;
        }
    }

    private class InnerNumericFocusListener
    extends FocusAdapter {
        private InnerNumericFocusListener() {
        }

        public void focusLost(FocusEvent e) {
            super.focusLost(e);
            if (e.getSource() instanceof Text) {
                Text textField = (Text)e.getSource();
                try {
                    Integer.parseInt(textField.getText());
                }
                catch (NumberFormatException e2) {
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Conversion error!", (String)"Could not convert port number!");
                    textField.setText("0");
                }
            }
        }
    }

    private class InnerRadioButtonSelectionListener
    implements SelectionListener {
        private InnerRadioButtonSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent evt) {
            this.widgetSelected(evt);
        }

        public void widgetSelected(SelectionEvent evt) {
            EnginePreferencePage.this.updatePage();
        }
    }
}

